/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Oracle Corporation Code.
 *
 * The Initial Developer of the Original Code is
 *   Oracle Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Vladimir Vukicevic <vladimir.vukicevic@oracle.com>
 *   Matthew Willis <lilmatt@mozilla.com>
 *   Dan Mosedale <dmose@mozilla.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
 ** Automagically generated via maketzdata.pl from zones.tab
 ** DO NOT EDIT BY HAND
 **/

typedef struct {
    /* the tzid  for this */
    char *tzid;

    /* latitude and longitude, in +/-HHMMSS format */
    char *latitude;
    char *longitude;

    /* the ics VTIMEZONE component */
    char *icstimezone;
} ical_timezone_data_struct;

static ical_timezone_data_struct ical_timezone_data[] = {
{
	"/mozilla.org/20070129_1/Africa/Abidjan",
	"+0051900", "-0040200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Abidjan\nX-LIC-LOCATION:Africa/Abidjan\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Accra",
	"+0053300", "+0001300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Accra\nX-LIC-LOCATION:Africa/Accra\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Addis_Ababa",
	"+0090200", "+0384200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Addis_Ababa\nX-LIC-LOCATION:Africa/Addis_Ababa\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Algiers",
	"+0364700", "+0030300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Algiers\nX-LIC-LOCATION:Africa/Algiers\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Asmara",
	"+0152000", "+0385300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Asmara\nX-LIC-LOCATION:Africa/Asmara\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Bamako",
	"+0123900", "-0080000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Bamako\nX-LIC-LOCATION:Africa/Bamako\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Bangui",
	"+0042200", "+0183500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Bangui\nX-LIC-LOCATION:Africa/Bangui\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Banjul",
	"+0132800", "-0163900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Banjul\nX-LIC-LOCATION:Africa/Banjul\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Bissau",
	"+0115100", "-0153500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Bissau\nX-LIC-LOCATION:Africa/Bissau\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Blantyre",
	"-0154700", "+0350000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Blantyre\nX-LIC-LOCATION:Africa/Blantyre\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Brazzaville",
	"-0041600", "+0151700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Brazzaville\nX-LIC-LOCATION:Africa/Brazzaville\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Bujumbura",
	"-0032300", "+0292200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Bujumbura\nX-LIC-LOCATION:Africa/Bujumbura\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Cairo",
	"+0300300", "+0311500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Cairo\nX-LIC-LOCATION:Africa/Cairo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700424T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=-1FR\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19700924T230000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1TH\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Casablanca",
	"+0333900", "-0073500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Casablanca\nX-LIC-LOCATION:Africa/Casablanca\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Ceuta",
	"+0355300", "-0051900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Ceuta\nX-LIC-LOCATION:Africa/Ceuta\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Conakry",
	"+0093100", "-0134300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Conakry\nX-LIC-LOCATION:Africa/Conakry\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Dakar",
	"+0144000", "-0172600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Dakar\nX-LIC-LOCATION:Africa/Dakar\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Dar_es_Salaam",
	"-0064800", "+0391700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Dar_es_Salaam\nX-LIC-LOCATION:Africa/Dar_es_Salaam\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Djibouti",
	"+0113600", "+0430900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Djibouti\nX-LIC-LOCATION:Africa/Djibouti\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Douala",
	"+0040300", "+0094200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Douala\nX-LIC-LOCATION:Africa/Douala\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/El_Aaiun",
	"+0270900", "-0131200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/El_Aaiun\nX-LIC-LOCATION:Africa/El_Aaiun\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Freetown",
	"+0083000", "-0131500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Freetown\nX-LIC-LOCATION:Africa/Freetown\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Gaborone",
	"-0254500", "+0255500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Gaborone\nX-LIC-LOCATION:Africa/Gaborone\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Harare",
	"-0175000", "+0310300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Harare\nX-LIC-LOCATION:Africa/Harare\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Johannesburg",
	"-0261500", "+0280000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Johannesburg\nX-LIC-LOCATION:Africa/Johannesburg\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:SAST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Kampala",
	"+0001900", "+0322500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Kampala\nX-LIC-LOCATION:Africa/Kampala\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Khartoum",
	"+0153600", "+0323200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Khartoum\nX-LIC-LOCATION:Africa/Khartoum\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Kigali",
	"-0015700", "+0300400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Kigali\nX-LIC-LOCATION:Africa/Kigali\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Kinshasa",
	"-0041800", "+0151800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Kinshasa\nX-LIC-LOCATION:Africa/Kinshasa\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Lagos",
	"+0062700", "+0032400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Lagos\nX-LIC-LOCATION:Africa/Lagos\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Libreville",
	"+0002300", "+0092700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Libreville\nX-LIC-LOCATION:Africa/Libreville\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Lome",
	"+0060800", "+0011300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Lome\nX-LIC-LOCATION:Africa/Lome\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Luanda",
	"-0084800", "+0131400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Luanda\nX-LIC-LOCATION:Africa/Luanda\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Lubumbashi",
	"-0114000", "+0272800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Lubumbashi\nX-LIC-LOCATION:Africa/Lubumbashi\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Lusaka",
	"-0152500", "+0281700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Lusaka\nX-LIC-LOCATION:Africa/Lusaka\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Malabo",
	"+0034500", "+0084700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Malabo\nX-LIC-LOCATION:Africa/Malabo\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Maputo",
	"-0255800", "+0323500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Maputo\nX-LIC-LOCATION:Africa/Maputo\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:CAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Maseru",
	"-0292800", "+0273000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Maseru\nX-LIC-LOCATION:Africa/Maseru\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:SAST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Mbabane",
	"-0261800", "+0310600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Mbabane\nX-LIC-LOCATION:Africa/Mbabane\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:SAST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Mogadishu",
	"+0020400", "+0452200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Mogadishu\nX-LIC-LOCATION:Africa/Mogadishu\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Monrovia",
	"+0061800", "-0104700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Monrovia\nX-LIC-LOCATION:Africa/Monrovia\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Nairobi",
	"-0011700", "+0364900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Nairobi\nX-LIC-LOCATION:Africa/Nairobi\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Ndjamena",
	"+0120700", "+0150300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Ndjamena\nX-LIC-LOCATION:Africa/Ndjamena\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Niamey",
	"+0133100", "+0020700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Niamey\nX-LIC-LOCATION:Africa/Niamey\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Nouakchott",
	"+0180600", "-0155700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Nouakchott\nX-LIC-LOCATION:Africa/Nouakchott\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Ouagadougou",
	"+0122200", "-0013100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Ouagadougou\nX-LIC-LOCATION:Africa/Ouagadougou\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Porto-Novo",
	"+0062900", "+0023700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Porto-Novo\nX-LIC-LOCATION:Africa/Porto-Novo\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Sao_Tome",
	"+0002000", "+0064400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Sao_Tome\nX-LIC-LOCATION:Africa/Sao_Tome\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Tripoli",
	"+0325400", "+0131100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Tripoli\nX-LIC-LOCATION:Africa/Tripoli\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Tunis",
	"+0364800", "+0101100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Tunis\nX-LIC-LOCATION:Africa/Tunis\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Africa/Windhoek",
	"-0223400", "+0170600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Africa/Windhoek\nX-LIC-LOCATION:Africa/Windhoek\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:WAST\nDTSTART:19700906T020000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:WAT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Adak",
	"+0515248", "-1763929",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Adak\nX-LIC-LOCATION:America/Adak\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-1000\nTZOFFSETTO:-0900\nTZNAME:HADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0900\nTZOFFSETTO:-1000\nTZNAME:HAST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Anchorage",
	"+0611305", "-1495401",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Anchorage\nX-LIC-LOCATION:America/Anchorage\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0900\nTZOFFSETTO:-0800\nTZNAME:AKDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0900\nTZNAME:AKST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Anguilla",
	"+0181200", "-0630400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Anguilla\nX-LIC-LOCATION:America/Anguilla\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Antigua",
	"+0170300", "-0614800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Antigua\nX-LIC-LOCATION:America/Antigua\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Araguaina",
	"-0071200", "-0481200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Araguaina\nX-LIC-LOCATION:America/Araguaina\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Buenos_Aires",
	"-0343600", "-0582700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Buenos_Aires\nX-LIC-LOCATION:America/Argentina/Buenos_Aires\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Catamarca",
	"-0282800", "-0654700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Catamarca\nX-LIC-LOCATION:America/Argentina/Catamarca\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Cordoba",
	"-0312400", "-0641100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Cordoba\nX-LIC-LOCATION:America/Argentina/Cordoba\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Jujuy",
	"-0241100", "-0651800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Jujuy\nX-LIC-LOCATION:America/Argentina/Jujuy\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/La_Rioja",
	"-0292600", "-0665100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/La_Rioja\nX-LIC-LOCATION:America/Argentina/La_Rioja\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Mendoza",
	"-0325300", "-0684900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Mendoza\nX-LIC-LOCATION:America/Argentina/Mendoza\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Rio_Gallegos",
	"-0513800", "-0691300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Rio_Gallegos\nX-LIC-LOCATION:America/Argentina/Rio_Gallegos\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/San_Juan",
	"-0313200", "-0683100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/San_Juan\nX-LIC-LOCATION:America/Argentina/San_Juan\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Tucuman",
	"-0264900", "-0651300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Tucuman\nX-LIC-LOCATION:America/Argentina/Tucuman\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Argentina/Ushuaia",
	"-0544800", "-0681800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Argentina/Ushuaia\nX-LIC-LOCATION:America/Argentina/Ushuaia\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Aruba",
	"+0123000", "-0685800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Aruba\nX-LIC-LOCATION:America/Aruba\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Asuncion",
	"-0251600", "-0574000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Asuncion\nX-LIC-LOCATION:America/Asuncion\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:PYST\nDTSTART:19701018T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=3SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:PYT\nDTSTART:19700308T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Atikokan",
	"+0484531", "-0913718",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Atikokan\nX-LIC-LOCATION:America/Atikokan\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Bahia",
	"-0125900", "-0383100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Bahia\nX-LIC-LOCATION:America/Bahia\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Barbados",
	"+0130600", "-0593700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Barbados\nX-LIC-LOCATION:America/Barbados\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Belem",
	"-0012700", "-0482900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Belem\nX-LIC-LOCATION:America/Belem\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Belize",
	"+0173000", "-0881200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Belize\nX-LIC-LOCATION:America/Belize\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Blanc-Sablon",
	"+0512500", "-0570700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Blanc-Sablon\nX-LIC-LOCATION:America/Blanc-Sablon\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Boa_Vista",
	"+0024900", "-0604000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Boa_Vista\nX-LIC-LOCATION:America/Boa_Vista\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Bogota",
	"+0043600", "-0740500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Bogota\nX-LIC-LOCATION:America/Bogota\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:COT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Boise",
	"+0433649", "-1161209",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Boise\nX-LIC-LOCATION:America/Boise\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Cambridge_Bay",
	"+0690300", "-1050500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Cambridge_Bay\nX-LIC-LOCATION:America/Cambridge_Bay\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Campo_Grande",
	"-0202700", "-0543700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Campo_Grande\nX-LIC-LOCATION:America/Campo_Grande\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:AMST\nDTSTART:19701101T000000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AMT\nDTSTART:19700222T000000\nRRULE:FREQ=YEARLY;BYMONTH=2;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Cancun",
	"+0210500", "-0864600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Cancun\nX-LIC-LOCATION:America/Cancun\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Caracas",
	"+0103000", "-0665600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Caracas\nX-LIC-LOCATION:America/Caracas\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:VET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Cayenne",
	"+0045600", "-0522000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Cayenne\nX-LIC-LOCATION:America/Cayenne\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:GFT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Cayman",
	"+0191800", "-0812300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Cayman\nX-LIC-LOCATION:America/Cayman\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Chicago",
	"+0415100", "-0873900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Chicago\nX-LIC-LOCATION:America/Chicago\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Chihuahua",
	"+0283800", "-1060500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Chihuahua\nX-LIC-LOCATION:America/Chihuahua\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Costa_Rica",
	"+0095600", "-0840500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Costa_Rica\nX-LIC-LOCATION:America/Costa_Rica\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Cuiaba",
	"-0153500", "-0560500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Cuiaba\nX-LIC-LOCATION:America/Cuiaba\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:AMST\nDTSTART:19701101T000000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AMT\nDTSTART:19700222T000000\nRRULE:FREQ=YEARLY;BYMONTH=2;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Curacao",
	"+0121100", "-0690000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Curacao\nX-LIC-LOCATION:America/Curacao\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Danmarkshavn",
	"+0764600", "-0184000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Danmarkshavn\nX-LIC-LOCATION:America/Danmarkshavn\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Dawson",
	"+0640400", "-1392500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Dawson\nX-LIC-LOCATION:America/Dawson\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0700\nTZNAME:PDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Dawson_Creek",
	"+0594600", "-1201400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Dawson_Creek\nX-LIC-LOCATION:America/Dawson_Creek\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Denver",
	"+0394421", "-1045903",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Denver\nX-LIC-LOCATION:America/Denver\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Detroit",
	"+0421953", "-0830245",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Detroit\nX-LIC-LOCATION:America/Detroit\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Dominica",
	"+0151800", "-0612400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Dominica\nX-LIC-LOCATION:America/Dominica\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Edmonton",
	"+0533300", "-1132800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Edmonton\nX-LIC-LOCATION:America/Edmonton\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Eirunepe",
	"-0064000", "-0695200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Eirunepe\nX-LIC-LOCATION:America/Eirunepe\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:ACT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/El_Salvador",
	"+0134200", "-0891200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/El_Salvador\nX-LIC-LOCATION:America/El_Salvador\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Fortaleza",
	"-0034300", "-0383000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Fortaleza\nX-LIC-LOCATION:America/Fortaleza\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Glace_Bay",
	"+0461200", "-0595700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Glace_Bay\nX-LIC-LOCATION:America/Glace_Bay\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Godthab",
	"+0641100", "-0514400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Godthab\nX-LIC-LOCATION:America/Godthab\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0200\nTZNAME:WGST\nDTSTART:19700328T220000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0300\nTZNAME:WGT\nDTSTART:19701024T230000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SA\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Goose_Bay",
	"+0532000", "-0602500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Goose_Bay\nX-LIC-LOCATION:America/Goose_Bay\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T000100\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T000100\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Grand_Turk",
	"+0212800", "-0710800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Grand_Turk\nX-LIC-LOCATION:America/Grand_Turk\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Grenada",
	"+0120300", "-0614500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Grenada\nX-LIC-LOCATION:America/Grenada\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Guadeloupe",
	"+0161400", "-0613200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Guadeloupe\nX-LIC-LOCATION:America/Guadeloupe\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Guatemala",
	"+0143800", "-0903100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Guatemala\nX-LIC-LOCATION:America/Guatemala\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Guayaquil",
	"-0021000", "-0795000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Guayaquil\nX-LIC-LOCATION:America/Guayaquil\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:ECT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Guyana",
	"+0064800", "-0581000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Guyana\nX-LIC-LOCATION:America/Guyana\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:GYT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Halifax",
	"+0443900", "-0633600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Halifax\nX-LIC-LOCATION:America/Halifax\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Havana",
	"+0230800", "-0822200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Havana\nX-LIC-LOCATION:America/Havana\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:CST\nDTSTART:19701025T010000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:CDT\nDTSTART:19700405T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Hermosillo",
	"+0290400", "-1105800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Hermosillo\nX-LIC-LOCATION:America/Hermosillo\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Indianapolis",
	"+0394606", "-0860929",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Indianapolis\nX-LIC-LOCATION:America/Indiana/Indianapolis\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Knox",
	"+0411745", "-0863730",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Knox\nX-LIC-LOCATION:America/Indiana/Knox\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Marengo",
	"+0382232", "-0862041",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Marengo\nX-LIC-LOCATION:America/Indiana/Marengo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Petersburg",
	"+0382931", "-0871643",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Petersburg\nX-LIC-LOCATION:America/Indiana/Petersburg\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Vevay",
	"+0384452", "-0850402",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Vevay\nX-LIC-LOCATION:America/Indiana/Vevay\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Indiana/Vincennes",
	"+0384038", "-0873143",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Indiana/Vincennes\nX-LIC-LOCATION:America/Indiana/Vincennes\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Inuvik",
	"+0682059", "-1334300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Inuvik\nX-LIC-LOCATION:America/Inuvik\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Iqaluit",
	"+0634400", "-0682800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Iqaluit\nX-LIC-LOCATION:America/Iqaluit\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Jamaica",
	"+0180000", "-0764800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Jamaica\nX-LIC-LOCATION:America/Jamaica\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Juneau",
	"+0581807", "-1342511",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Juneau\nX-LIC-LOCATION:America/Juneau\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0900\nTZOFFSETTO:-0800\nTZNAME:AKDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0900\nTZNAME:AKST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Kentucky/Louisville",
	"+0381515", "-0854534",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Kentucky/Louisville\nX-LIC-LOCATION:America/Kentucky/Louisville\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Kentucky/Monticello",
	"+0364947", "-0845057",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Kentucky/Monticello\nX-LIC-LOCATION:America/Kentucky/Monticello\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/La_Paz",
	"-0163000", "-0680900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/La_Paz\nX-LIC-LOCATION:America/La_Paz\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:BOT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Lima",
	"-0120300", "-0770300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Lima\nX-LIC-LOCATION:America/Lima\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:PET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Los_Angeles",
	"+0340308", "-1181434",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Los_Angeles\nX-LIC-LOCATION:America/Los_Angeles\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0700\nTZNAME:PDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Maceio",
	"-0094000", "-0354300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Maceio\nX-LIC-LOCATION:America/Maceio\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Managua",
	"+0120900", "-0861700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Managua\nX-LIC-LOCATION:America/Managua\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Manaus",
	"-0030800", "-0600100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Manaus\nX-LIC-LOCATION:America/Manaus\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Martinique",
	"+0143600", "-0610500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Martinique\nX-LIC-LOCATION:America/Martinique\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Mazatlan",
	"+0231300", "-1062500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Mazatlan\nX-LIC-LOCATION:America/Mazatlan\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Menominee",
	"+0450628", "-0873651",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Menominee\nX-LIC-LOCATION:America/Menominee\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Merida",
	"+0205800", "-0893700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Merida\nX-LIC-LOCATION:America/Merida\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Mexico_City",
	"+0192400", "-0990900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Mexico_City\nX-LIC-LOCATION:America/Mexico_City\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Miquelon",
	"+0470300", "-0562000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Miquelon\nX-LIC-LOCATION:America/Miquelon\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0200\nTZNAME:PMDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0300\nTZNAME:PMST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Moncton",
	"+0460600", "-0644700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Moncton\nX-LIC-LOCATION:America/Moncton\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Monterrey",
	"+0254000", "-1001900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Monterrey\nX-LIC-LOCATION:America/Monterrey\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Montevideo",
	"-0345300", "-0561100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Montevideo\nX-LIC-LOCATION:America/Montevideo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0200\nTZNAME:UYST\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0300\nTZNAME:UYT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Montreal",
	"+0453100", "-0733400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Montreal\nX-LIC-LOCATION:America/Montreal\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Montserrat",
	"+0164300", "-0621300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Montserrat\nX-LIC-LOCATION:America/Montserrat\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Nassau",
	"+0250500", "-0772100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Nassau\nX-LIC-LOCATION:America/Nassau\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/New_York",
	"+0404251", "-0740023",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/New_York\nX-LIC-LOCATION:America/New_York\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Nipigon",
	"+0490100", "-0881600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Nipigon\nX-LIC-LOCATION:America/Nipigon\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Nome",
	"+0643004", "-1652423",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Nome\nX-LIC-LOCATION:America/Nome\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0900\nTZOFFSETTO:-0800\nTZNAME:AKDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0900\nTZNAME:AKST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Noronha",
	"-0035100", "-0322500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Noronha\nX-LIC-LOCATION:America/Noronha\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0200\nTZNAME:FNT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/North_Dakota/Center",
	"+0470659", "-1011757",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/North_Dakota/Center\nX-LIC-LOCATION:America/North_Dakota/Center\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/North_Dakota/New_Salem",
	"+0465042", "-1012439",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/North_Dakota/New_Salem\nX-LIC-LOCATION:America/North_Dakota/New_Salem\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Panama",
	"+0085800", "-0793200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Panama\nX-LIC-LOCATION:America/Panama\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Pangnirtung",
	"+0660800", "-0654400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Pangnirtung\nX-LIC-LOCATION:America/Pangnirtung\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Paramaribo",
	"+0055000", "-0551000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Paramaribo\nX-LIC-LOCATION:America/Paramaribo\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:SRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Phoenix",
	"+0332654", "-1120424",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Phoenix\nX-LIC-LOCATION:America/Phoenix\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Port-au-Prince",
	"+0183200", "-0722000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Port-au-Prince\nX-LIC-LOCATION:America/Port-au-Prince\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700405T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701025T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Port_of_Spain",
	"+0103900", "-0613100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Port_of_Spain\nX-LIC-LOCATION:America/Port_of_Spain\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Porto_Velho",
	"-0084600", "-0635400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Porto_Velho\nX-LIC-LOCATION:America/Porto_Velho\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Puerto_Rico",
	"+0182806", "-0660622",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Puerto_Rico\nX-LIC-LOCATION:America/Puerto_Rico\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Rainy_River",
	"+0484300", "-0943400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Rainy_River\nX-LIC-LOCATION:America/Rainy_River\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Rankin_Inlet",
	"+0624900", "-0920459",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Rankin_Inlet\nX-LIC-LOCATION:America/Rankin_Inlet\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Recife",
	"-0080300", "-0345400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Recife\nX-LIC-LOCATION:America/Recife\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Regina",
	"+0502400", "-1043900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Regina\nX-LIC-LOCATION:America/Regina\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Rio_Branco",
	"-0095800", "-0674800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Rio_Branco\nX-LIC-LOCATION:America/Rio_Branco\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0500\nTZNAME:ACT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Santiago",
	"-0332700", "-0704000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Santiago\nX-LIC-LOCATION:America/Santiago\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:CLST\nDTSTART:19701011T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:CLT\nDTSTART:19700315T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Santo_Domingo",
	"+0182800", "-0695400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Santo_Domingo\nX-LIC-LOCATION:America/Santo_Domingo\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Sao_Paulo",
	"-0233200", "-0463700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Sao_Paulo\nX-LIC-LOCATION:America/Sao_Paulo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0200\nTZNAME:BRST\nDTSTART:19701101T000000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0300\nTZNAME:BRT\nDTSTART:19700222T000000\nRRULE:FREQ=YEARLY;BYMONTH=2;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Scoresbysund",
	"+0702900", "-0215800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Scoresbysund\nX-LIC-LOCATION:America/Scoresbysund\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0100\nTZOFFSETTO:+0000\nTZNAME:EGST\nDTSTART:19700329T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:-0100\nTZNAME:EGT\nDTSTART:19701025T010000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Shiprock",
	"+0364708", "-1084111",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Shiprock\nX-LIC-LOCATION:America/Shiprock\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/St_Johns",
	"+0473400", "-0524300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/St_Johns\nX-LIC-LOCATION:America/St_Johns\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0330\nTZOFFSETTO:-0230\nTZNAME:NDT\nDTSTART:19700308T000100\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0230\nTZOFFSETTO:-0330\nTZNAME:NST\nDTSTART:19701101T000100\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/St_Kitts",
	"+0171800", "-0624300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/St_Kitts\nX-LIC-LOCATION:America/St_Kitts\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/St_Lucia",
	"+0140100", "-0610000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/St_Lucia\nX-LIC-LOCATION:America/St_Lucia\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/St_Thomas",
	"+0182100", "-0645600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/St_Thomas\nX-LIC-LOCATION:America/St_Thomas\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/St_Vincent",
	"+0130900", "-0611400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/St_Vincent\nX-LIC-LOCATION:America/St_Vincent\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Swift_Current",
	"+0501700", "-1075000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Swift_Current\nX-LIC-LOCATION:America/Swift_Current\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Tegucigalpa",
	"+0140600", "-0871300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Tegucigalpa\nX-LIC-LOCATION:America/Tegucigalpa\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700503T000000\nRRULE:FREQ=YEARLY;BYMONTH=5;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19700803T000000\nRRULE:FREQ=YEARLY;BYMONTH=8;BYDAY=1MO\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Thule",
	"+0763400", "-0684700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Thule\nX-LIC-LOCATION:America/Thule\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Thunder_Bay",
	"+0482300", "-0891500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Thunder_Bay\nX-LIC-LOCATION:America/Thunder_Bay\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Tijuana",
	"+0323200", "-1170100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Tijuana\nX-LIC-LOCATION:America/Tijuana\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0700\nTZNAME:PDT\nDTSTART:19700405T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Toronto",
	"+0433900", "-0792300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Toronto\nX-LIC-LOCATION:America/Toronto\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0400\nTZNAME:EDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0500\nTZNAME:EST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Tortola",
	"+0182700", "-0643700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Tortola\nX-LIC-LOCATION:America/Tortola\nBEGIN:STANDARD\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Vancouver",
	"+0491600", "-1230700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Vancouver\nX-LIC-LOCATION:America/Vancouver\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0700\nTZNAME:PDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Whitehorse",
	"+0604300", "-1350300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Whitehorse\nX-LIC-LOCATION:America/Whitehorse\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0700\nTZNAME:PDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Winnipeg",
	"+0495300", "-0970900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Winnipeg\nX-LIC-LOCATION:America/Winnipeg\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:CDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:CST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Yakutat",
	"+0593249", "-1394338",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Yakutat\nX-LIC-LOCATION:America/Yakutat\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0900\nTZOFFSETTO:-0800\nTZNAME:AKDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0900\nTZNAME:AKST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/America/Yellowknife",
	"+0622700", "-1142100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/America/Yellowknife\nX-LIC-LOCATION:America/Yellowknife\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0700\nTZOFFSETTO:-0600\nTZNAME:MDT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0700\nTZNAME:MST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Casey",
	"-0661700", "+1103100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Casey\nX-LIC-LOCATION:Antarctica/Casey\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:WST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Davis",
	"-0683500", "+0775800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Davis\nX-LIC-LOCATION:Antarctica/Davis\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:DAVT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/DumontDUrville",
	"-0664000", "+1400100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/DumontDUrville\nX-LIC-LOCATION:Antarctica/DumontDUrville\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:DDUT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Mawson",
	"-0673600", "+0625300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Mawson\nX-LIC-LOCATION:Antarctica/Mawson\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:MAWT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/McMurdo",
	"-0775000", "+1663600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/McMurdo\nX-LIC-LOCATION:Antarctica/McMurdo\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1200\nTZNAME:NZST\nDTSTART:19700315T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=3SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1300\nTZNAME:NZDT\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Palmer",
	"-0644800", "-0640600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Palmer\nX-LIC-LOCATION:Antarctica/Palmer\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:CLST\nDTSTART:19701011T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:CLT\nDTSTART:19700315T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Rothera",
	"-0673400", "-0680800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Rothera\nX-LIC-LOCATION:Antarctica/Rothera\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0300\nTZNAME:ROTT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/South_Pole",
	"-0900000", "+0000000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/South_Pole\nX-LIC-LOCATION:Antarctica/South_Pole\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1200\nTZNAME:NZST\nDTSTART:19700315T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=3SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1300\nTZNAME:NZDT\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Syowa",
	"-0690022", "+0393524",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Syowa\nX-LIC-LOCATION:Antarctica/Syowa\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:SYOT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Antarctica/Vostok",
	"-0782400", "+1065400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Antarctica/Vostok\nX-LIC-LOCATION:Antarctica/Vostok\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:VOST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Arctic/Longyearbyen",
	"+0780000", "+0160000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Arctic/Longyearbyen\nX-LIC-LOCATION:Arctic/Longyearbyen\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Aden",
	"+0124500", "+0451200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Aden\nX-LIC-LOCATION:Asia/Aden\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Almaty",
	"+0431500", "+0765700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Almaty\nX-LIC-LOCATION:Asia/Almaty\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:ALMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Amman",
	"+0315700", "+0355600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Amman\nX-LIC-LOCATION:Asia/Amman\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700326T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1TH\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701030T010000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1FR\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Anadyr",
	"+0644500", "+1772900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Anadyr\nX-LIC-LOCATION:Asia/Anadyr\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1300\nTZNAME:ANAST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1200\nTZNAME:ANAT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Aqtau",
	"+0443100", "+0501600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Aqtau\nX-LIC-LOCATION:Asia/Aqtau\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:AQTT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Aqtobe",
	"+0501700", "+0571000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Aqtobe\nX-LIC-LOCATION:Asia/Aqtobe\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:AQTT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Ashgabat",
	"+0375700", "+0582300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Ashgabat\nX-LIC-LOCATION:Asia/Ashgabat\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:TMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Baghdad",
	"+0332100", "+0442500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Baghdad\nX-LIC-LOCATION:Asia/Baghdad\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0400\nTZNAME:ADT\nDTSTART:19700401T030000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19701001T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Bahrain",
	"+0262300", "+0503500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Bahrain\nX-LIC-LOCATION:Asia/Bahrain\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Baku",
	"+0402300", "+0495100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Baku\nX-LIC-LOCATION:Asia/Baku\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0500\nTZNAME:AZST\nDTSTART:19700329T040000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0400\nTZNAME:AZT\nDTSTART:19701025T050000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Bangkok",
	"+0134500", "+1003100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Bangkok\nX-LIC-LOCATION:Asia/Bangkok\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:ICT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Beirut",
	"+0335300", "+0353000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Beirut\nX-LIC-LOCATION:Asia/Beirut\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Bishkek",
	"+0425400", "+0743600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Bishkek\nX-LIC-LOCATION:Asia/Bishkek\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:KGT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Brunei",
	"+0045600", "+1145500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Brunei\nX-LIC-LOCATION:Asia/Brunei\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:BNT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Calcutta",
	"+0223200", "+0882200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Calcutta\nX-LIC-LOCATION:Asia/Calcutta\nBEGIN:STANDARD\nTZOFFSETFROM:+0530\nTZOFFSETTO:+0530\nTZNAME:IST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Choibalsan",
	"+0480400", "+1143000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Choibalsan\nX-LIC-LOCATION:Asia/Choibalsan\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+0900\nTZNAME:CHOT\nDTSTART:19700926T020000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0900\nTZOFFSETTO:+1000\nTZNAME:CHOST\nDTSTART:19700328T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Chongqing",
	"+0293400", "+1063500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Chongqing\nX-LIC-LOCATION:Asia/Chongqing\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Colombo",
	"+0065600", "+0795100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Colombo\nX-LIC-LOCATION:Asia/Colombo\nBEGIN:STANDARD\nTZOFFSETFROM:+0530\nTZOFFSETTO:+0530\nTZNAME:IST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Damascus",
	"+0333000", "+0361800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Damascus\nX-LIC-LOCATION:Asia/Damascus\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700401T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701001T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Dhaka",
	"+0234300", "+0902500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Dhaka\nX-LIC-LOCATION:Asia/Dhaka\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:BDT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Dili",
	"-0083300", "+1253500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Dili\nX-LIC-LOCATION:Asia/Dili\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:TLT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Dubai",
	"+0251800", "+0551800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Dubai\nX-LIC-LOCATION:Asia/Dubai\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:GST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Dushanbe",
	"+0383500", "+0684800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Dushanbe\nX-LIC-LOCATION:Asia/Dushanbe\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:TJT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Gaza",
	"+0313000", "+0342800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Gaza\nX-LIC-LOCATION:Asia/Gaza\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700401T000000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701016T000000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=3FR\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Harbin",
	"+0454500", "+1264100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Harbin\nX-LIC-LOCATION:Asia/Harbin\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Hong_Kong",
	"+0221700", "+1140900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Hong_Kong\nX-LIC-LOCATION:Asia/Hong_Kong\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:HKT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Hovd",
	"+0480100", "+0913900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Hovd\nX-LIC-LOCATION:Asia/Hovd\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0700\nTZNAME:HOVT\nDTSTART:19700926T020000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0800\nTZNAME:HOVST\nDTSTART:19700328T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Irkutsk",
	"+0521600", "+1042000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Irkutsk\nX-LIC-LOCATION:Asia/Irkutsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0900\nTZNAME:IRKST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0800\nTZNAME:IRKT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Istanbul",
	"+0410100", "+0285800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Istanbul\nX-LIC-LOCATION:Asia/Istanbul\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Jakarta",
	"-0061000", "+1064800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Jakarta\nX-LIC-LOCATION:Asia/Jakarta\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:WIT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Jayapura",
	"-0023200", "+1404200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Jayapura\nX-LIC-LOCATION:Asia/Jayapura\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:EIT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Jerusalem",
	"+0314600", "+0351400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Jerusalem\nX-LIC-LOCATION:Asia/Jerusalem\nBEGIN:STANDARD\nTZOFFSETFROM:+022056\nTZOFFSETTO:+022040\nTZNAME:JMT\nDTSTART:18800101T000000\nRDATE:18800101T000000\nEND:STANDARD\nBEGIN:STANDARD\nTZOFFSETFROM:+022040\nTZOFFSETTO:+0200\nTZNAME:IST\nDTSTART:19180101T000000\nRDATE:19180101T000000\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:IDT\nDTSTART:19400601T000000\nRDATE:20000414T020000\nRDATE:20010409T010000\nRDATE:20020329T010000\nRDATE:20030328T010000\nRDATE:20040407T010000\nRDATE:20050401T020000\nRDATE:20060331T020000\nRDATE:20070330T020000\nRDATE:20080328T020000\nRDATE:20090327T020000\nRDATE:20100326T020000\nRDATE:20110401T020000\nRDATE:20120330T020000\nRDATE:20130329T020000\nRDATE:20140328T020000\nRDATE:20150327T020000\nRDATE:20160401T020000\nRDATE:20170331T020000\nRDATE:20180330T020000\nRDATE:20190329T020000\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:IST\nDTSTART:19421101T000000\nRDATE:19421101T000000\nRDATE:20001006T010000\nRDATE:20010924T010000\nRDATE:20021007T010000\nRDATE:20031003T010000\nRDATE:20040922T010000\nRDATE:20051009T020000\nRDATE:20061001T020000\nRDATE:20070916T020000\nRDATE:20081005T020000\nRDATE:20090927T020000\nRDATE:20100912T020000\nRDATE:20111002T020000\nRDATE:20120923T020000\nRDATE:20130908T020000\nRDATE:20140928T020000\nRDATE:20150920T020000\nRDATE:20161009T020000\nRDATE:20170924T020000\nRDATE:20180916T020000\nRDATE:20191006T020000\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0400\nTZNAME:IDDT\nDTSTART:19480523T000000\nRDATE:19480523T000000\nEND:DAYLIGHT\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0300\nTZNAME:IDT\nDTSTART:19480901T000000\nRDATE:19480901T000000\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kabul",
	"+0343100", "+0691200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kabul\nX-LIC-LOCATION:Asia/Kabul\nBEGIN:STANDARD\nTZOFFSETFROM:+0430\nTZOFFSETTO:+0430\nTZNAME:AFT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kamchatka",
	"+0530100", "+1583900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kamchatka\nX-LIC-LOCATION:Asia/Kamchatka\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1300\nTZNAME:PETST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1200\nTZNAME:PETT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Karachi",
	"+0245200", "+0670300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Karachi\nX-LIC-LOCATION:Asia/Karachi\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:PKT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kashgar",
	"+0392900", "+0755900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kashgar\nX-LIC-LOCATION:Asia/Kashgar\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Katmandu",
	"+0274300", "+0851900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Katmandu\nX-LIC-LOCATION:Asia/Katmandu\nBEGIN:STANDARD\nTZOFFSETFROM:+0545\nTZOFFSETTO:+0545\nTZNAME:NPT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Krasnoyarsk",
	"+0560100", "+0925000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Krasnoyarsk\nX-LIC-LOCATION:Asia/Krasnoyarsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0800\nTZNAME:KRAST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0700\nTZNAME:KRAT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kuala_Lumpur",
	"+0031000", "+1014200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kuala_Lumpur\nX-LIC-LOCATION:Asia/Kuala_Lumpur\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:MYT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kuching",
	"+0013300", "+1102000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kuching\nX-LIC-LOCATION:Asia/Kuching\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:MYT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Kuwait",
	"+0292000", "+0475900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Kuwait\nX-LIC-LOCATION:Asia/Kuwait\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Macau",
	"+0221400", "+1133500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Macau\nX-LIC-LOCATION:Asia/Macau\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Magadan",
	"+0593400", "+1504800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Magadan\nX-LIC-LOCATION:Asia/Magadan\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1200\nTZNAME:MAGST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1100\nTZNAME:MAGT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Makassar",
	"-0050700", "+1192400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Makassar\nX-LIC-LOCATION:Asia/Makassar\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CIT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Manila",
	"+0143500", "+1210000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Manila\nX-LIC-LOCATION:Asia/Manila\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:PHT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Muscat",
	"+0233600", "+0583500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Muscat\nX-LIC-LOCATION:Asia/Muscat\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:GST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Nicosia",
	"+0351000", "+0332200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Nicosia\nX-LIC-LOCATION:Asia/Nicosia\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Novosibirsk",
	"+0550200", "+0825500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Novosibirsk\nX-LIC-LOCATION:Asia/Novosibirsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0700\nTZNAME:NOVST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0600\nTZNAME:NOVT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Omsk",
	"+0550000", "+0732400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Omsk\nX-LIC-LOCATION:Asia/Omsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0700\nTZNAME:OMSST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0600\nTZNAME:OMST\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Oral",
	"+0511300", "+0512100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Oral\nX-LIC-LOCATION:Asia/Oral\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:ORAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Phnom_Penh",
	"+0113300", "+1045500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Phnom_Penh\nX-LIC-LOCATION:Asia/Phnom_Penh\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:ICT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Pontianak",
	"+0000200", "+1092000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Pontianak\nX-LIC-LOCATION:Asia/Pontianak\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:WIT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Pyongyang",
	"+0390100", "+1254500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Pyongyang\nX-LIC-LOCATION:Asia/Pyongyang\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:KST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Qatar",
	"+0251700", "+0513200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Qatar\nX-LIC-LOCATION:Asia/Qatar\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Qyzylorda",
	"+0444800", "+0652800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Qyzylorda\nX-LIC-LOCATION:Asia/Qyzylorda\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:QYZT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Rangoon",
	"+0164700", "+0961000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Rangoon\nX-LIC-LOCATION:Asia/Rangoon\nBEGIN:STANDARD\nTZOFFSETFROM:+0630\nTZOFFSETTO:+0630\nTZNAME:MMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Riyadh",
	"+0243800", "+0464300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Riyadh\nX-LIC-LOCATION:Asia/Riyadh\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:AST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Saigon",
	"+0104500", "+1064000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Saigon\nX-LIC-LOCATION:Asia/Saigon\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:ICT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Sakhalin",
	"+0465800", "+1424200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Sakhalin\nX-LIC-LOCATION:Asia/Sakhalin\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1000\nTZNAME:SAKT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:SAKST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Samarkand",
	"+0394000", "+0664800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Samarkand\nX-LIC-LOCATION:Asia/Samarkand\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:UZT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Seoul",
	"+0373300", "+1265800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Seoul\nX-LIC-LOCATION:Asia/Seoul\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:KST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Shanghai",
	"+0311400", "+1212800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Shanghai\nX-LIC-LOCATION:Asia/Shanghai\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Singapore",
	"+0011700", "+1035100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Singapore\nX-LIC-LOCATION:Asia/Singapore\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:SGT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Taipei",
	"+0250300", "+1213000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Taipei\nX-LIC-LOCATION:Asia/Taipei\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Tashkent",
	"+0412000", "+0691800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Tashkent\nX-LIC-LOCATION:Asia/Tashkent\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:UZT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Tbilisi",
	"+0414300", "+0444900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Tbilisi\nX-LIC-LOCATION:Asia/Tbilisi\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:GET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Tehran",
	"+0354000", "+0512600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Tehran\nX-LIC-LOCATION:Asia/Tehran\nBEGIN:STANDARD\nTZOFFSETFROM:+0330\nTZOFFSETTO:+0330\nTZNAME:IRST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Thimphu",
	"+0272800", "+0893900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Thimphu\nX-LIC-LOCATION:Asia/Thimphu\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:BTT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Tokyo",
	"+0353916", "+1394441",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Tokyo\nX-LIC-LOCATION:Asia/Tokyo\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:JST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Ulaanbaatar",
	"+0475500", "+1065300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Ulaanbaatar\nX-LIC-LOCATION:Asia/Ulaanbaatar\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0800\nTZNAME:ULAT\nDTSTART:19700926T020000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=-1SA\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0900\nTZNAME:ULAST\nDTSTART:19700328T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SA\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Urumqi",
	"+0434800", "+0873500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Urumqi\nX-LIC-LOCATION:Asia/Urumqi\nBEGIN:STANDARD\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0800\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Vientiane",
	"+0175800", "+1023600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Vientiane\nX-LIC-LOCATION:Asia/Vientiane\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:ICT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Vladivostok",
	"+0431000", "+1315600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Vladivostok\nX-LIC-LOCATION:Asia/Vladivostok\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:VLAST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1000\nTZNAME:VLAT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Yakutsk",
	"+0620000", "+1294000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Yakutsk\nX-LIC-LOCATION:Asia/Yakutsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0900\nTZOFFSETTO:+1000\nTZNAME:YAKST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+0900\nTZNAME:YAKT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Yekaterinburg",
	"+0565100", "+0603600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Yekaterinburg\nX-LIC-LOCATION:Asia/Yekaterinburg\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0600\nTZNAME:YEKST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0500\nTZNAME:YEKT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Asia/Yerevan",
	"+0401100", "+0443000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Asia/Yerevan\nX-LIC-LOCATION:Asia/Yerevan\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0500\nTZNAME:AMST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0400\nTZNAME:AMT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Azores",
	"+0374400", "-0254000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Azores\nX-LIC-LOCATION:Atlantic/Azores\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0100\nTZOFFSETTO:+0000\nTZNAME:AZOST\nDTSTART:19700329T000000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:-0100\nTZNAME:AZOT\nDTSTART:19701025T010000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Bermuda",
	"+0321700", "-0644600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Bermuda\nX-LIC-LOCATION:Atlantic/Bermuda\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:ADT\nDTSTART:19700308T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:AST\nDTSTART:19701101T020000\nRRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Canary",
	"+0280600", "-0152400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Canary\nX-LIC-LOCATION:Atlantic/Canary\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:WEST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Cape_Verde",
	"+0145500", "-0233100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Cape_Verde\nX-LIC-LOCATION:Atlantic/Cape_Verde\nBEGIN:STANDARD\nTZOFFSETFROM:-0100\nTZOFFSETTO:-0100\nTZNAME:CVT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Faroe",
	"+0620100", "-0064600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Faroe\nX-LIC-LOCATION:Atlantic/Faroe\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:WEST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Jan_Mayen",
	"+0705900", "-0080500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Jan_Mayen\nX-LIC-LOCATION:Atlantic/Jan_Mayen\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Madeira",
	"+0323800", "-0165400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Madeira\nX-LIC-LOCATION:Atlantic/Madeira\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:WEST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Reykjavik",
	"+0640900", "-0215100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Reykjavik\nX-LIC-LOCATION:Atlantic/Reykjavik\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/South_Georgia",
	"-0541600", "-0363200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/South_Georgia\nX-LIC-LOCATION:Atlantic/South_Georgia\nBEGIN:STANDARD\nTZOFFSETFROM:-0200\nTZOFFSETTO:-0200\nTZNAME:GST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/St_Helena",
	"-0155500", "-0054200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/St_Helena\nX-LIC-LOCATION:Atlantic/St_Helena\nBEGIN:STANDARD\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Atlantic/Stanley",
	"-0514200", "-0575100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Atlantic/Stanley\nX-LIC-LOCATION:Atlantic/Stanley\nBEGIN:STANDARD\nTZOFFSETFROM:-0300\nTZOFFSETTO:-0400\nTZNAME:FKT\nDTSTART:19700419T020000\nRRULE:FREQ=YEARLY;BYMONTH=4;BYDAY=3SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0400\nTZOFFSETTO:-0300\nTZNAME:FKST\nDTSTART:19700906T020000\nRRULE:FREQ=YEARLY;BYMONTH=9;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Adelaide",
	"-0345500", "+1383500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Adelaide\nX-LIC-LOCATION:Australia/Adelaide\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0930\nTZOFFSETTO:+1030\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0930\nTZOFFSETTO:+0930\nTZNAME:CST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Brisbane",
	"-0272800", "+1530200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Brisbane\nX-LIC-LOCATION:Australia/Brisbane\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Broken_Hill",
	"-0315700", "+1412700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Broken_Hill\nX-LIC-LOCATION:Australia/Broken_Hill\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0930\nTZOFFSETTO:+1030\nTZNAME:CST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0930\nTZOFFSETTO:+0930\nTZNAME:CST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Currie",
	"-0395600", "+1435200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Currie\nX-LIC-LOCATION:Australia/Currie\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:EST\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Darwin",
	"-0122800", "+1305000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Darwin\nX-LIC-LOCATION:Australia/Darwin\nBEGIN:STANDARD\nTZOFFSETFROM:+0930\nTZOFFSETTO:+0930\nTZNAME:CST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Eucla",
	"-0314300", "+1285200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Eucla\nX-LIC-LOCATION:Australia/Eucla\nBEGIN:STANDARD\nTZOFFSETFROM:+0845\nTZOFFSETTO:+0845\nTZNAME:CWST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Hobart",
	"-0425300", "+1471900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Hobart\nX-LIC-LOCATION:Australia/Hobart\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:EST\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Lindeman",
	"-0201600", "+1490000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Lindeman\nX-LIC-LOCATION:Australia/Lindeman\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Lord_Howe",
	"-0313300", "+1590500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Lord_Howe\nX-LIC-LOCATION:Australia/Lord_Howe\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1030\nTZOFFSETTO:+1100\nTZNAME:LHST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1030\nTZOFFSETTO:+1030\nTZNAME:LHST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Melbourne",
	"-0374900", "+1445800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Melbourne\nX-LIC-LOCATION:Australia/Melbourne\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Perth",
	"-0315700", "+1155100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Perth\nX-LIC-LOCATION:Australia/Perth\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0800\nTZOFFSETTO:+0900\nTZNAME:WST\nDTSTART:20061029T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0800\nTZNAME:WST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Australia/Sydney",
	"-0335200", "+1511300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Australia/Sydney\nX-LIC-LOCATION:Australia/Sydney\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1100\nTZNAME:EST\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:EST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Amsterdam",
	"+0522200", "+0045400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Amsterdam\nX-LIC-LOCATION:Europe/Amsterdam\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Andorra",
	"+0423000", "+0013100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Andorra\nX-LIC-LOCATION:Europe/Andorra\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Athens",
	"+0375800", "+0234300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Athens\nX-LIC-LOCATION:Europe/Athens\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Belgrade",
	"+0445000", "+0203000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Belgrade\nX-LIC-LOCATION:Europe/Belgrade\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Berlin",
	"+0523000", "+0132200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Berlin\nX-LIC-LOCATION:Europe/Berlin\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Bratislava",
	"+0480900", "+0170700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Bratislava\nX-LIC-LOCATION:Europe/Bratislava\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Brussels",
	"+0505000", "+0042000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Brussels\nX-LIC-LOCATION:Europe/Brussels\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Bucharest",
	"+0442600", "+0260600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Bucharest\nX-LIC-LOCATION:Europe/Bucharest\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Budapest",
	"+0473000", "+0190500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Budapest\nX-LIC-LOCATION:Europe/Budapest\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Chisinau",
	"+0470000", "+0285000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Chisinau\nX-LIC-LOCATION:Europe/Chisinau\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Copenhagen",
	"+0554000", "+0123500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Copenhagen\nX-LIC-LOCATION:Europe/Copenhagen\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Dublin",
	"+0532000", "-0061500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Dublin\nX-LIC-LOCATION:Europe/Dublin\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:IST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Gibraltar",
	"+0360800", "-0052100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Gibraltar\nX-LIC-LOCATION:Europe/Gibraltar\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Guernsey",
	"+0492700", "-0023200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Guernsey\nX-LIC-LOCATION:Europe/Guernsey\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:BST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Helsinki",
	"+0601000", "+0245800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Helsinki\nX-LIC-LOCATION:Europe/Helsinki\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Isle_of_Man",
	"+0540900", "-0042800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Isle_of_Man\nX-LIC-LOCATION:Europe/Isle_of_Man\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:BST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Istanbul",
	"+0410100", "+0285800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Istanbul\nX-LIC-LOCATION:Europe/Istanbul\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Jersey",
	"+0491200", "-0020700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Jersey\nX-LIC-LOCATION:Europe/Jersey\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:BST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Kaliningrad",
	"+0544300", "+0203000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Kaliningrad\nX-LIC-LOCATION:Europe/Kaliningrad\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Kiev",
	"+0502600", "+0303100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Kiev\nX-LIC-LOCATION:Europe/Kiev\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Lisbon",
	"+0384300", "-0090800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Lisbon\nX-LIC-LOCATION:Europe/Lisbon\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:WET\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:WEST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Ljubljana",
	"+0460300", "+0143100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Ljubljana\nX-LIC-LOCATION:Europe/Ljubljana\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/London",
	"+0512830", "+0001845",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/London\nX-LIC-LOCATION:Europe/London\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0000\nTZOFFSETTO:+0100\nTZNAME:BST\nDTSTART:19700329T010000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0000\nTZNAME:GMT\nDTSTART:19701025T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Luxembourg",
	"+0493600", "+0060900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Luxembourg\nX-LIC-LOCATION:Europe/Luxembourg\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Madrid",
	"+0402400", "-0034100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Madrid\nX-LIC-LOCATION:Europe/Madrid\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Malta",
	"+0355400", "+0143100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Malta\nX-LIC-LOCATION:Europe/Malta\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Mariehamn",
	"+0600600", "+0195700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Mariehamn\nX-LIC-LOCATION:Europe/Mariehamn\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Minsk",
	"+0535400", "+0273400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Minsk\nX-LIC-LOCATION:Europe/Minsk\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Monaco",
	"+0434200", "+0072300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Monaco\nX-LIC-LOCATION:Europe/Monaco\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Moscow",
	"+0554500", "+0373500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Moscow\nX-LIC-LOCATION:Europe/Moscow\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0400\nTZNAME:MSD\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0300\nTZNAME:MSK\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Nicosia",
	"+0351000", "+0332200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Nicosia\nX-LIC-LOCATION:Europe/Nicosia\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Oslo",
	"+0595500", "+0104500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Oslo\nX-LIC-LOCATION:Europe/Oslo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Paris",
	"+0485200", "+0022000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Paris\nX-LIC-LOCATION:Europe/Paris\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Podgorica",
	"+0422600", "+0191600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Podgorica\nX-LIC-LOCATION:Europe/Podgorica\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Prague",
	"+0500500", "+0142600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Prague\nX-LIC-LOCATION:Europe/Prague\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Riga",
	"+0565700", "+0240600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Riga\nX-LIC-LOCATION:Europe/Riga\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Rome",
	"+0415400", "+0122900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Rome\nX-LIC-LOCATION:Europe/Rome\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Samara",
	"+0531200", "+0500900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Samara\nX-LIC-LOCATION:Europe/Samara\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0500\nTZNAME:SAMST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0400\nTZNAME:SAMT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/San_Marino",
	"+0435500", "+0122800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/San_Marino\nX-LIC-LOCATION:Europe/San_Marino\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Sarajevo",
	"+0435200", "+0182500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Sarajevo\nX-LIC-LOCATION:Europe/Sarajevo\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Simferopol",
	"+0445700", "+0340600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Simferopol\nX-LIC-LOCATION:Europe/Simferopol\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Skopje",
	"+0415900", "+0212600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Skopje\nX-LIC-LOCATION:Europe/Skopje\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Sofia",
	"+0424100", "+0231900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Sofia\nX-LIC-LOCATION:Europe/Sofia\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Stockholm",
	"+0592000", "+0180300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Stockholm\nX-LIC-LOCATION:Europe/Stockholm\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Tallinn",
	"+0592500", "+0244500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Tallinn\nX-LIC-LOCATION:Europe/Tallinn\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Tirane",
	"+0412000", "+0195000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Tirane\nX-LIC-LOCATION:Europe/Tirane\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Uzhgorod",
	"+0483700", "+0221800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Uzhgorod\nX-LIC-LOCATION:Europe/Uzhgorod\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Vaduz",
	"+0470900", "+0093100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Vaduz\nX-LIC-LOCATION:Europe/Vaduz\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Vatican",
	"+0415400", "+0122700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Vatican\nX-LIC-LOCATION:Europe/Vatican\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Vienna",
	"+0481300", "+0162000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Vienna\nX-LIC-LOCATION:Europe/Vienna\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Vilnius",
	"+0544100", "+0251900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Vilnius\nX-LIC-LOCATION:Europe/Vilnius\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Volgograd",
	"+0484400", "+0442500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Volgograd\nX-LIC-LOCATION:Europe/Volgograd\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0400\nTZNAME:VOLST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0300\nTZNAME:VOLT\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Warsaw",
	"+0521500", "+0210000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Warsaw\nX-LIC-LOCATION:Europe/Warsaw\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Zagreb",
	"+0454800", "+0155800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Zagreb\nX-LIC-LOCATION:Europe/Zagreb\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Zaporozhye",
	"+0475000", "+0351000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Zaporozhye\nX-LIC-LOCATION:Europe/Zaporozhye\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0300\nTZNAME:EEST\nDTSTART:19700329T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0200\nTZNAME:EET\nDTSTART:19701025T040000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Europe/Zurich",
	"+0472300", "+0083200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Europe/Zurich\nX-LIC-LOCATION:Europe/Zurich\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+0100\nTZOFFSETTO:+0200\nTZNAME:CEST\nDTSTART:19700329T020000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=-1SU\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:+0200\nTZOFFSETTO:+0100\nTZNAME:CET\nDTSTART:19701025T030000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=-1SU\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Antananarivo",
	"-0185500", "+0473100",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Antananarivo\nX-LIC-LOCATION:Indian/Antananarivo\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Chagos",
	"-0072000", "+0722500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Chagos\nX-LIC-LOCATION:Indian/Chagos\nBEGIN:STANDARD\nTZOFFSETFROM:+0600\nTZOFFSETTO:+0600\nTZNAME:IOT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Christmas",
	"-0102500", "+1054300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Christmas\nX-LIC-LOCATION:Indian/Christmas\nBEGIN:STANDARD\nTZOFFSETFROM:+0700\nTZOFFSETTO:+0700\nTZNAME:CXT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Cocos",
	"-0121000", "+0965500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Cocos\nX-LIC-LOCATION:Indian/Cocos\nBEGIN:STANDARD\nTZOFFSETFROM:+0630\nTZOFFSETTO:+0630\nTZNAME:CCT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Comoro",
	"-0114100", "+0431600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Comoro\nX-LIC-LOCATION:Indian/Comoro\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Kerguelen",
	"-0492110", "+0701303",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Kerguelen\nX-LIC-LOCATION:Indian/Kerguelen\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:TFT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Mahe",
	"-0044000", "+0552800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Mahe\nX-LIC-LOCATION:Indian/Mahe\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:SCT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Maldives",
	"+0041000", "+0733000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Maldives\nX-LIC-LOCATION:Indian/Maldives\nBEGIN:STANDARD\nTZOFFSETFROM:+0500\nTZOFFSETTO:+0500\nTZNAME:MVT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Mauritius",
	"-0201000", "+0573000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Mauritius\nX-LIC-LOCATION:Indian/Mauritius\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:MUT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Mayotte",
	"-0124700", "+0451400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Mayotte\nX-LIC-LOCATION:Indian/Mayotte\nBEGIN:STANDARD\nTZOFFSETFROM:+0300\nTZOFFSETTO:+0300\nTZNAME:EAT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Indian/Reunion",
	"-0205200", "+0552800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Indian/Reunion\nX-LIC-LOCATION:Indian/Reunion\nBEGIN:STANDARD\nTZOFFSETFROM:+0400\nTZOFFSETTO:+0400\nTZNAME:RET\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Apia",
	"-0135000", "-1714400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Apia\nX-LIC-LOCATION:Pacific/Apia\nBEGIN:STANDARD\nTZOFFSETFROM:-1100\nTZOFFSETTO:-1100\nTZNAME:WST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Auckland",
	"-0365200", "+1744600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Auckland\nX-LIC-LOCATION:Pacific/Auckland\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1200\nTZNAME:NZST\nDTSTART:19700315T030000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=3SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1300\nTZNAME:NZDT\nDTSTART:19701004T020000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Chatham",
	"-0435700", "-1763300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Chatham\nX-LIC-LOCATION:Pacific/Chatham\nBEGIN:STANDARD\nTZOFFSETFROM:+1345\nTZOFFSETTO:+1245\nTZNAME:CHAST\nDTSTART:19700315T034500\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=3SU\nEND:STANDARD\nBEGIN:DAYLIGHT\nTZOFFSETFROM:+1245\nTZOFFSETTO:+1345\nTZNAME:CHADT\nDTSTART:19701004T024500\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=1SU\nEND:DAYLIGHT\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Easter",
	"-0270900", "-1092600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Easter\nX-LIC-LOCATION:Pacific/Easter\nBEGIN:DAYLIGHT\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0500\nTZNAME:EASST\nDTSTART:19701010T220000\nRRULE:FREQ=YEARLY;BYMONTH=10;BYDAY=2SA\nEND:DAYLIGHT\nBEGIN:STANDARD\nTZOFFSETFROM:-0500\nTZOFFSETTO:-0600\nTZNAME:EAST\nDTSTART:19700314T220000\nRRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SA\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Efate",
	"-0174000", "+1682500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Efate\nX-LIC-LOCATION:Pacific/Efate\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1100\nTZNAME:VUT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Enderbury",
	"-0030800", "-1710500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Enderbury\nX-LIC-LOCATION:Pacific/Enderbury\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1300\nTZNAME:PHOT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Fakaofo",
	"-0092200", "-1711400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Fakaofo\nX-LIC-LOCATION:Pacific/Fakaofo\nBEGIN:STANDARD\nTZOFFSETFROM:-1000\nTZOFFSETTO:-1000\nTZNAME:TKT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Fiji",
	"-0180800", "+1782500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Fiji\nX-LIC-LOCATION:Pacific/Fiji\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:FJT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Funafuti",
	"-0083100", "+1791300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Funafuti\nX-LIC-LOCATION:Pacific/Funafuti\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:TVT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Galapagos",
	"+0005400", "-0893600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Galapagos\nX-LIC-LOCATION:Pacific/Galapagos\nBEGIN:STANDARD\nTZOFFSETFROM:-0600\nTZOFFSETTO:-0600\nTZNAME:GALT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Gambier",
	"-0230800", "-1345700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Gambier\nX-LIC-LOCATION:Pacific/Gambier\nBEGIN:STANDARD\nTZOFFSETFROM:-0900\nTZOFFSETTO:-0900\nTZNAME:GAMT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Guadalcanal",
	"-0093200", "+1601200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Guadalcanal\nX-LIC-LOCATION:Pacific/Guadalcanal\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1100\nTZNAME:SBT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Guam",
	"+0132800", "+1444500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Guam\nX-LIC-LOCATION:Pacific/Guam\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:ChST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Honolulu",
	"+0211825", "-1575130",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Honolulu\nX-LIC-LOCATION:Pacific/Honolulu\nBEGIN:STANDARD\nTZOFFSETFROM:-1000\nTZOFFSETTO:-1000\nTZNAME:HST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Johnston",
	"+0170000", "-1683000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Johnston\nX-LIC-LOCATION:Pacific/Johnston\nBEGIN:STANDARD\nTZOFFSETFROM:-1000\nTZOFFSETTO:-1000\nTZNAME:HST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Kiritimati",
	"+0015200", "-1572000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Kiritimati\nX-LIC-LOCATION:Pacific/Kiritimati\nBEGIN:STANDARD\nTZOFFSETFROM:+1400\nTZOFFSETTO:+1400\nTZNAME:LINT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Kosrae",
	"+0051900", "+1625900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Kosrae\nX-LIC-LOCATION:Pacific/Kosrae\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1100\nTZNAME:KOST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Kwajalein",
	"+0090500", "+1672000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Kwajalein\nX-LIC-LOCATION:Pacific/Kwajalein\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:MHT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Majuro",
	"+0070900", "+1711200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Majuro\nX-LIC-LOCATION:Pacific/Majuro\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:MHT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Marquesas",
	"-0090000", "-1393000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Marquesas\nX-LIC-LOCATION:Pacific/Marquesas\nBEGIN:STANDARD\nTZOFFSETFROM:-0930\nTZOFFSETTO:-0930\nTZNAME:MART\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Midway",
	"+0281300", "-1772200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Midway\nX-LIC-LOCATION:Pacific/Midway\nBEGIN:STANDARD\nTZOFFSETFROM:-1100\nTZOFFSETTO:-1100\nTZNAME:SST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Nauru",
	"+0003100", "+1665500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Nauru\nX-LIC-LOCATION:Pacific/Nauru\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:NRT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Niue",
	"-0190100", "+1695500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Niue\nX-LIC-LOCATION:Pacific/Niue\nBEGIN:STANDARD\nTZOFFSETFROM:-1100\nTZOFFSETTO:-1100\nTZNAME:NUT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Norfolk",
	"-0290300", "+1675800",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Norfolk\nX-LIC-LOCATION:Pacific/Norfolk\nBEGIN:STANDARD\nTZOFFSETFROM:+1130\nTZOFFSETTO:+1130\nTZNAME:NFT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Noumea",
	"-0221600", "+1653000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Noumea\nX-LIC-LOCATION:Pacific/Noumea\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1100\nTZNAME:NCT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Pago_Pago",
	"-0141600", "-1704200",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Pago_Pago\nX-LIC-LOCATION:Pacific/Pago_Pago\nBEGIN:STANDARD\nTZOFFSETFROM:-1100\nTZOFFSETTO:-1100\nTZNAME:SST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Palau",
	"+0072000", "+1342900",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Palau\nX-LIC-LOCATION:Pacific/Palau\nBEGIN:STANDARD\nTZOFFSETFROM:+0900\nTZOFFSETTO:+0900\nTZNAME:PWT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Pitcairn",
	"-0250400", "-1300500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Pitcairn\nX-LIC-LOCATION:Pacific/Pitcairn\nBEGIN:STANDARD\nTZOFFSETFROM:-0800\nTZOFFSETTO:-0800\nTZNAME:PST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Ponape",
	"+0065800", "+1581300",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Ponape\nX-LIC-LOCATION:Pacific/Ponape\nBEGIN:STANDARD\nTZOFFSETFROM:+1100\nTZOFFSETTO:+1100\nTZNAME:PONT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Port_Moresby",
	"-0093000", "+1471000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Port_Moresby\nX-LIC-LOCATION:Pacific/Port_Moresby\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:PGT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Rarotonga",
	"-0211400", "-1594600",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Rarotonga\nX-LIC-LOCATION:Pacific/Rarotonga\nBEGIN:STANDARD\nTZOFFSETFROM:-1000\nTZOFFSETTO:-1000\nTZNAME:CKT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Saipan",
	"+0151200", "+1454500",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Saipan\nX-LIC-LOCATION:Pacific/Saipan\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:ChST\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Tahiti",
	"-0173200", "-1493400",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Tahiti\nX-LIC-LOCATION:Pacific/Tahiti\nBEGIN:STANDARD\nTZOFFSETFROM:-1000\nTZOFFSETTO:-1000\nTZNAME:TAHT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Tarawa",
	"+0012500", "+1730000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Tarawa\nX-LIC-LOCATION:Pacific/Tarawa\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:GILT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Tongatapu",
	"-0211000", "+1751000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Tongatapu\nX-LIC-LOCATION:Pacific/Tongatapu\nBEGIN:STANDARD\nTZOFFSETFROM:+1300\nTZOFFSETTO:+1300\nTZNAME:TOT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Truk",
	"+0072500", "+1514700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Truk\nX-LIC-LOCATION:Pacific/Truk\nBEGIN:STANDARD\nTZOFFSETFROM:+1000\nTZOFFSETTO:+1000\nTZNAME:TRUT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Wake",
	"+0191700", "+1663700",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Wake\nX-LIC-LOCATION:Pacific/Wake\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:WAKT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{
	"/mozilla.org/20070129_1/Pacific/Wallis",
	"-0131800", "-1761000",
	"BEGIN:VCALENDAR\nPRODID:-//mozilla.org//NONSGML Sunbird via VZIC//EN\nVERSION:2.0\nBEGIN:VTIMEZONE\nTZID:/mozilla.org/20070129_1/Pacific/Wallis\nX-LIC-LOCATION:Pacific/Wallis\nBEGIN:STANDARD\nTZOFFSETFROM:+1200\nTZOFFSETTO:+1200\nTZNAME:WFT\nDTSTART:19700101T000000\nEND:STANDARD\nEND:VTIMEZONE\nEND:VCALENDAR\n"
}
,
{ NULL, NULL, NULL, NULL }
};

// needed for implementing calIICSService.tzIdPrefix
NS_NAMED_LITERAL_CSTRING(gTzIdPrefix, "/mozilla.org/20070129_1/");
