//@line 37 "/builds/tinderbox/Fx-Mozilla1.8/Linux_2.4.21-27.0.4.EL_Depend/mozilla/browser/components/preferences/feeds.js"


var gFeedsPane = {
  /**
   * Ensures feed reader list is initialized before Feed Reader UI is
   * filled from preferences.
   */
  _feedReadersInited: false,

  _pane: null,

  /**
   * Initializes this.
   */
  init: function ()
  {
    this._pane = document.getElementById("paneFeeds");

    this._initFeedReaders();
    this._attachPreferenceBindings();
    this.onReaderPrefsChange();
  },

  _attachPreferenceBindings: function ()
  {
    var feedClick = document.getElementById("feedClick");
    feedClick.setAttribute("preference", "browser.feeds.handler");

    var reader = document.getElementById("chooseFeedReader");
    reader.setAttribute("preference", "browser.feeds.handler.default");
  },

  /*
   * Preferences:
   *
   * browser.feeds.handler
   * - "bookmarks", "reader" (clarified further using the .default preference),
   *   or "ask" -- indicates the default handler being used to process feeds
   * browser.feeds.handler.default
   * - "bookmarks", "client" or "web" -- indicates the chosen feed reader used
   *   to display feeds, either transiently (i.e., when the "use as default"
   *   checkbox is unchecked, corresponds to when browser.feeds.handler=="ask")
   *   or more permanently (i.e., the item displayed in the dropdown in Feeds
   *   preferences)
   * browser.feeds.handler.webservice
   * - the URL of the currently selected web service used to read feeds
   * browser.feeds.handlers.application
   * - nsILocalFile, stores the current client-side feed reading app if one has
   *   been chosen
   */

  /**
   * Converts the selected radio button into a preference value, sets any
   * ancillary preferences (such as web/client readers), and returns the new
   * value of browser.feeds.handler.
   */
  writeFeedAction: function ()
  {
    var app = document.getElementById("browser.feeds.handlers.application");
    var web = document.getElementById("browser.feeds.handlers.webservice");
    var selReader = document.getElementById("browser.feeds.handler.default");

    var feedAction = document.getElementById("feedClick").value;
    switch (feedAction) {
      case "reader":
        var menu = document.getElementById("chooseFeedReader");
        var reader = menu.selectedItem;

        var type = reader.getAttribute("type");
        switch (type) {
          case "client":
            app.value = reader.getAttribute("value");
            selReader.value = type;
            break;

          case "web":
            web.value = reader.getAttribute("value");
            selReader.value = type;
            break;

          default:
            throw "Unhandled reader type: " + feedAction;
        }
        break;

      default:
        throw "Unhandled feed action: " + feedAction;

      case "ask":
      case "bookmarks":
        break;

    }
    return feedAction;
  },

  /**
   * Converts the value of browser.feeds.handler.default into the appropriate
   * menu item in the menulist of readers, returning the value of that item.
   */
  readFeedReader: function ()
  {
    var reader = document.getElementById("browser.feeds.handler");
    var selReader = document.getElementById("browser.feeds.handler.default");

    var web = document.getElementById("browser.feeds.handlers.webservice");
    var app = document.getElementById("browser.feeds.handlers.application");

    var menu = document.getElementById("chooseFeedReader");

    // we have the type of reader being used -- get its corresponding value
    // and return it
    var defaultHandler = selReader.value;
    switch (defaultHandler) {
      case "web":
        return web.value;
        break;

      case "client":
        return app.value.path || app.value;
        break;

      case "bookmarks":
        // we could handle this case with a preference specifically for the
        // chosen reader, but honestly -- is it really worth it?
      default:
        menu.selectedIndex = 0;
        return menu.value;
    }
  },

  /**
   * Determines the reader displayed in the feed reader menulist and stores that
   * reader to preferences.
   */
  writeFeedReader: function ()
  {
    var menu = document.getElementById("chooseFeedReader");

    var reader = document.getElementById("browser.feeds.handler");
    var selReader = document.getElementById("browser.feeds.handler.default");
    var web = document.getElementById("browser.feeds.handlers.webservice");
    var app = document.getElementById("browser.feeds.handlers.application");

    var selected = menu.selectedItem;
    var type = selected.getAttribute("type");
    switch (type) {
      case "web":
        web.value = selected.value;
        break;

      case "client":
        app.value = selected.value;
        break;

      case "add":
        // we're choosing a new client app
        var newApp = this._addNewReader();
        if (newApp) {
          this._initFeedReaders();
          app.value = newApp;
          type = "client";
        } else {
          type = selReader.value; // return to existing value
        }
        break;

      default:
        throw "Unhandled type: " + type;
    }
       return type;
  },

  /**
   * Syncs current UI with the values stored in preferences.  This is necessary
   * because the UI items are represented using multiple preferences, so the
   * sync can't happen automatically without extra code.
   */
  onReaderPrefsChange: function ()
  {
    var handler = document.getElementById("browser.feeds.handler");
    var selReader = document.getElementById("browser.feeds.handler.default");

    handler.updateElements();
    selReader.updateElements();
  },

  /**
   * Populates the UI list of available feed readers.  The current feed reader
   * must be manually selected in the list.
   */
  _initFeedReaders: function ()
  {
    // XXX make UI a listbox with icons, etc!

    const Cc = Components.classes, Ci = Components.interfaces;

    var readers = [];

    // CLIENT-SIDE

    // first, get the client reader in preferences
    try {
      var clientApp = document.getElementById("clientApp");
      var app = document.getElementById("browser.feeds.handlers.application");
      clientApp.file = app.value;

      var client = { type: "client",
                     path: clientApp.file.path,
                     name: clientApp.label,
                     icon: clientApp.image };
      readers.push(client);
    }
    catch (e) { /* no client feed reader set */ }

    // get any readers stored in system preferences
//@line 286 "/builds/tinderbox/Fx-Mozilla1.8/Linux_2.4.21-27.0.4.EL_Depend/mozilla/browser/components/preferences/feeds.js"

    // WEB SERVICES
    const TYPE_MAYBE_FEED = "application/vnd.mozilla.maybe.feed";
    var wccr = Cc["@mozilla.org/embeddor.implemented/web-content-handler-registrar;1"]
                 .getService(Ci.nsIWebContentConverterService);
    var ios = Cc["@mozilla.org/network/io-service;1"]
                .getService(Ci.nsIIOService);

    var handlers = wccr.getContentHandlers(TYPE_MAYBE_FEED, {});
    for (var i = 0; i < handlers.length; i++) {
      var uri = ios.newURI(handlers[i].uri, null, null);
      var webReader = { type: "web",
                        path: uri.spec,
                        name: handlers[i].name,
                        icon: uri.prePath + "/favicon.ico" };
      readers.push(webReader);
    }

    // Now that we have all the readers, sort them and add them to the UI
    var menulist = document.getElementById("chooseFeedReader");
    menulist.textContent = ""; // clear out any previous elements
    var popup = document.createElement("menupopup");

    // insert a blank item to indicate no selected preference, and an
    // "add" item to allow addition of new readers

    var bundle = document.getElementById("bundlePreferences");

    readers.sort(function(a, b) { return (a.name.toLowerCase() < b.name.toLowerCase()) ? -1 : 1; });
    for (var i = 0; i < readers.length; i++) {
      var reader = readers[i];

      item = document.createElement("menuitem");
      item.setAttribute("label", reader.name);
      item.setAttribute("value", reader.path);
      item.setAttribute("type", reader.type);
      item.setAttribute("path", reader.path);

      popup.appendChild(item);
    }

    // put "add new reader" at end, since it won't be used much
    item = document.createElement("menuitem");
    item.setAttribute("label", bundle.getString("addReader"));
    item.setAttribute("value", "add");
    item.setAttribute("type", "add");
    popup.appendChild(item);

    menulist.appendChild(popup);

  },

  /**
   * Displays a prompt from which the user may add a new (client) feed reader.
   *
   * @returns null if no new reader was added, or the path to the application if
   *          one was added
   */
  _addNewReader: function ()
  {
    const Cc = Components.classes, Ci = Components.interfaces;
    var fp = Cc["@mozilla.org/filepicker;1"]
               .createInstance(Ci.nsIFilePicker);
    fp.init(window, document.title, Ci.nsIFilePicker.modeOpen);
    fp.appendFilters(Ci.nsIFilePicker.filterApps);
    if (fp.show() == Ci.nsIFilePicker.returnOK && fp.file) {
      // XXXben - we need to compare this with the running instance executable
      //          just don't know how to do that via script...
      if (fp.file.leafName == "firefox.exe")
        return null;

      var pref = document.getElementById("browser.feeds.handlers.application");
      pref.value = fp.file;

      return fp.file.path;
    }
    return null;

  }
};
