//@line 39 "D:/builds/nightlies/firefox/mozilla/browser/components/places/content/history-panel.js"

var gHistoryTree;
var gSearchBox;
var gHistoryGrouping = "";

function HistorySidebarInit()
{
  gHistoryTree = document.getElementById("historyTree");
  gSearchBox = document.getElementById("search-box");

  gHistoryGrouping = document.getElementById("viewButton").
                              getAttribute("selectedsort");

  if (gHistoryGrouping == "site")
    document.getElementById("bysite").setAttribute("checked", "true");
  else if (gHistoryGrouping == "visited") 
    document.getElementById("byvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "lastvisited")
    document.getElementById("bylastvisited").setAttribute("checked", "true");
  else if (gHistoryGrouping == "dayandsite")
    document.getElementById("bydayandsite").setAttribute("checked", "true");
  else
    document.getElementById("byday").setAttribute("checked", "true");

  // XXXBlake we should persist the last search value
  // If it's empty, this will do the right thing and 
  // just group by the old grouping.
  // bug #359073 tracks this RFE
  searchHistory(gSearchBox.value);
  gSearchBox.focus();
}

function checkURLSecurity(aURL)
{
  var uri = Components.classes["@mozilla.org/network/io-service;1"]
                      .getService(Ci.nsIIOService)
                      .newURI(aURL, null, null);

  if (uri.schemeIs("javascript") || uri.schemeIs("data")) {
    var strBundleService = 
      Components.classes["@mozilla.org/intl/stringbundle;1"]
                .getService(Ci.nsIStringBundleService);
    var promptService = 
      Components.classes["@mozilla.org/embedcomp/prompt-service;1"]
                .getService(Ci.nsIPromptService);
    var historyBundle = strBundleService.createBundle("chrome://global/locale/history/history.properties");
    var brandBundle = strBundleService.createBundle("chrome://branding/locale/brand.properties");      
    var brandStr = brandBundle.GetStringFromName("brandShortName");
    var errorStr = historyBundle.GetStringFromName("load-js-data-url-error");
    promptService.alert(window, brandStr, errorStr);
    return false;
  }
  return true;
}

function SetPlace(aSearchString)
{
  const NHQO = Ci.nsINavHistoryQueryOptions;
  var placeURI = ORGANIZER_ROOT_HISTORY_UNSORTED;

  var prefService = 
    Components.classes["@mozilla.org/preferences-service;1"]
            .getService(Ci.nsIPrefBranch);
  if (prefService.getBoolPref("browser.history.showSessions"))
      placeURI += "&showSessions=1";

  switch (gHistoryGrouping) {
    case "site":
      placeURI += "&sort=" + NHQO.SORT_BY_TITLE_ASCENDING;
      break; 
    case "visited":
      placeURI += "&sort=" + NHQO.SORT_BY_VISITCOUNT_DESCENDING;
      break; 
    case "lastvisited":
      placeURI += "&sort=" + NHQO.SORT_BY_DATE_DESCENDING;
      break; 
    case "dayandsite":
      // if there isn't a search string, add the grouping
      if (!aSearchString) {
        placeURI += "&group=" + NHQO.GROUP_BY_DAY;
        placeURI += "&group=" + NHQO.GROUP_BY_HOST; 
      }

      placeURI += "&sort=" + NHQO.SORT_BY_TITLE_ASCENDING;
      break;
    default: /* "day" */
      // if there isn't a search string, add the grouping
      if (!aSearchString)
        placeURI += "&group=" + NHQO.GROUP_BY_DAY;
    
      placeURI += "&sort=" + NHQO.SORT_BY_TITLE_ASCENDING;
      break;
  }

  gHistoryTree.place = placeURI;
}
  
function GroupBy(groupingType)
{ 
  gHistoryGrouping = groupingType;
  gSearchBox.value = "";
  searchHistory(gSearchBox.value);
}

function collapseExpand()
{
  var currentIndex = gHistoryTree.currentIndex; 
  gHistoryTree.view.toggleOpenState(currentIndex);
} 

function openURLIn(aWhere)
{
  // no need to check gHistoryTree.view.selection.count
  // node will be null if there is a multiple selection 
  // or if the selected item is not a URI node
  var node = gHistoryTree.selectedURINode;
  if (!node) 
    return;

  if (!checkURLSecurity(node.uri))
    return;

  openUILinkIn(node.uri, aWhere);
}

function openURL(aEvent)
{
  openURLIn(whereToOpenLink(aEvent));
}

function handleHistoryClick(aEvent)
{
  var tbo = gHistoryTree.treeBoxObject;

  var row = { }, col = { }, obj = { };
  tbo.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);
  
  var x = { }, y = { }, w = { }, h = { };
  tbo.getCoordsForCellItem(row.value, col.value, "image",
                           x, y, w, h);
  var mouseInGutter = aEvent.clientX < x.value;

  if (row.value == -1 || obj.value == "twisty")
    return;

  var modifKey = aEvent.shiftKey || aEvent.ctrlKey || aEvent.altKey || 
                 aEvent.metaKey  || (aEvent.button != 0);
  if (!modifKey && tbo.view.isContainer(row.value)) {
    tbo.view.toggleOpenState(row.value);
    return;
  }
  if (!mouseInGutter && 
      aEvent.originalTarget.localName == "treechildren" && 
      (aEvent.button == 0 || aEvent.button == 1)) {
    // Clear all other selection since we're loading a link now. We must
    // do this *before* attempting to load the link since openURL uses
    // selection as an indication of which link to load. 
    tbo.view.selection.select(row.value);

    openURL(aEvent);
  }
}

function historyAddBookmarks()
{ 
  // no need to check gHistoryTree.view.selection.count
  // node will be null if there is a multiple selection 
  // or if the selected item is not a URI node
  var node = gHistoryTree.selectedURINode;
  if (!node) 
    return;
  
//@line 214 "D:/builds/nightlies/firefox/mozilla/browser/components/places/content/history-panel.js"
  BookmarksUtils.addBookmark(node.uri, node.title, undefined);
//@line 216 "D:/builds/nightlies/firefox/mozilla/browser/components/places/content/history-panel.js"
}

function historyCopyLink()
{
  var node = gHistoryTree.selectedURINode;
  var clipboard = Components.classes["@mozilla.org/widget/clipboardhelper;1"]
                            .getService(Ci.nsIClipboardHelper);
  clipboard.copyString(node.uri);
}   

function buildContextMenu(aEvent)
{
  var view = gHistoryTree.view;
  // if nothing is selected, bail and don't show a context menu
  if (view.selection.count != 1) {
    aEvent.preventDefault();
    return;
  }

  var openItem = document.getElementById("miOpen");
  var openItemInNewWindow = document.getElementById("miOpenInNewWindow");
  var openItemInNewTab = document.getElementById("miOpenInNewTab");
  var bookmarkItem = document.getElementById("miAddBookmark");
  var copyLocationItem = document.getElementById("miCopyLink");
  var sep1 = document.getElementById("pre-bookmarks-separator");
  var sep2 = document.getElementById("post-bookmarks-separator");
  var expandItem = document.getElementById("miExpand");
  var collapseItem = document.getElementById("miCollapse");

  var currentIndex = gHistoryTree.currentIndex;
  if ((gHistoryGrouping == "day" || gHistoryGrouping == "dayandsite")
      && view.isContainer(currentIndex)) {
    openItem.hidden = true;
    openItemInNewWindow.hidden = true;
    openItemInNewTab.hidden = true;
    bookmarkItem.hidden = true;
    copyLocationItem.hidden = true;
    sep1.hidden = true;
    sep2.hidden = false;

    if (view.isContainerOpen(currentIndex)) {
      expandItem.hidden = true;
      collapseItem.hidden = false;
    } else {
      expandItem.hidden = false;
      collapseItem.hidden = true;
    }
  }
  else {
    openItem.hidden = false;
    openItemInNewWindow.hidden = false;
    openItemInNewTab.hidden = false;
    bookmarkItem.hidden = false;
    copyLocationItem.hidden = false;
    sep1.hidden = false;
    sep2.hidden = false;
    expandItem.hidden = true;
    collapseItem.hidden = true;
  }
}

function searchHistory(aInput)
{
  SetPlace(aInput);

  if (!aInput)
    return;

  gHistoryTree.applyFilter(aInput, false /* onlyBookmarks */, 
                           0 /* folderRestrict */, null); 
}

//@line 44 "D:/builds/nightlies/firefox/mozilla/browser/components/places/content/../../../../toolkit/content/debug.js"

var gTraceOnAssert = true;

/**
 * This function provides a simple assertion function for JavaScript.
 * If the condition is true, this function will do nothing.  If the
 * condition is false, then the message will be printed to the console
 * and an alert will appear showing a stack trace, so that the (alpha
 * or nightly) user can file a bug containing it.  For future enhancements, 
 * see bugs 330077 and 330078.
 *
 * To suppress the dialogs, you can run with the environment variable
 * XUL_ASSERT_PROMPT set to 0 (if unset, this defaults to 1).
 *
 * @param condition represents the condition that we're asserting to be
 *                  true when we call this function--should be
 *                  something that can be evaluated as a boolean.
 * @param message   a string to be displayed upon failure of the assertion
 */

function NS_ASSERT(condition, message) {
  if (condition)
    return;

  var caller = arguments.callee.caller;
  var assertionText = "ASSERT: " + message + "\n";
  dump(assertionText);

  var stackText = "";
  if (gTraceOnAssert) {
    stackText = "Stack Trace: \n";
    var count = 0;
    while (caller) {
      stackText += count++ + ":" + caller.name + "(";
      for (var i = 0; i < caller.arguments.length; ++i) {
        var arg = caller.arguments[i];
        stackText += arg;
        if (i < caller.arguments.length - 1)
          stackText += ",";
      }
      stackText += ")\n";
      caller = caller.arguments.callee.caller;
    }
  }

  var environment = Components.classes["@mozilla.org/process/environment;1"].
                    getService(Components.interfaces.nsIEnvironment);
  if (environment.exists("XUL_ASSERT_PROMPT") &&
      !parseInt(environment.get("XUL_ASSERT_PROMPT")))
    return;

  var source = null;
  if (this.window)
    source = window;
  var ps = Components.classes["@mozilla.org/embedcomp/prompt-service;1"].
           getService(Components.interfaces.nsIPromptService);
  ps.alert(source, "Assertion Failed", assertionText + stackText);
}
