//@line 38 "X:/cvstrunk/mozilla/browser/components/places/content/sidebarUtils.js"

var SidebarUtils = {
  handleClick: function SU_handleClick(aTree, aEvent, aGutterSelect) {
    var tbo = aTree.treeBoxObject;

    var row = { }, col = { }, obj = { };
    tbo.getCellAt(aEvent.clientX, aEvent.clientY, row, col, obj);

    if (row.value == -1 || obj.value == "twisty")
      return;

    var mouseInGutter = false;
    if (aGutterSelect) {
      var x = { }, y = { }, w = { }, h = { };
      tbo.getCoordsForCellItem(row.value, col.value, "image",
                               x, y, w, h);
      mouseInGutter = aEvent.clientX < x.value;
    }
    
    var modifKey = aEvent.shiftKey || aEvent.ctrlKey || aEvent.altKey || 
                   aEvent.metaKey  || (aEvent.button != 0);
    if (!modifKey && tbo.view.isContainer(row.value)) {
      tbo.view.toggleOpenState(row.value);
      return;
    }
    if (!mouseInGutter && 
        aEvent.originalTarget.localName == "treechildren" && 
        (aEvent.button == 0 || aEvent.button == 1)) {
      // Clear all other selection since we're loading a link now. We must
      // do this *before* attempting to load the link since openURL uses
      // selection as an indication of which link to load. 
      tbo.view.selection.select(row.value);
      aTree.controller.openSelectedNodeWithEvent(aEvent);
    }
  }
};
