/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.fxa.login;

import org.mozilla.gecko.fxa.login.Doghouse;
import org.mozilla.gecko.fxa.login.FxAccountLoginStateMachine;
import org.mozilla.gecko.fxa.login.Separated;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.Utils;

public abstract class State {
    public static final long CURRENT_VERSION = 2L;
    protected final StateLabel stateLabel;
    public final String email;
    public final String uid;
    public final boolean verified;

    public State(StateLabel stateLabel, String string2, String string3, boolean bl) {
        Utils.throwIfNull(string2, string3);
        this.stateLabel = stateLabel;
        this.email = string2;
        this.uid = string3;
        this.verified = bl;
    }

    public StateLabel getStateLabel() {
        return this.stateLabel;
    }

    public ExtendedJSONObject toJSONObject() {
        ExtendedJSONObject extendedJSONObject = new ExtendedJSONObject();
        extendedJSONObject.put("version", 2L);
        extendedJSONObject.put("email", this.email);
        extendedJSONObject.put("uid", this.uid);
        extendedJSONObject.put("verified", this.verified);
        return extendedJSONObject;
    }

    public State makeSeparatedState() {
        return new Separated(this.email, this.uid, this.verified);
    }

    public State makeDoghouseState() {
        return new Doghouse(this.email, this.uid, this.verified);
    }

    public abstract void execute(FxAccountLoginStateMachine.ExecuteDelegate var1);

    public abstract Action getNeededAction();

    public static enum Action {
        NeedsUpgrade,
        NeedsPassword,
        NeedsVerification,
        None;

    }

    public static enum StateLabel {
        Engaged,
        Cohabiting,
        Married,
        Separated,
        Doghouse;

    }
}

