/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.CryptoInfo;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class DecryptDataStage
extends JPakeStage {
    @Override
    public void execute(JPakeClient jPakeClient) {
        Logger.debug("SyncJPakeStage", "Decrypting their payload.");
        if (!(jPakeClient.theirSignerId + "3").equals((String)jPakeClient.jIncoming.get("type"))) {
            Logger.error("SyncJPakeStage", "Invalid round 3 data: " + jPakeClient.jIncoming.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        Logger.debug("SyncJPakeStage", "Decrypting payload.");
        ExtendedJSONObject extendedJSONObject = null;
        try {
            extendedJSONObject = jPakeClient.jIncoming.getObject("payload");
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            Logger.error("SyncJPakeStage", "Invalid round 3 data.", nonObjectJSONException);
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        Logger.debug("SyncJPakeStage", "Decrypting data.");
        String string2 = null;
        try {
            string2 = new String(this.decryptPayload(extendedJSONObject, jPakeClient.myKeyBundle), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "Failed to decrypt data.", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (CryptoException cryptoException) {
            Logger.error("SyncJPakeStage", "Failed to decrypt data.", cryptoException);
            jPakeClient.abort("jpake.error.keymismatch");
            return;
        }
        try {
            jPakeClient.jCreds = ExtendedJSONObject.parseJSONObject((String)string2).object;
        }
        catch (IOException iOException) {
            Logger.error("SyncJPakeStage", "I/O exception while creating JSON object.", iOException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        catch (ParseException parseException) {
            Logger.error("SyncJPakeStage", "JSON parse error.", parseException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            Logger.error("SyncJPakeStage", "JSON parse error.", nonObjectJSONException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        if (!this.checkCredentials(jPakeClient.jCreds)) {
            Logger.error("SyncJPakeStage", "Credentials contain nulls, setup cannot be completed.");
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        jPakeClient.runNextStage();
    }

    private byte[] decryptPayload(ExtendedJSONObject extendedJSONObject, KeyBundle keyBundle) throws CryptoException, UnsupportedEncodingException {
        String string2 = (String)extendedJSONObject.get("ciphertext");
        String string3 = (String)extendedJSONObject.get("IV");
        String string4 = (String)extendedJSONObject.get("hmac");
        byte[] byArray = Utils.decodeBase64(string2);
        byte[] byArray2 = Utils.decodeBase64(string3);
        byte[] byArray3 = Utils.hex2Byte(string4);
        CryptoInfo cryptoInfo = CryptoInfo.decrypt(byArray, byArray2, byArray3, keyBundle);
        return cryptoInfo.getMessage();
    }

    private boolean checkCredentials(JSONObject jSONObject) {
        String string2 = (String)jSONObject.get((Object)"account");
        String string3 = (String)jSONObject.get((Object)"password");
        String string4 = (String)jSONObject.get((Object)"synckey");
        String string5 = (String)jSONObject.get((Object)"serverURL");
        return string2 != null && !string2.equals("") && string3 != null && !string3.equals("") && string4 != null && !string4.equals("") && string5 != null && !string5.equals("");
    }
}

