/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.videoengine;

import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;
import org.webrtc.videoengine.CaptureCapabilityAndroid;

public class VideoCaptureDeviceInfoAndroid {
    private static final String TAG = "WEBRTC-JC";

    private static boolean isFrontFacing(Camera.CameraInfo cameraInfo) {
        return cameraInfo.facing == 1;
    }

    private static String deviceUniqueName(int n, Camera.CameraInfo cameraInfo) {
        return "Camera " + n + ", Facing " + (VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo) ? "front" : "back") + ", Orientation " + cameraInfo.orientation;
    }

    @WebRTCJNITarget
    private static CaptureCapabilityAndroid[] getDeviceInfo() {
        ArrayList<Camera> arrayList = new ArrayList<Camera>();
        int n = 1;
        if (Build.VERSION.SDK_INT >= 9) {
            n = Camera.getNumberOfCameras();
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string = null;
            Camera.CameraInfo cameraInfo = null;
            if (Build.VERSION.SDK_INT >= 9) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
                string = VideoCaptureDeviceInfoAndroid.deviceUniqueName(i, cameraInfo);
            } else {
                string = "Camera 0, Facing back, Orientation 90";
            }
            List list = null;
            ArrayList<Object> arrayList2 = null;
            try {
                object2 = null;
                object2 = Build.VERSION.SDK_INT >= 9 ? Camera.open((int)i) : Camera.open();
                Camera.Parameters parameters = object2.getParameters();
                list = parameters.getSupportedPreviewSizes();
                if (Build.VERSION.SDK_INT >= 9) {
                    arrayList2 = parameters.getSupportedPreviewFpsRange();
                }
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Object>();
                    List list2 = parameters.getSupportedPreviewFrameRates();
                    if (list2 != null) {
                        for (Integer n2 : list2) {
                            int[] nArray = new int[]{n2 * 1000, n2 * 1000};
                            arrayList2.add(nArray);
                        }
                    } else {
                        Log.e((String)TAG, (String)"Camera doesn't know its own framerate, guessing 25fps.");
                        object = new int[2];
                        object[0] = 25000;
                        object[1] = 25000;
                        arrayList2.add(object);
                    }
                }
                object2.release();
                Log.d((String)TAG, (String)string);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)TAG, (String)("Failed to open " + string + ", skipping due to: " + runtimeException.getLocalizedMessage()));
                continue;
            }
            object2 = new CaptureCapabilityAndroid();
            int n3 = list.size();
            object2.width = new int[n3];
            object2.height = new int[n3];
            int n4 = 0;
            for (Integer n2 : list) {
                object2.width[n4] = ((Camera.Size)n2).width;
                object2.height[n4] = ((Camera.Size)n2).height;
                ++n4;
            }
            object = (int[])arrayList2.get(arrayList2.size() - 1);
            object2.name = string;
            if (Build.VERSION.SDK_INT >= 9) {
                object2.frontFacing = VideoCaptureDeviceInfoAndroid.isFrontFacing(cameraInfo);
                object2.orientation = cameraInfo.orientation;
                object2.minMilliFPS = (int)object[0];
                object2.maxMilliFPS = (int)object[1];
            } else {
                object2.frontFacing = false;
                object2.orientation = 90;
                object2.minMilliFPS = (int)object[0];
                object2.maxMilliFPS = (int)object[1];
            }
            arrayList.add((Camera)object2);
        }
        return arrayList.toArray(new CaptureCapabilityAndroid[0]);
    }
}

