/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.search;

import android.content.AsyncQueryHandler;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.LocaleAware;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.health.BrowserHealthRecorder;
import org.mozilla.search.AcceptsSearchQuery;
import org.mozilla.search.PostSearchFragment;
import org.mozilla.search.SearchPreferenceActivity;
import org.mozilla.search.autocomplete.SearchBar;
import org.mozilla.search.autocomplete.SuggestionsFragment;
import org.mozilla.search.providers.SearchEngine;
import org.mozilla.search.providers.SearchEngineManager;

public class SearchActivity
extends LocaleAware.LocaleAwareFragmentActivity
implements AcceptsSearchQuery,
SearchEngineManager.SearchEngineCallback {
    private static final String LOGTAG = "GeckoSearchActivity";
    private static final String KEY_SEARCH_STATE = "search_state";
    private static final String KEY_EDIT_STATE = "edit_state";
    private static final String KEY_QUERY = "query";
    private SearchState searchState = SearchState.PRESEARCH;
    private EditState editState = EditState.WAITING;
    private SearchEngineManager searchEngineManager;
    private SearchEngine engine;
    private SuggestionsFragment suggestionsFragment;
    private PostSearchFragment postSearchFragment;
    private AsyncQueryHandler queryHandler;
    private SearchBar searchBar;
    private View preSearch;
    private View postSearch;
    private View settingsButton;
    private View suggestions;
    private static final int SUGGESTION_TRANSITION_DURATION = 300;
    private static final Interpolator SUGGESTION_TRANSITION_INTERPOLATOR = new AccelerateDecelerateInterpolator();
    private View animationCard;
    private int cardPaddingX;
    private int cardPaddingY;

    protected void onCreate(Bundle bundle) {
        GeckoAppShell.ensureCrashHandling();
        super.onCreate(bundle);
        this.setContentView(R.layout.search_activity_main);
        this.suggestionsFragment = (SuggestionsFragment)this.getSupportFragmentManager().findFragmentById(R.id.suggestions);
        this.postSearchFragment = (PostSearchFragment)this.getSupportFragmentManager().findFragmentById(R.id.postsearch);
        this.searchEngineManager = new SearchEngineManager((Context)this);
        this.searchEngineManager.setChangeCallback(this);
        this.searchEngineManager.getEngine(this);
        this.queryHandler = new AsyncQueryHandler(this.getContentResolver()){};
        this.searchBar = (SearchBar)this.findViewById(R.id.search_bar);
        this.searchBar.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SearchActivity.this.setEditState(EditState.EDITING);
            }
        });
        this.searchBar.setTextListener(new SearchBar.TextListener(){

            @Override
            public void onChange(String string2) {
                if (SearchActivity.this.editState == EditState.EDITING) {
                    SearchActivity.this.suggestionsFragment.loadSuggestions(string2);
                }
            }

            @Override
            public void onSubmit(String string2) {
                String string3 = string2.trim();
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    SearchActivity.this.onSearch(string3);
                }
            }

            @Override
            public void onFocusChange(boolean bl) {
                SearchActivity.this.setEditState(bl ? EditState.EDITING : EditState.WAITING);
            }
        });
        this.preSearch = this.findViewById(R.id.presearch);
        this.postSearch = this.findViewById(R.id.postsearch);
        this.settingsButton = this.findViewById(R.id.settings_button);
        this.settingsButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                SearchActivity.this.startActivity(new Intent((Context)SearchActivity.this, SearchPreferenceActivity.class));
            }
        });
        this.suggestions = this.findViewById(R.id.suggestions);
        this.animationCard = this.findViewById(R.id.animation_card);
        this.cardPaddingX = this.getResources().getDimensionPixelSize(R.dimen.search_row_padding);
        this.cardPaddingY = this.getResources().getDimensionPixelSize(R.dimen.search_row_padding);
        if (bundle != null) {
            this.setSearchState(SearchState.valueOf(bundle.getString(KEY_SEARCH_STATE)));
            this.setEditState(EditState.valueOf(bundle.getString(KEY_EDIT_STATE)));
            String string2 = bundle.getString(KEY_QUERY);
            this.searchBar.setText(string2);
            if (this.searchState == SearchState.POSTSEARCH) {
                this.startSearch(string2);
            }
        } else {
            this.setEditState(EditState.EDITING);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.searchEngineManager.destroy();
        this.searchEngineManager = null;
        this.engine = null;
        this.suggestionsFragment = null;
        this.postSearchFragment = null;
        this.queryHandler = null;
        this.searchBar = null;
        this.preSearch = null;
        this.postSearch = null;
        this.settingsButton = null;
        this.suggestions = null;
        this.animationCard = null;
    }

    protected void onStart() {
        super.onStart();
        Telemetry.startUISession((TelemetryContract.Session)TelemetryContract.Session.SEARCH_ACTIVITY);
    }

    protected void onStop() {
        super.onStop();
        Telemetry.stopUISession((TelemetryContract.Session)TelemetryContract.Session.SEARCH_ACTIVITY);
    }

    public void onNewIntent(Intent intent) {
        this.setSearchState(SearchState.PRESEARCH);
        this.setEditState(EditState.EDITING);
        this.searchBar.setText("");
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putString(KEY_SEARCH_STATE, this.searchState.toString());
        bundle.putString(KEY_EDIT_STATE, this.editState.toString());
        bundle.putString(KEY_QUERY, this.searchBar.getText());
    }

    @Override
    public void onSuggest(String string2) {
        this.searchBar.setText(string2);
    }

    @Override
    public void onSearch(String string2) {
        this.onSearch(string2, null);
    }

    @Override
    public void onSearch(String string2, AcceptsSearchQuery.SuggestionAnimation suggestionAnimation) {
        this.storeQuery(string2);
        try {
            BrowserHealthRecorder.recordSearchDelayed((String)"activity", (String)this.engine.getIdentifier());
        }
        catch (Exception exception) {
            Log.w((String)LOGTAG, (String)"Unable to record search.");
        }
        this.startSearch(string2);
        if (suggestionAnimation != null) {
            this.searchBar.setText(string2);
            this.animateSuggestion(suggestionAnimation);
        } else {
            this.setEditState(EditState.WAITING);
            this.setSearchState(SearchState.POSTSEARCH);
        }
    }

    @Override
    public void onQueryChange(String string2) {
        this.searchBar.setText(string2);
    }

    private void startSearch(final String string2) {
        if (this.engine != null) {
            this.postSearchFragment.startSearch(this.engine, string2);
            return;
        }
        this.searchEngineManager.getEngine(new SearchEngineManager.SearchEngineCallback(){

            @Override
            public void execute(SearchEngine searchEngine) {
                SearchActivity.this.postSearchFragment.startSearch(searchEngine, string2);
            }
        });
    }

    @Override
    public void execute(SearchEngine searchEngine) {
        this.engine = searchEngine;
        this.suggestionsFragment.setEngine(searchEngine);
        this.searchBar.setEngine(searchEngine);
    }

    private void animateSuggestion(AcceptsSearchQuery.SuggestionAnimation suggestionAnimation) {
        Rect rect = suggestionAnimation.getStartBounds();
        Rect rect2 = new Rect();
        this.animationCard.getGlobalVisibleRect(rect2, null);
        float f = rect.centerY() - rect2.centerY();
        float f2 = (float)(rect.width() - this.cardPaddingX * 2) / (float)rect2.width();
        float f3 = (float)(rect.height() - this.cardPaddingY * 2) / (float)rect2.height();
        this.animationCard.setVisibility(0);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.animationCard, (String)"translationY", (float[])new float[]{f, 0.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"alpha", (float[])new float[]{0.5f, 1.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"scaleX", (float[])new float[]{f2, 1.0f}), ObjectAnimator.ofFloat((Object)this.animationCard, (String)"scaleY", (float[])new float[]{f3, 1.0f})});
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
            }

            public void onAnimationEnd(Animator animator) {
                SearchActivity.this.setEditState(EditState.WAITING);
                SearchActivity.this.setSearchState(SearchState.POSTSEARCH);
                SearchActivity.this.animationCard.clearAnimation();
                SearchActivity.this.animationCard.setVisibility(4);
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        });
        animatorSet.setDuration(300L);
        animatorSet.setInterpolator(SUGGESTION_TRANSITION_INTERPOLATOR);
        animatorSet.start();
    }

    private void setEditState(EditState editState) {
        if (this.editState == editState) {
            return;
        }
        this.editState = editState;
        this.updateSettingsButtonVisibility();
        this.searchBar.setActive(editState == EditState.EDITING);
        this.suggestions.setVisibility(editState == EditState.EDITING ? 0 : 4);
    }

    private void setSearchState(SearchState searchState) {
        if (this.searchState == searchState) {
            return;
        }
        this.searchState = searchState;
        this.updateSettingsButtonVisibility();
        this.preSearch.setVisibility(searchState == SearchState.PRESEARCH ? 0 : 4);
        this.postSearch.setVisibility(searchState == SearchState.POSTSEARCH ? 0 : 4);
    }

    private void updateSettingsButtonVisibility() {
        if (this.searchState == SearchState.PRESEARCH && this.editState == EditState.WAITING) {
            this.settingsButton.setVisibility(0);
        } else {
            this.settingsButton.setVisibility(4);
        }
    }

    public void onBackPressed() {
        if (this.editState == EditState.EDITING) {
            this.setEditState(EditState.WAITING);
        } else if (this.searchState == SearchState.POSTSEARCH) {
            this.setSearchState(SearchState.PRESEARCH);
        } else {
            super.onBackPressed();
        }
    }

    private void storeQuery(String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(KEY_QUERY, string2);
        this.queryHandler.startInsert(0, null, BrowserContract.SearchHistory.CONTENT_URI, contentValues);
    }

    static enum EditState {
        WAITING,
        EDITING;

    }

    static enum SearchState {
        PRESEARCH,
        POSTSEARCH;

    }
}

