/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.preferences;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.preference.Preference;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import org.mozilla.gecko.R;

class ModifiableHintPreference
extends Preference {
    private static final String LOGTAG = "ModifiableHintPref";
    private final Context mContext;
    private final String MATCH_STRING = "%I";
    private final int RESID_TEXT_VIEW = R.id.label_search_hint;
    private final int RESID_DRAWABLE = R.drawable.ab_add_search_engine;
    private final double SCALE_FACTOR = 0.5;

    public ModifiableHintPreference(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
    }

    public ModifiableHintPreference(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
    }

    protected View onCreateView(ViewGroup viewGroup) {
        View view = super.onCreateView(viewGroup);
        this.configurePreferenceView(view);
        return view;
    }

    private void configurePreferenceView(View view) {
        TextView textView = (TextView)view.findViewById(this.RESID_TEXT_VIEW);
        String string2 = textView.getText().toString();
        int n = string2.indexOf("%I");
        if (n != -1) {
            Drawable drawable2 = this.mContext.getResources().getDrawable(this.RESID_DRAWABLE);
            drawable2.setBounds(0, 0, (int)((double)drawable2.getIntrinsicWidth() * 0.5), (int)((double)drawable2.getIntrinsicHeight() * 0.5));
            ImageSpan imageSpan = new ImageSpan(drawable2);
            SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)string2);
            spannableStringBuilder.setSpan((Object)imageSpan, n, n + "%I".length(), 18);
            textView.setText((CharSequence)spannableStringBuilder, TextView.BufferType.SPANNABLE);
        }
    }
}

