/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.graphics.Path;

public class TabCurve {
    private static final float ASPECT_RATIO = 0.729f;
    private static final float W_M1 = 0.343f;
    private static final float W_M2 = 0.514f;
    private static final float W_M3 = 0.723f;
    private static final float H_M1 = 0.25f;
    private static final float H_M2 = 0.5f;
    private static final float H_M3 = 0.72f;
    private static final float H_M4 = 0.961f;

    private TabCurve() {
    }

    public static int getWidthForHeight(int n) {
        return (int)((float)n * 0.729f);
    }

    public static void drawFromTop(Path path, int n, int n2, Direction direction) {
        int n3 = TabCurve.getWidthForHeight(n2);
        path.cubicTo((float)n + (float)n3 * 0.343f * (float)direction.value, 0.0f, (float)n + (float)n3 * 0.514f * (float)direction.value, (float)n2 * 0.25f, (float)n + (float)n3 * 0.514f * (float)direction.value, (float)n2 * 0.5f);
        path.cubicTo((float)n + (float)n3 * 0.514f * (float)direction.value, (float)n2 * 0.72f, (float)n + (float)n3 * 0.723f * (float)direction.value, (float)n2 * 0.961f, (float)(n + n3 * direction.value), (float)n2);
    }

    public static void drawFromBottom(Path path, int n, int n2, Direction direction) {
        int n3 = TabCurve.getWidthForHeight(n2);
        path.cubicTo((float)n + (float)n3 * 0.277f * (float)direction.value, (float)n2 * 0.961f, (float)n + (float)n3 * 0.486f * (float)direction.value, (float)n2 * 0.72f, (float)n + (float)n3 * 0.486f * (float)direction.value, (float)n2 * 0.5f);
        path.cubicTo((float)n + (float)n3 * 0.486f * (float)direction.value, (float)n2 * 0.25f, (float)n + (float)n3 * 0.657f * (float)direction.value, 0.0f, (float)(n + n3 * direction.value), 0.0f);
    }

    public static enum Direction {
        LEFT(-1),
        RIGHT(1);

        private final int value;

        private Direction(int n2) {
            this.value = n2;
        }
    }
}

