/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import org.mozilla.gecko.R;

public class EllipsisTextView
extends TextView {
    private final String ellipsis = this.getResources().getString(R.string.ellipsis);
    private final int maxLines;
    private CharSequence originalText;

    public EllipsisTextView(Context context) {
        this(context, null);
    }

    public EllipsisTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public EllipsisTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attributeSet, R.styleable.EllipsisTextView, 0, 0);
        this.maxLines = typedArray.getInteger(0, 1);
        typedArray.recycle();
    }

    public void setOriginalText(CharSequence charSequence) {
        this.originalText = charSequence;
        this.setText(charSequence);
    }

    public void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        if (this.getLineCount() < this.maxLines) {
            this.setText(this.originalText);
        }
        if (this.getLineCount() > this.maxLines) {
            int n5 = this.getLayout().getLineEnd(this.maxLines - 1) - 1 - this.ellipsis.length();
            String string2 = this.getText().subSequence(0, n5) + this.ellipsis;
            this.setText(string2);
        }
    }
}

