/*
 * Decompiled with CFR 0.152.
 */
package ch.boye.httpclientandroidlib.impl.cookie;

import ch.boye.httpclientandroidlib.annotation.Immutable;
import ch.boye.httpclientandroidlib.client.utils.DateUtils;
import ch.boye.httpclientandroidlib.cookie.MalformedCookieException;
import ch.boye.httpclientandroidlib.cookie.SetCookie;
import ch.boye.httpclientandroidlib.impl.cookie.AbstractCookieAttributeHandler;
import ch.boye.httpclientandroidlib.util.Args;
import java.util.Date;

@Immutable
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] stringArray) {
        Args.notNull(stringArray, "Array of date patterns");
        this.datepatterns = stringArray;
    }

    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for expires attribute");
        }
        Date date = DateUtils.parseDate(string, this.datepatterns);
        if (date == null) {
            throw new MalformedCookieException("Unable to parse expires attribute: " + string);
        }
        setCookie.setExpiryDate(date);
    }
}

