/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.repositories.android;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public abstract class CachedSQLiteOpenHelper
extends SQLiteOpenHelper {
    private SQLiteDatabase readableDatabase;
    private SQLiteDatabase writableDatabase;

    public CachedSQLiteOpenHelper(Context context, String string2, SQLiteDatabase.CursorFactory cursorFactory, int n) {
        super(context, string2, cursorFactory, n);
    }

    protected synchronized SQLiteDatabase getCachedReadableDatabase() {
        if (this.readableDatabase == null) {
            if (this.writableDatabase == null) {
                this.readableDatabase = this.getReadableDatabase();
                return this.readableDatabase;
            }
            return this.writableDatabase;
        }
        return this.readableDatabase;
    }

    protected synchronized SQLiteDatabase getCachedWritableDatabase() {
        if (this.writableDatabase == null) {
            this.writableDatabase = this.getWritableDatabase();
        }
        return this.writableDatabase;
    }

    public synchronized void close() {
        if (this.readableDatabase != null) {
            this.readableDatabase.close();
            this.readableDatabase = null;
        }
        if (this.writableDatabase != null) {
            this.writableDatabase.close();
            this.writableDatabase = null;
        }
        super.close();
    }

    public boolean isClosed() {
        return this.readableDatabase == null && this.writableDatabase == null;
    }
}

