/*
 * Decompiled with CFR 0.152.
 */
package com.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.nineoldandroids.animation.Keyframe;
import com.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class FloatKeyframeSet
extends KeyframeSet {
    private float firstValue;
    private float lastValue;
    private float deltaValue;
    private boolean firstTime = true;

    public FloatKeyframeSet(Keyframe.FloatKeyframe ... floatKeyframeArray) {
        super(floatKeyframeArray);
    }

    @Override
    public Object getValue(float f) {
        return Float.valueOf(this.getFloatValue(f));
    }

    @Override
    public FloatKeyframeSet clone() {
        ArrayList arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[n];
        for (int i = 0; i < n; ++i) {
            floatKeyframeArray[i] = (Keyframe.FloatKeyframe)((Keyframe)arrayList.get(i)).clone();
        }
        FloatKeyframeSet floatKeyframeSet = new FloatKeyframeSet(floatKeyframeArray);
        return floatKeyframeSet;
    }

    public float getFloatValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(0)).getFloatValue();
                this.lastValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(1)).getFloatValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + f * this.deltaValue;
            }
            return ((Number)this.mEvaluator.evaluate(f, Float.valueOf(this.firstValue), Float.valueOf(this.lastValue))).floatValue();
        }
        if (f <= 0.0f) {
            Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
            Keyframe.FloatKeyframe floatKeyframe2 = (Keyframe.FloatKeyframe)this.mKeyframes.get(1);
            float f2 = floatKeyframe.getFloatValue();
            float f3 = floatKeyframe2.getFloatValue();
            float f4 = floatKeyframe.getFraction();
            float f5 = floatKeyframe2.getFraction();
            Interpolator interpolator = floatKeyframe2.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f6 = (f - f4) / (f5 - f4);
            return this.mEvaluator == null ? f2 + f6 * (f3 - f2) : ((Number)this.mEvaluator.evaluate(f6, Float.valueOf(f2), Float.valueOf(f3))).floatValue();
        }
        if (f >= 1.0f) {
            Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.FloatKeyframe floatKeyframe3 = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            float f7 = floatKeyframe.getFloatValue();
            float f8 = floatKeyframe3.getFloatValue();
            float f9 = floatKeyframe.getFraction();
            float f10 = floatKeyframe3.getFraction();
            Interpolator interpolator = floatKeyframe3.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f11 = (f - f9) / (f10 - f9);
            return this.mEvaluator == null ? f7 + f11 * (f8 - f7) : ((Number)this.mEvaluator.evaluate(f11, Float.valueOf(f7), Float.valueOf(f8))).floatValue();
        }
        Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.FloatKeyframe floatKeyframe4 = (Keyframe.FloatKeyframe)this.mKeyframes.get(i);
            if (f < floatKeyframe4.getFraction()) {
                Interpolator interpolator = floatKeyframe4.getInterpolator();
                if (interpolator != null) {
                    f = interpolator.getInterpolation(f);
                }
                float f12 = (f - floatKeyframe.getFraction()) / (floatKeyframe4.getFraction() - floatKeyframe.getFraction());
                float f13 = floatKeyframe.getFloatValue();
                float f14 = floatKeyframe4.getFloatValue();
                return this.mEvaluator == null ? f13 + f12 * (f14 - f13) : ((Number)this.mEvaluator.evaluate(f12, Float.valueOf(f13), Float.valueOf(f14))).floatValue();
            }
            floatKeyframe = floatKeyframe4;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).floatValue();
    }
}

