/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.voiceengine;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import org.mozilla.gecko.mozglue.WebRTCJNITarget;

@WebRTCJNITarget
class WebRtcAudioTrack {
    private AudioTrack _audioTrack;
    private Context _context;
    private AudioManager _audioManager;
    private ByteBuffer _playBuffer;
    private byte[] _tempBufPlay;
    private final ReentrantLock _playLock = new ReentrantLock();
    private boolean _doPlayInit = true;
    private boolean _doRecInit = true;
    private boolean _isRecording;
    private boolean _isPlaying;
    private int _bufferedPlaySamples;
    private int _playPosition;
    final String logTag = "WebRTC AT java";

    WebRtcAudioTrack() {
        try {
            this._playBuffer = ByteBuffer.allocateDirect(960);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
        }
        this._tempBufPlay = new byte[960];
    }

    private int InitPlayback(int n) {
        int n2 = AudioTrack.getMinBufferSize((int)n, (int)4, (int)2);
        int n3 = n2;
        if (n3 < 6000) {
            n3 *= 2;
        }
        this._bufferedPlaySamples = 0;
        if (this._audioTrack != null) {
            this._audioTrack.release();
            this._audioTrack = null;
        }
        try {
            this._audioTrack = new AudioTrack(0, n, 4, 2, n3, 1);
        }
        catch (Exception exception) {
            this.DoLog(exception.getMessage());
            return -1;
        }
        if (this._audioTrack.getState() != 1) {
            return -1;
        }
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            return 0;
        }
        return this._audioManager.getStreamMaxVolume(0);
    }

    private int StartPlayback() {
        try {
            this._audioTrack.play();
        }
        catch (IllegalStateException illegalStateException) {
            illegalStateException.printStackTrace();
            return -1;
        }
        this._isPlaying = true;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int StopPlayback() {
        this._playLock.lock();
        try {
            if (this._audioTrack.getPlayState() == 3) {
                try {
                    this._audioTrack.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    illegalStateException.printStackTrace();
                    int n = -1;
                    this._doPlayInit = true;
                    this._playLock.unlock();
                    return n;
                }
                this._audioTrack.flush();
            }
            this._audioTrack.release();
            this._audioTrack = null;
        }
        finally {
            this._doPlayInit = true;
            this._playLock.unlock();
        }
        this._isPlaying = false;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int PlayAudio(int n) {
        this._playLock.lock();
        try {
            if (this._audioTrack == null) {
                int n2 = -2;
                return n2;
            }
            if (this._doPlayInit) {
                try {
                    Process.setThreadPriority((int)-19);
                }
                catch (Exception exception) {
                    this.DoLog("Set play thread priority failed: " + exception.getMessage());
                }
                this._doPlayInit = false;
            }
            int n3 = 0;
            this._playBuffer.get(this._tempBufPlay);
            n3 = this._audioTrack.write(this._tempBufPlay, 0, n);
            this._playBuffer.rewind();
            this._bufferedPlaySamples += n3 >> 1;
            int n4 = this._audioTrack.getPlaybackHeadPosition();
            if (n4 < this._playPosition) {
                this._playPosition = 0;
            }
            this._bufferedPlaySamples -= n4 - this._playPosition;
            this._playPosition = n4;
            if (n3 != n) {
                int n5 = -1;
                return n5;
            }
        }
        finally {
            this._playLock.unlock();
        }
        return this._bufferedPlaySamples;
    }

    private int SetPlayoutSpeaker(boolean bl) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        if (this._audioManager == null) {
            this.DoLogErr("Could not change audio routing - no audio manager");
            return -1;
        }
        int n = Build.VERSION.SDK_INT;
        if (3 == n || 4 == n) {
            if (bl) {
                this._audioManager.setMode(0);
            } else {
                this._audioManager.setMode(2);
            }
        } else if ((Build.BRAND.equals("Samsung") || Build.BRAND.equals("samsung")) && (5 == n || 6 == n || 7 == n)) {
            if (bl) {
                this._audioManager.setMode(2);
                this._audioManager.setSpeakerphoneOn(bl);
            } else {
                this._audioManager.setSpeakerphoneOn(bl);
                this._audioManager.setMode(0);
            }
        } else {
            this._audioManager.setSpeakerphoneOn(bl);
        }
        return 0;
    }

    private int SetPlayoutVolume(int n) {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n2 = -1;
        if (this._audioManager != null) {
            this._audioManager.setStreamVolume(0, n, 0);
            n2 = 0;
        }
        return n2;
    }

    private int GetPlayoutVolume() {
        if (this._audioManager == null && this._context != null) {
            this._audioManager = (AudioManager)this._context.getSystemService("audio");
        }
        int n = -1;
        if (this._audioManager != null) {
            n = this._audioManager.getStreamVolume(0);
        }
        return n;
    }

    private void DoLog(String string) {
        Log.d((String)"WebRTC AT java", (String)string);
    }

    private void DoLogErr(String string) {
        Log.e((String)"WebRTC AT java", (String)string);
    }
}

