/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.ThumbnailHelper;
import org.mozilla.gecko.home.HomeContextMenuInfo;
import org.mozilla.gecko.home.TopSitesGridItemView;

public class TopSitesGridView
extends GridView {
    private static final String LOGTAG = "GeckoTopSitesGridView";
    private final int mMaxSites = this.getResources().getInteger(R.integer.number_of_top_sites);
    private final int mNumColumns = this.getResources().getInteger(R.integer.number_of_top_sites_cols);
    private final int mHorizontalSpacing;
    private final int mVerticalSpacing;
    private int mMeasuredWidth;
    private int mMeasuredHeight;
    private TopSitesGridContextMenuInfo mContextMenuInfo;
    private boolean mIsHandlingFocusChange;

    public TopSitesGridView(Context context) {
        this(context, null);
    }

    public TopSitesGridView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.topSitesGridViewStyle);
    }

    public TopSitesGridView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.setNumColumns(this.mNumColumns);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TopSitesGridView, n, 0);
        this.mHorizontalSpacing = typedArray.getDimensionPixelOffset(0, 0);
        this.mVerticalSpacing = typedArray.getDimensionPixelOffset(1, 0);
        typedArray.recycle();
    }

    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        this.mIsHandlingFocusChange = true;
        super.onFocusChanged(bl, n, rect);
        this.mIsHandlingFocusChange = false;
    }

    public void requestLayout() {
        if (!this.mIsHandlingFocusChange) {
            super.requestLayout();
        }
    }

    public int getColumnWidth() {
        int n = this.mNumColumns > 0 ? (this.mNumColumns - 1) * this.mHorizontalSpacing : 0;
        return (this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight() - n) / this.mNumColumns;
    }

    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        if (n3 == this.mMeasuredWidth) {
            this.setMeasuredDimension(this.mMeasuredWidth, this.mMeasuredHeight);
            return;
        }
        int n4 = this.getColumnWidth();
        TopSitesGridItemView topSitesGridItemView = new TopSitesGridItemView(this.getContext());
        AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)topSitesGridItemView.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new AbsListView.LayoutParams(-2, -2);
            topSitesGridItemView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        int n5 = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
        int n6 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        topSitesGridItemView.measure(n5, n6);
        int n7 = topSitesGridItemView.getMeasuredHeight();
        int n8 = topSitesGridItemView.getMeasuredWidth() - topSitesGridItemView.getPaddingLeft() - topSitesGridItemView.getPaddingRight();
        ThumbnailHelper.getInstance().setThumbnailWidth(n8);
        int n9 = (int)Math.ceil((double)this.mMaxSites / (double)this.mNumColumns);
        int n10 = n7 * n9;
        int n11 = n9 > 0 ? (n9 - 1) * this.mVerticalSpacing : 0;
        int n12 = n10 + this.getPaddingTop() + this.getPaddingBottom() + n11;
        this.setMeasuredDimension(n3, n12);
        this.mMeasuredWidth = n3;
        this.mMeasuredHeight = n12;
    }

    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public void setContextMenuInfo(TopSitesGridContextMenuInfo topSitesGridContextMenuInfo) {
        this.mContextMenuInfo = topSitesGridContextMenuInfo;
    }

    public static class TopSitesGridContextMenuInfo
    extends HomeContextMenuInfo {
        public int type = -1;

        public TopSitesGridContextMenuInfo(View view, int n, long l) {
            super(view, n, l);
            this.itemType = HomeContextMenuInfo.RemoveItemType.HISTORY;
        }
    }

    public static interface OnEditPinnedSiteListener {
        public void onEditPinnedSite(int var1, String var2);
    }
}

