/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Telemetry;
import org.mozilla.gecko.TelemetryContract;
import org.mozilla.gecko.fxa.activities.FxAccountGetStartedActivity;
import org.mozilla.gecko.util.HardwareUtils;

public class StartPane
extends Activity {
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setContentView(R.layout.onboard_start_pane);
        Button button = (Button)this.findViewById(R.id.button_account);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "firstrun-sync");
                StartPane.this.showAccountSetup();
            }
        });
        Button button2 = (Button)this.findViewById(R.id.button_browser);
        button2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Telemetry.sendUIEvent(TelemetryContract.Event.ACTION, TelemetryContract.Method.BUTTON, "firstrun-browser");
                StartPane.this.showBrowser();
            }
        });
        if (!HardwareUtils.isTablet() && !HardwareUtils.isTelevision()) {
            this.addDismissHandler();
        }
    }

    private void showBrowser() {
        this.finish();
    }

    private void showAccountSetup() {
        Intent intent = new Intent((Context)this, FxAccountGetStartedActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
        this.finish();
    }

    private void addDismissHandler() {
        final GestureDetector gestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                StartPane.this.finish();
                return true;
            }
        });
        this.findViewById(R.id.onboard_content).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return gestureDetector.onTouchEvent(motionEvent);
            }
        });
    }
}

