/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.db;

import android.content.ContentProviderOperation;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.R;
import org.mozilla.gecko.db.BrowserContract;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.db.DBUtils;
import org.mozilla.gecko.distribution.Distribution;
import org.mozilla.gecko.favicons.decoders.FaviconDecoder;
import org.mozilla.gecko.favicons.decoders.LoadFaviconResult;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.sync.Utils;
import org.mozilla.gecko.util.GeckoJarReader;
import org.mozilla.gecko.util.IOUtils;

public class LocalBrowserDB {
    private static final String LOGTAG = "GeckoLocalBrowserDB";
    private static final int FAVICON_ID_NOT_FOUND = Integer.MIN_VALUE;
    private static final boolean logDebug = Log.isLoggable((String)"GeckoLocalBrowserDB", (int)3);
    private final String mProfile;
    private final HashMap<String, Long> mFolderIdMap;
    private volatile Boolean mDesktopBookmarksExist;
    private final Uri mBookmarksUriWithProfile;
    private final Uri mParentsUriWithProfile;
    private final Uri mHistoryUriWithProfile;
    private final Uri mHistoryExpireUriWithProfile;
    private final Uri mCombinedUriWithProfile;
    private final Uri mUpdateHistoryUriWithProfile;
    private final Uri mFaviconsUriWithProfile;
    private final Uri mThumbnailsUriWithProfile;
    private final Uri mReadingListUriWithProfile;
    private static final String[] DEFAULT_BOOKMARK_COLUMNS = new String[]{"_id", "guid", "url", "title", "type", "parent"};

    protected static void debug(String string2) {
        if (logDebug) {
            Log.d((String)LOGTAG, (String)string2);
        }
    }

    public LocalBrowserDB(String string2) {
        this.mProfile = string2;
        this.mFolderIdMap = new HashMap();
        this.mBookmarksUriWithProfile = this.appendProfile(BrowserContract.Bookmarks.CONTENT_URI);
        this.mParentsUriWithProfile = this.appendProfile(BrowserContract.Bookmarks.PARENTS_CONTENT_URI);
        this.mHistoryUriWithProfile = this.appendProfile(BrowserContract.History.CONTENT_URI);
        this.mHistoryExpireUriWithProfile = this.appendProfile(BrowserContract.History.CONTENT_OLD_URI);
        this.mCombinedUriWithProfile = this.appendProfile(BrowserContract.Combined.CONTENT_URI);
        this.mFaviconsUriWithProfile = this.appendProfile(BrowserContract.Favicons.CONTENT_URI);
        this.mThumbnailsUriWithProfile = this.appendProfile(BrowserContract.Thumbnails.CONTENT_URI);
        this.mReadingListUriWithProfile = this.appendProfile(BrowserContract.ReadingListItems.CONTENT_URI);
        this.mUpdateHistoryUriWithProfile = this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("increment_visits", "true").appendQueryParameter("insert_if_needed", "true").build();
    }

    public int addDefaultBookmarks(Context context, ContentResolver contentResolver, int n) {
        int n2;
        long l = this.getFolderIdFromGuid(contentResolver, "mobile");
        if (l == -1L) {
            Log.e((String)LOGTAG, (String)"No mobile folder: cannot add default bookmarks.");
            return n;
        }
        Class<R.string> clazz = R.string.class;
        Field[] fieldArray = clazz.getFields();
        Pattern pattern = Pattern.compile("^bookmarkdefaults_title_");
        int n3 = n;
        long l2 = System.currentTimeMillis();
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        NameCounter nameCounter = new NameCounter(-1 - n, -1);
        for (n2 = 0; n2 < fieldArray.length; ++n2) {
            String string2 = fieldArray[n2].getName();
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) continue;
            try {
                byte[] byArray;
                int n4 = fieldArray[n2].getInt(null);
                String string3 = context.getString(n4);
                Field field = clazz.getField(string2.replace("_title_", "_url_"));
                int n5 = field.getInt(null);
                String string4 = context.getString(n5);
                ContentValues contentValues = LocalBrowserDB.createBookmark(l2, string3, string4, n3++, l);
                arrayList.add(contentValues);
                IOUtils.ConsumedInputStream consumedInputStream = LocalBrowserDB.getDefaultFaviconFromDrawable(context, string2);
                if (consumedInputStream == null) {
                    consumedInputStream = LocalBrowserDB.getDefaultFaviconFromPath(context, string2);
                }
                if (consumedInputStream == null) continue;
                try {
                    byArray = consumedInputStream.getTruncatedData();
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    continue;
                }
                ContentValues contentValues2 = LocalBrowserDB.createFavicon(string4, byArray);
                if (contentValues2 == null) continue;
                int n6 = nameCounter.get(string2);
                contentValues2.put("_id", Integer.valueOf(n6));
                contentValues.put("favicon_id", Integer.valueOf(n6));
                arrayList2.add(contentValues2);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                Log.wtf((String)LOGTAG, (String)"Reflection failure.", (Throwable)exception);
            }
        }
        if (!arrayList2.isEmpty()) {
            try {
                contentResolver.bulkInsert(this.mFaviconsUriWithProfile, arrayList2.toArray(new ContentValues[arrayList2.size()]));
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Error bulk-inserting default favicons.", (Throwable)exception);
            }
        }
        if (!arrayList.isEmpty()) {
            try {
                n2 = contentResolver.bulkInsert(this.mBookmarksUriWithProfile, arrayList.toArray(new ContentValues[arrayList.size()]));
                return n + n2;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Error bulk-inserting default bookmarks.", (Throwable)exception);
            }
        }
        return n;
    }

    public int addDistributionBookmarks(ContentResolver contentResolver, Distribution distribution, int n) {
        int n2;
        if (!distribution.exists()) {
            Log.d((String)LOGTAG, (String)"No distribution from which to add bookmarks.");
            return n;
        }
        JSONArray jSONArray = distribution.getBookmarks();
        if (jSONArray == null) {
            Log.d((String)LOGTAG, (String)"No distribution bookmarks.");
            return n;
        }
        long l = this.getFolderIdFromGuid(contentResolver, "mobile");
        if (l == -1L) {
            Log.e((String)LOGTAG, (String)"No mobile folder: cannot add distribution bookmarks.");
            return n;
        }
        Locale locale = Locale.getDefault();
        long l2 = System.currentTimeMillis();
        int n3 = n;
        int n4 = 0;
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        ArrayList<ContentValues> arrayList2 = new ArrayList<ContentValues>();
        NameCounter nameCounter = new NameCounter(-1 - n, -1);
        for (n2 = 0; n2 < jSONArray.length(); ++n2) {
            try {
                int n5;
                long l3;
                JSONObject jSONObject = jSONArray.getJSONObject(n2);
                String string2 = LocalBrowserDB.getLocalizedProperty(jSONObject, "title", locale);
                String string3 = LocalBrowserDB.getLocalizedProperty(jSONObject, "url", locale);
                if (jSONObject.has("pinned")) {
                    l3 = -3L;
                    n5 = n4++;
                } else {
                    l3 = l;
                    n5 = n3++;
                }
                ContentValues contentValues = LocalBrowserDB.createBookmark(l2, string2, string3, n5, l3);
                arrayList.add(contentValues);
                if (!jSONObject.has("icon")) continue;
                try {
                    ContentValues contentValues2;
                    String string4 = jSONObject.getString("icon");
                    byte[] byArray = BitmapUtils.getBytesFromDataURI(string4);
                    if (byArray == null || (contentValues2 = LocalBrowserDB.createFavicon(string3, byArray)) == null) continue;
                    boolean bl = nameCounter.has(string4);
                    int n6 = nameCounter.get(string4);
                    contentValues2.put("_id", Integer.valueOf(n6));
                    contentValues.put("favicon_id", Integer.valueOf(n6));
                    if (bl) continue;
                    arrayList2.add(contentValues2);
                }
                catch (JSONException jSONException) {
                    Log.e((String)LOGTAG, (String)"Error creating distribution bookmark icon.", (Throwable)jSONException);
                }
                continue;
            }
            catch (JSONException jSONException) {
                Log.e((String)LOGTAG, (String)"Error creating distribution bookmark.", (Throwable)jSONException);
            }
        }
        if (!arrayList2.isEmpty()) {
            try {
                contentResolver.bulkInsert(this.mFaviconsUriWithProfile, arrayList2.toArray(new ContentValues[arrayList2.size()]));
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Error bulk-inserting distribution favicons.", (Throwable)exception);
            }
        }
        if (!arrayList.isEmpty()) {
            try {
                n2 = contentResolver.bulkInsert(this.mBookmarksUriWithProfile, arrayList.toArray(new ContentValues[arrayList.size()]));
                return n + n2;
            }
            catch (Exception exception) {
                Log.e((String)LOGTAG, (String)"Error bulk-inserting distribution bookmarks.", (Throwable)exception);
            }
        }
        return n;
    }

    private static ContentValues createBookmark(long l, String string2, String string3, int n, long l2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("created", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l));
        contentValues.put("guid", Utils.generateGuid());
        contentValues.put("parent", Long.valueOf(l2));
        contentValues.put("position", Integer.valueOf(n));
        contentValues.put("title", string2);
        contentValues.put("url", string3);
        return contentValues;
    }

    private static ContentValues createFavicon(String string2, byte[] byArray) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("page_url", string2);
        contentValues.put("data", byArray);
        return contentValues;
    }

    private static String getLocalizedProperty(JSONObject jSONObject, String string2, Locale locale) throws JSONException {
        String string3;
        String string4 = string2 + "." + locale.toString();
        if (jSONObject.has(string4)) {
            return jSONObject.getString(string4);
        }
        if (!TextUtils.isEmpty((CharSequence)locale.getVariant()) && jSONObject.has(string3 = string4.substring(0, string4.lastIndexOf("_")))) {
            return jSONObject.getString(string3);
        }
        string3 = string2 + "." + locale.getLanguage();
        if (jSONObject.has(string3)) {
            return jSONObject.getString(string3);
        }
        return jSONObject.getString(string2);
    }

    private static int getFaviconId(String string2) {
        try {
            Class<R.raw> clazz = R.raw.class;
            Field field = clazz.getField(string2.replace("_title_", "_favicon_"));
            field.setAccessible(true);
            return field.getInt(null);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            Log.wtf((String)LOGTAG, (String)("Reflection error fetching favicon: " + string2), (Throwable)reflectiveOperationException);
            Log.e((String)LOGTAG, (String)("Failed to find favicon resource ID for " + string2));
            return Integer.MIN_VALUE;
        }
    }

    private static IOUtils.ConsumedInputStream getDefaultFaviconFromPath(Context context, String string2) {
        int n = LocalBrowserDB.getFaviconId(string2);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        String string3 = context.getString(n);
        String string4 = context.getPackageResourcePath();
        File file = new File(string4);
        String string5 = "jar:jar:" + file.toURI() + "!/" + "assets/omni.ja" + "!/" + string3;
        InputStream inputStream = GeckoJarReader.getStream((String)string5);
        return IOUtils.readFully((InputStream)inputStream, (int)25000);
    }

    private static IOUtils.ConsumedInputStream getDefaultFaviconFromDrawable(Context context, String string2) {
        int n = LocalBrowserDB.getFaviconId(string2);
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        InputStream inputStream = context.getResources().openRawResource(n);
        return IOUtils.readFully((InputStream)inputStream, (int)25000);
    }

    public void invalidateCachedState() {
        this.mDesktopBookmarksExist = null;
    }

    private Uri bookmarksUriWithLimit(int n) {
        return this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
    }

    private Uri combinedUriWithLimit(int n) {
        return this.mCombinedUriWithProfile.buildUpon().appendQueryParameter("limit", String.valueOf(n)).build();
    }

    private Uri appendProfile(Uri uri) {
        return uri.buildUpon().appendQueryParameter("profile", this.mProfile).build();
    }

    private Uri getAllBookmarksUri() {
        Uri.Builder builder = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Uri getAllHistoryUri() {
        Uri.Builder builder = this.mHistoryUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Uri getAllFaviconsUri() {
        Uri.Builder builder = this.mFaviconsUriWithProfile.buildUpon().appendQueryParameter("show_deleted", "1");
        return builder.build();
    }

    private Cursor filterAllSites(ContentResolver contentResolver, String[] stringArray, CharSequence charSequence, int n, CharSequence charSequence2, String string2, String[] stringArray2) {
        Object object;
        if (!TextUtils.isEmpty((CharSequence)charSequence)) {
            object = charSequence.toString().split(" ");
            int n2 = Math.min(((String[])object).length, 10);
            for (int i = 0; i < n2; ++i) {
                string2 = DBUtils.concatenateWhere(string2, "(url LIKE ? OR title LIKE ?)");
                String string3 = "%" + object[i] + "%";
                stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{string3, string3});
            }
        }
        if (charSequence2 != null) {
            string2 = DBUtils.concatenateWhere(string2, "(url NOT LIKE ?)");
            stringArray2 = DBUtils.appendSelectionArgs(stringArray2, new String[]{charSequence2.toString()});
        }
        object = BrowserContract.getFrecencySortOrder(true, false);
        return contentResolver.query(this.combinedUriWithLimit(n), stringArray, string2, stringArray2, (String)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount(ContentResolver contentResolver, String string2) {
        int n = 0;
        String[] stringArray = null;
        String string3 = null;
        Uri uri = null;
        if ("history".equals(string2)) {
            uri = this.mHistoryUriWithProfile;
            stringArray = new String[]{"_id"};
            string3 = "visits > 0";
        } else if ("bookmarks".equals(string2)) {
            uri = this.mBookmarksUriWithProfile;
            stringArray = new String[]{"_id"};
            string3 = "type = 1";
        } else if ("thumbnails".equals(string2)) {
            uri = this.mThumbnailsUriWithProfile;
            stringArray = new String[]{"_id"};
        } else if ("favicons".equals(string2)) {
            uri = this.mFaviconsUriWithProfile;
            stringArray = new String[]{"_id"};
        } else if ("readinglist".equals(string2)) {
            uri = this.mReadingListUriWithProfile;
            stringArray = new String[]{"_id"};
        }
        if (uri != null) {
            try (Cursor cursor = contentResolver.query(uri, stringArray, string3, null, null);){
                n = cursor.getCount();
            }
        }
        LocalBrowserDB.debug("Got count " + n + " for " + string2);
        return n;
    }

    @RobocopTarget
    public Cursor filter(ContentResolver contentResolver, CharSequence charSequence, int n, EnumSet<BrowserDB.FilterFlags> enumSet) {
        String string2 = "";
        String[] stringArray = null;
        if (enumSet.contains((Object)BrowserDB.FilterFlags.EXCLUDE_PINNED_SITES)) {
            string2 = "url NOT IN (SELECT url FROM bookmarks WHERE " + DBUtils.qualifyColumn("bookmarks", "parent") + " = ? AND " + DBUtils.qualifyColumn("bookmarks", "deleted") + " == 0)";
            stringArray = new String[]{String.valueOf(-3)};
        }
        return this.filterAllSites(contentResolver, new String[]{"_id", "url", "title", "bookmark_id", "history_id"}, charSequence, n, null, string2, stringArray);
    }

    public Cursor getTopSites(ContentResolver contentResolver, int n) {
        String string2 = DBUtils.concatenateWhere("history_id <> -1", "url NOT IN (SELECT url FROM bookmarks WHERE " + DBUtils.qualifyColumn("bookmarks", "parent") + " < ? AND " + DBUtils.qualifyColumn("bookmarks", "deleted") + " == 0)");
        String[] stringArray = new String[]{String.valueOf(0)};
        return this.filterAllSites(contentResolver, new String[]{"_id", "url", "title", "bookmark_id", "history_id"}, "", n, "about:%", string2, stringArray);
    }

    public void updateVisitedHistory(ContentResolver contentResolver, String string2) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string2);
        contentValues.put("date", Long.valueOf(System.currentTimeMillis()));
        contentValues.put("deleted", Integer.valueOf(0));
        contentResolver.update(this.mUpdateHistoryUriWithProfile, contentValues, "url = ?", new String[]{string2});
    }

    public void updateHistoryTitle(ContentResolver contentResolver, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", string3);
        contentResolver.update(this.mHistoryUriWithProfile, contentValues, "url = ?", new String[]{string2});
    }

    @RobocopTarget
    public Cursor getAllVisitedHistory(ContentResolver contentResolver) {
        return contentResolver.query(this.mHistoryUriWithProfile, new String[]{"url"}, "visits > 0", null, null);
    }

    public Cursor getRecentHistory(ContentResolver contentResolver, int n) {
        return contentResolver.query(this.combinedUriWithLimit(n), new String[]{"_id", "bookmark_id", "history_id", "url", "title", "date", "visits"}, "date > 0", null, "date DESC");
    }

    public void expireHistory(ContentResolver contentResolver, BrowserContract.ExpirePriority expirePriority) {
        Uri uri = this.mHistoryExpireUriWithProfile;
        uri = uri.buildUpon().appendQueryParameter("priority", expirePriority.toString()).build();
        contentResolver.delete(uri, null, null);
    }

    @RobocopTarget
    public void removeHistoryEntry(ContentResolver contentResolver, String string2) {
        contentResolver.delete(this.mHistoryUriWithProfile, "url = ?", new String[]{string2});
    }

    public void clearHistory(ContentResolver contentResolver) {
        contentResolver.delete(this.mHistoryUriWithProfile, null, null);
    }

    @RobocopTarget
    public Cursor getBookmarksInFolder(ContentResolver contentResolver, long l) {
        boolean bl;
        if (l == 0L) {
            l = this.getFolderIdFromGuid(contentResolver, "mobile");
            bl = this.desktopBookmarksExist(contentResolver);
        } else {
            bl = false;
        }
        Cursor cursor = l == -1L ? contentResolver.query(this.mBookmarksUriWithProfile, DEFAULT_BOOKMARK_COLUMNS, "guid = ? OR guid = ? OR guid = ?", new String[]{"toolbar", "menu", "unfiled"}, null) : contentResolver.query(this.mBookmarksUriWithProfile, DEFAULT_BOOKMARK_COLUMNS, "parent = ? AND (type = ? OR (type = ? AND url IS NOT NULL))", new String[]{String.valueOf(l), String.valueOf(0), String.valueOf(1)}, null);
        if (bl) {
            return new SpecialFoldersCursorWrapper(cursor, bl);
        }
        return cursor;
    }

    public Cursor getReadingList(ContentResolver contentResolver) {
        return contentResolver.query(this.mReadingListUriWithProfile, BrowserContract.ReadingListItems.DEFAULT_PROJECTION, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean desktopBookmarksExist(ContentResolver contentResolver) {
        if (this.mDesktopBookmarksExist != null) {
            return this.mDesktopBookmarksExist;
        }
        try (Cursor cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id"}, "parent = ? OR parent = ? OR parent = ?", new String[]{String.valueOf(this.getFolderIdFromGuid(contentResolver, "toolbar")), String.valueOf(this.getFolderIdFromGuid(contentResolver, "menu")), String.valueOf(this.getFolderIdFromGuid(contentResolver, "unfiled"))}, null);){
            boolean bl = cursor.getCount() > 0;
            this.mDesktopBookmarksExist = bl;
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public boolean isBookmark(ContentResolver contentResolver, String string2) {
        Cursor cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id"}, "url = ? AND parent != ?", new String[]{string2, String.valueOf(-3)}, "url");
        if (cursor == null) {
            Log.e((String)LOGTAG, (String)"Null cursor in isBookmark");
            return false;
        }
        try {
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadingListItem(ContentResolver contentResolver, String string2) {
        Cursor cursor = contentResolver.query(this.mReadingListUriWithProfile, new String[]{"_id"}, "url = ? ", new String[]{string2}, null);
        if (cursor == null) {
            Log.e((String)LOGTAG, (String)"Null cursor in isReadingListItem");
            return false;
        }
        try {
            boolean bl = cursor.getCount() > 0;
            return bl;
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUrlForKeyword(ContentResolver contentResolver, String string2) {
        try (Cursor cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"url"}, "keyword = ?", new String[]{string2}, null);){
            if (!cursor.moveToFirst()) {
                String string3 = null;
                return string3;
            }
            String string4 = cursor.getString(cursor.getColumnIndexOrThrow("url"));
            return string4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long getFolderIdFromGuid(ContentResolver contentResolver, String string2) {
        if (this.mFolderIdMap.containsKey(string2)) {
            return this.mFolderIdMap.get(string2);
        }
        try (Cursor cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"_id"}, "guid = ?", new String[]{string2}, null);){
            int n = cursor.getColumnIndexOrThrow("_id");
            if (!cursor.moveToFirst() || cursor.isNull(n)) {
                long l = -1L;
                return l;
            }
            long l = cursor.getLong(n);
            this.mFolderIdMap.put(string2, l);
            long l2 = l;
            return l2;
        }
    }

    protected void bumpParents(ContentResolver contentResolver, String string2, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        String string4 = string2 + " = ?";
        String[] stringArray = new String[]{string3};
        int n = contentResolver.update(this.mParentsUriWithProfile, contentValues, string4, stringArray);
        LocalBrowserDB.debug("Updated " + n + " rows to new modified time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBookmarkItem(ContentResolver contentResolver, String string2, String string3, long l) {
        long l2 = System.currentTimeMillis();
        ContentValues contentValues = new ContentValues();
        if (string2 != null) {
            contentValues.put("title", string2);
        }
        contentValues.put("url", string3);
        contentValues.put("parent", Long.valueOf(l));
        contentValues.put("modified", Long.valueOf(l2));
        try (Cursor cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"favicon_id"}, "url = ?", new String[]{string3}, null);){
            int n;
            if (cursor.moveToFirst() && !cursor.isNull(n = cursor.getColumnIndexOrThrow("favicon_id"))) {
                contentValues.put("favicon_id", Long.valueOf(cursor.getLong(n)));
            }
        }
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "url = ? AND parent = " + l, new String[]{string3});
        LocalBrowserDB.debug("Bumping parent modified time for addition to: " + l);
        String[] stringArray = new String[]{String.valueOf(l)};
        ContentValues contentValues2 = new ContentValues();
        contentValues2.put("modified", Long.valueOf(l2));
        int n = contentResolver.update(this.mBookmarksUriWithProfile, contentValues2, "_id = ?", stringArray);
        LocalBrowserDB.debug("Updated " + n + " rows to new modified time.");
    }

    @RobocopTarget
    public void addBookmark(ContentResolver contentResolver, String string2, String string3) {
        long l = this.getFolderIdFromGuid(contentResolver, "mobile");
        this.addBookmarkItem(contentResolver, string2, string3, l);
    }

    @RobocopTarget
    public void removeBookmarksWithURL(ContentResolver contentResolver, String string2) {
        Uri uri = this.mBookmarksUriWithProfile;
        this.bumpParents(contentResolver, "url", string2);
        String[] stringArray = new String[]{string2, String.valueOf(-3)};
        contentResolver.delete(uri, "url = ? AND parent != ? ", stringArray);
    }

    public void addReadingListItem(ContentResolver contentResolver, ContentValues contentValues) {
        for (String string2 : BrowserContract.ReadingListItems.REQUIRED_FIELDS) {
            if (contentValues.containsKey(string2)) continue;
            throw new IllegalArgumentException("Missing required field for reading list item: " + string2);
        }
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mReadingListUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        int n = contentResolver.update(uri, contentValues, "url = ? ", new String[]{contentValues.getAsString("url")});
        LocalBrowserDB.debug("Updated " + n + " rows to new modified time.");
    }

    public void removeReadingListItemWithURL(ContentResolver contentResolver, String string2) {
        contentResolver.delete(this.mReadingListUriWithProfile, "url = ? ", new String[]{string2});
    }

    public void registerBookmarkObserver(ContentResolver contentResolver, ContentObserver contentObserver) {
        contentResolver.registerContentObserver(this.mBookmarksUriWithProfile, false, contentObserver);
    }

    @RobocopTarget
    public void updateBookmark(ContentResolver contentResolver, int n, String string2, String string3, String string4) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("title", string3);
        contentValues.put("url", string2);
        contentValues.put("keyword", string4);
        contentValues.put("modified", Long.valueOf(System.currentTimeMillis()));
        contentResolver.update(this.mBookmarksUriWithProfile, contentValues, "_id = ?", new String[]{String.valueOf(n)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadFaviconResult getFaviconForUrl(ContentResolver contentResolver, String string2) {
        byte[] byArray = null;
        try (Cursor cursor = contentResolver.query(this.mFaviconsUriWithProfile, new String[]{"data"}, "url = ? AND data IS NOT NULL", new String[]{string2}, null);){
            if (!cursor.moveToFirst()) {
                LoadFaviconResult loadFaviconResult = null;
                return loadFaviconResult;
            }
            int n = cursor.getColumnIndexOrThrow("data");
            byArray = cursor.getBlob(n);
        }
        if (byArray == null) {
            return null;
        }
        return FaviconDecoder.decodeFavicon(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFaviconURLFromPageURL(ContentResolver contentResolver, String string2) {
        try (Cursor cursor = contentResolver.query(this.mHistoryUriWithProfile, new String[]{"favicon_url"}, "url = ?", new String[]{string2}, null);){
            String string3;
            int n;
            if (cursor.moveToFirst() && !cursor.isNull(n = cursor.getColumnIndexOrThrow("favicon_url")) && (string3 = cursor.getString(n)) != null) {
                String string4 = string3;
                return string4;
            }
        }
        cursor = contentResolver.query(this.mBookmarksUriWithProfile, new String[]{"favicon_url"}, "url = ?", new String[]{string2}, null);
        try {
            if (cursor.moveToFirst()) {
                String string5 = cursor.getString(cursor.getColumnIndexOrThrow("favicon_url"));
                return string5;
            }
            String string6 = null;
            return string6;
        }
        finally {
            cursor.close();
        }
    }

    public void updateFaviconForUrl(ContentResolver contentResolver, String string2, byte[] byArray, String string3) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string3);
        contentValues.put("page_url", string2);
        contentValues.put("data", byArray);
        Uri uri = this.getAllFaviconsUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        int n = contentResolver.update(uri, contentValues, "url = ?", new String[]{string3});
        if (n == 0) {
            return;
        }
        int n2 = this.getIDForFaviconURL(contentResolver, string3);
        if (n2 == Integer.MIN_VALUE) {
            return;
        }
        this.updateHistoryAndBookmarksFaviconID(contentResolver, string2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getIDForFaviconURL(ContentResolver contentResolver, String string2) {
        try (Cursor cursor = contentResolver.query(this.mFaviconsUriWithProfile, new String[]{"_id"}, "url = ? AND data IS NOT NULL", new String[]{string2}, null);){
            int n = cursor.getColumnIndexOrThrow("_id");
            if (cursor.moveToFirst() && !cursor.isNull(n)) {
                Integer n2 = cursor.getInt(n);
                return n2;
            }
            Integer n3 = Integer.MIN_VALUE;
            return n3;
        }
    }

    private void updateHistoryAndBookmarksFaviconID(ContentResolver contentResolver, String string2, int n) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("favicon_id", Integer.valueOf(n));
        contentResolver.update(this.mBookmarksUriWithProfile, contentValues, "url = ?", new String[]{string2});
        ContentValues contentValues2 = new ContentValues();
        contentValues2.put("favicon_id", Integer.valueOf(n));
        contentResolver.update(this.mHistoryUriWithProfile, contentValues2, "url = ?", new String[]{string2});
    }

    public void updateThumbnailForUrl(ContentResolver contentResolver, String string2, BitmapDrawable bitmapDrawable) {
        if (bitmapDrawable == null) {
            contentResolver.delete(this.mThumbnailsUriWithProfile, "url == ?", new String[]{string2});
            return;
        }
        Bitmap bitmap = bitmapDrawable.getBitmap();
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)byteArrayOutputStream)) {
            byArray = byteArrayOutputStream.toByteArray();
        } else {
            Log.w((String)LOGTAG, (String)"Favicon compression failed.");
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("url", string2);
        contentValues.put("data", byArray);
        Uri uri = this.mThumbnailsUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "url = ?", new String[]{string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RobocopTarget
    public byte[] getThumbnailForUrl(ContentResolver contentResolver, String string2) {
        try (Cursor cursor = contentResolver.query(this.mThumbnailsUriWithProfile, new String[]{"data"}, "url = ? AND data IS NOT NULL", new String[]{string2}, null);){
            if (!cursor.moveToFirst()) {
                byte[] byArray = null;
                return byArray;
            }
            int n = cursor.getColumnIndexOrThrow("data");
            byte[] byArray = cursor.getBlob(n);
            return byArray;
        }
    }

    public Cursor getThumbnailsForUrls(ContentResolver contentResolver, List<String> list) {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n == 0) {
            return null;
        }
        String string2 = "data IS NOT NULL AND " + DBUtils.computeSQLInClause(n, "url");
        String[] stringArray = list.toArray(new String[n]);
        return contentResolver.query(this.mThumbnailsUriWithProfile, new String[]{"url", "data"}, string2, stringArray, null);
    }

    @RobocopTarget
    public void removeThumbnails(ContentResolver contentResolver) {
        contentResolver.delete(this.mThumbnailsUriWithProfile, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHistoryInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, long l, int n) {
        String[] stringArray = new String[]{"_id", "visits", "date"};
        try (Cursor cursor = contentResolver.query(this.getAllHistoryUri(), stringArray, "url = ?", new String[]{string2}, null);){
            ContentValues contentValues = new ContentValues();
            contentValues.put("deleted", Integer.valueOf(0));
            if (cursor.moveToFirst()) {
                int n2 = cursor.getColumnIndexOrThrow("visits");
                int n3 = cursor.getColumnIndexOrThrow("date");
                int n4 = cursor.getInt(n2);
                long l2 = cursor.getLong(n3);
                contentValues.put("visits", Integer.valueOf(n4 + n));
                if (l > l2) {
                    contentValues.put("date", Long.valueOf(l));
                }
            } else {
                contentValues.put("visits", Integer.valueOf(n));
                contentValues.put("date", Long.valueOf(l));
            }
            if (string3 != null) {
                contentValues.put("title", string3);
            }
            contentValues.put("url", string2);
            Uri uri = this.getAllHistoryUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
            ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
            builder.withSelection("url = ?", new String[]{string2});
            builder.withValues(contentValues);
            collection.add(builder.build());
        }
    }

    public void updateBookmarkInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, String string4, long l, long l2, long l3, long l4, String string5, int n) {
        ContentValues contentValues = new ContentValues();
        if (string3 == null && string2 != null) {
            string3 = string2;
        }
        if (string3 != null) {
            contentValues.put("title", string3);
        }
        if (string2 != null) {
            contentValues.put("url", string2);
        }
        if (string4 != null) {
            contentValues.put("guid", string4);
        }
        if (string5 != null) {
            contentValues.put("keyword", string5);
        }
        if (l2 > 0L) {
            contentValues.put("created", Long.valueOf(l2));
        }
        if (l3 > 0L) {
            contentValues.put("modified", Long.valueOf(l3));
        }
        contentValues.put("position", Long.valueOf(l4));
        contentValues.put("deleted", Integer.valueOf(0));
        if (l < 0L) {
            l = this.getFolderIdFromGuid(contentResolver, "mobile");
        }
        contentValues.put("parent", Long.valueOf(l));
        contentValues.put("type", Integer.valueOf(n));
        Uri uri = this.getAllBookmarksUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
        if (string2 != null) {
            builder.withSelection("url = ? AND parent = ?", new String[]{string2, Long.toString(l)});
        } else if (string3 != null) {
            builder.withSelection("title = ? AND parent = ?", new String[]{string3, Long.toString(l)});
        } else if (n == 2) {
            builder.withSelection("position = ? AND parent = ?", new String[]{Long.toString(l4), Long.toString(l)});
        } else {
            Log.e((String)LOGTAG, (String)"Bookmark entry without url or title and not a separator, not added.");
        }
        builder.withValues(contentValues);
        collection.add(builder.build());
    }

    public void updateFaviconInBatch(ContentResolver contentResolver, Collection<ContentProviderOperation> collection, String string2, String string3, String string4, byte[] byArray) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("data", byArray);
        contentValues.put("page_url", string2);
        if (string3 != null) {
            contentValues.put("url", string3);
        }
        Uri uri = this.getAllFaviconsUri().buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newUpdate((Uri)uri);
        builder.withValues(contentValues);
        builder.withSelection("page_url = ?", new String[]{string2});
        collection.add(builder.build());
    }

    public void pinSite(ContentResolver contentResolver, String string2, String string3, int n) {
        ContentValues contentValues = new ContentValues();
        long l = System.currentTimeMillis();
        contentValues.put("title", string3);
        contentValues.put("url", string2);
        contentValues.put("parent", Integer.valueOf(-3));
        contentValues.put("modified", Long.valueOf(l));
        contentValues.put("position", Integer.valueOf(n));
        contentValues.put("deleted", Integer.valueOf(0));
        Uri uri = this.mBookmarksUriWithProfile.buildUpon().appendQueryParameter("insert_if_needed", "true").build();
        contentResolver.update(uri, contentValues, "position = ? AND parent = ?", new String[]{Integer.toString(n), String.valueOf(-3)});
    }

    public Cursor getPinnedSites(ContentResolver contentResolver, int n) {
        return contentResolver.query(this.bookmarksUriWithLimit(n), new String[]{"_id", "url", "title", "position"}, "parent == ?", new String[]{String.valueOf(-3)}, "position ASC");
    }

    public void unpinSite(ContentResolver contentResolver, int n) {
        contentResolver.delete(this.mBookmarksUriWithProfile, "parent == ? AND position = ?", new String[]{String.valueOf(-3), Integer.toString(n)});
    }

    @RobocopTarget
    public Cursor getBookmarkForUrl(ContentResolver contentResolver, String string2) {
        Cursor cursor = contentResolver.query(this.bookmarksUriWithLimit(1), new String[]{"_id", "url", "title", "keyword"}, "url = ?", new String[]{string2}, null);
        if (cursor != null && cursor.getCount() == 0) {
            cursor.close();
            cursor = null;
        }
        return cursor;
    }

    private static class SpecialFoldersCursorWrapper
    extends CursorWrapper {
        private int mIndexOffset;
        private int mDesktopBookmarksIndex = -1;
        private boolean mAtDesktopBookmarksPosition;

        public SpecialFoldersCursorWrapper(Cursor cursor, boolean bl) {
            super(cursor);
            if (bl) {
                this.mDesktopBookmarksIndex = this.mIndexOffset++;
            }
        }

        public int getCount() {
            return super.getCount() + this.mIndexOffset;
        }

        public boolean moveToPosition(int n) {
            boolean bl = this.mAtDesktopBookmarksPosition = this.mDesktopBookmarksIndex == n;
            if (this.mAtDesktopBookmarksPosition) {
                return true;
            }
            return super.moveToPosition(n - this.mIndexOffset);
        }

        public long getLong(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getLong(n);
            }
            if (n == this.getColumnIndex("parent")) {
                return 0L;
            }
            return -1L;
        }

        public int getInt(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getInt(n);
            }
            if (n == this.getColumnIndex("_id") && this.mAtDesktopBookmarksPosition) {
                return -1;
            }
            if (n == this.getColumnIndex("type")) {
                return 0;
            }
            return -1;
        }

        public String getString(int n) {
            if (!this.mAtDesktopBookmarksPosition) {
                return super.getString(n);
            }
            if (n == this.getColumnIndex("guid") && this.mAtDesktopBookmarksPosition) {
                return "desktop";
            }
            return "";
        }
    }

    private static class NameCounter {
        private final HashMap<String, Integer> names = new HashMap();
        private int counter;
        private final int increment;

        public NameCounter(int n, int n2) {
            this.counter = n;
            this.increment = n2;
        }

        public int get(String string2) {
            Integer n = this.names.get(string2);
            if (n == null) {
                int n2 = this.counter;
                this.counter += this.increment;
                this.names.put(string2, n2);
                return n2;
            }
            return n;
        }

        public boolean has(String string2) {
            return this.names.containsKey(string2);
        }
    }
}

