/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync;

import android.content.SharedPreferences;
import org.mozilla.gecko.sync.BackoffHandler;

public class PrefsBackoffHandler
implements BackoffHandler {
    public static final String PREF_EARLIEST_NEXT = "earliestnext";
    private final SharedPreferences prefs;
    private final String prefEarliest;

    public PrefsBackoffHandler(SharedPreferences sharedPreferences, String string2) {
        if (sharedPreferences == null) {
            throw new IllegalArgumentException("prefs must not be null.");
        }
        this.prefs = sharedPreferences;
        this.prefEarliest = "earliestnext." + string2;
    }

    @Override
    public synchronized long getEarliestNextRequest() {
        return this.prefs.getLong(this.prefEarliest, 0L);
    }

    @Override
    public synchronized void setEarliestNextRequest(long l) {
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putLong(this.prefEarliest, l);
        editor.commit();
    }

    @Override
    public synchronized void extendEarliestNextRequest(long l) {
        if (this.prefs.getLong(this.prefEarliest, 0L) >= l) {
            return;
        }
        SharedPreferences.Editor editor = this.prefs.edit();
        editor.putLong(this.prefEarliest, l);
        editor.commit();
    }

    @Override
    public long delayMilliseconds() {
        long l = this.getEarliestNextRequest();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = System.currentTimeMillis();
        return Math.max(0L, l - l2);
    }
}

