/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.sync.jpake.stage;

import java.io.UnsupportedEncodingException;
import org.mozilla.apache.commons.codec.binary.Base64;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.sync.ExtendedJSONObject;
import org.mozilla.gecko.sync.NonObjectJSONException;
import org.mozilla.gecko.sync.crypto.CryptoException;
import org.mozilla.gecko.sync.crypto.CryptoInfo;
import org.mozilla.gecko.sync.crypto.KeyBundle;
import org.mozilla.gecko.sync.jpake.JPakeClient;
import org.mozilla.gecko.sync.jpake.stage.JPakeStage;

public class VerifyPairingStage
extends JPakeStage {
    @Override
    public void execute(JPakeClient jPakeClient) {
        boolean bl;
        ExtendedJSONObject extendedJSONObject;
        Logger.debug("SyncJPakeStage", "Verifying their key.");
        ExtendedJSONObject extendedJSONObject2 = jPakeClient.jIncoming;
        String string2 = (String)extendedJSONObject2.get("type");
        if (!string2.equals(jPakeClient.theirSignerId + "3")) {
            Logger.error("SyncJPakeStage", "Invalid round 3 message: " + extendedJSONObject2.toJSONString());
            jPakeClient.abort("jpake.error.wrongmessage");
            return;
        }
        try {
            extendedJSONObject = extendedJSONObject2.getObject("payload");
        }
        catch (NonObjectJSONException nonObjectJSONException) {
            Logger.error("SyncJPakeStage", "JSON exception.", nonObjectJSONException);
            jPakeClient.abort("jpake.error.invalid");
            return;
        }
        String string3 = (String)extendedJSONObject.get("ciphertext");
        String string4 = (String)extendedJSONObject.get("IV");
        try {
            bl = this.verifyCiphertext(string3, string4, jPakeClient.myKeyBundle);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.error("SyncJPakeStage", "Unsupported encoding.", unsupportedEncodingException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        catch (CryptoException cryptoException) {
            Logger.error("SyncJPakeStage", "Crypto exception.", cryptoException);
            jPakeClient.abort("jpake.error.internal");
            return;
        }
        if (!bl) {
            Logger.error("SyncJPakeStage", "Keys don't match.");
            jPakeClient.abort("jpake.error.keymismatch");
            return;
        }
        Logger.debug("SyncJPakeStage", "Keys verified successfully.");
        jPakeClient.paired = true;
        jPakeClient.onPaired();
    }

    public boolean verifyCiphertext(String string2, String string3, KeyBundle keyBundle) throws UnsupportedEncodingException, CryptoException {
        byte[] byArray = "0123456789ABCDEF".getBytes("UTF-8");
        CryptoInfo cryptoInfo = CryptoInfo.encrypt(byArray, Base64.decodeBase64((String)string3), keyBundle);
        String string4 = new String(Base64.encodeBase64((byte[])cryptoInfo.getMessage()), "UTF-8");
        return string4.equals(string2);
    }
}

