/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.tabs.TabHistoryPage;
import org.mozilla.gecko.util.GeckoRequest;
import org.mozilla.gecko.util.NativeJSObject;

public class TabHistoryController {
    private static final String LOGTAG = "TabHistoryController";
    private final OnShowTabHistory showTabHistoryListener;

    public TabHistoryController(OnShowTabHistory onShowTabHistory) {
        this.showTabHistoryListener = onShowTabHistory;
    }

    public boolean showTabHistory(Tab tab, HistoryAction historyAction) {
        int n = tab.getHistoryIndex();
        int n2 = tab.getHistorySize();
        switch (historyAction) {
            case BACK: {
                if (!tab.canDoBack()) {
                    return false;
                }
                return this.showHistory(Math.max(n - 50, 0), n, n);
            }
            case FORWARD: {
                if (!tab.canDoForward()) {
                    return false;
                }
                return this.showHistory(n, Math.min(n2 - 1, n + 50), n);
            }
            case ALL: {
                if (!tab.canDoForward() && !tab.canDoBack()) {
                    return false;
                }
                int n3 = n - 25;
                int n4 = n + 25;
                if (n3 < 0) {
                    n4 -= n3;
                }
                if (n4 > n2 - 1) {
                    n3 -= n4 - (n2 - 1);
                    n4 = n2 - 1;
                }
                n3 = Math.max(n3, 0);
                return this.showHistory(n3, n4, n);
            }
        }
        return false;
    }

    private boolean showHistory(int n, final int n2, int n3) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fromIndex", n);
            jSONObject.put("toIndex", n2);
            jSONObject.put("selIndex", n3);
        }
        catch (JSONException jSONException) {
            Log.e((String)LOGTAG, (String)"JSON error", (Throwable)jSONException);
        }
        GeckoAppShell.sendRequestToGecko(new GeckoRequest("Session:GetHistory", jSONObject){

            public void onResponse(NativeJSObject nativeJSObject) {
                NativeJSObject[] nativeJSObjectArray = nativeJSObject.getObjectArray("historyItems");
                ArrayList<TabHistoryPage> arrayList = new ArrayList<TabHistoryPage>(nativeJSObjectArray.length);
                for (NativeJSObject nativeJSObject2 : nativeJSObjectArray) {
                    String string2 = nativeJSObject2.getString("title");
                    String string3 = nativeJSObject2.getString("url");
                    boolean bl = nativeJSObject2.getBoolean("selected");
                    arrayList.add(new TabHistoryPage(string2, string3, bl));
                }
                TabHistoryController.this.showTabHistoryListener.onShowHistory(arrayList, n2);
            }
        });
        return true;
    }

    public static interface OnShowTabHistory {
        public void onShowHistory(List<TabHistoryPage> var1, int var2);
    }

    public static enum HistoryAction {
        ALL,
        BACK,
        FORWARD;

    }
}

