/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.BaseGeckoInterface;
import org.mozilla.gecko.ContextGetter;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAccessibility;
import org.mozilla.gecko.GeckoActivity;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.GeckoProfile;
import org.mozilla.gecko.GeckoThread;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.Tabs;
import org.mozilla.gecko.db.BrowserDB;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.mozglue.GeckoLoader;
import org.mozilla.gecko.util.Clipboard;
import org.mozilla.gecko.util.EventCallback;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.HardwareUtils;
import org.mozilla.gecko.util.NativeEventListener;
import org.mozilla.gecko.util.NativeJSObject;
import org.mozilla.gecko.util.ThreadUtils;

public class GeckoView
extends LayerView
implements ContextGetter {
    private static final String DEFAULT_SHARED_PREFERENCES_FILE = "GeckoView";
    private static final String LOGTAG = "GeckoView";
    private ChromeDelegate mChromeDelegate;
    private ContentDelegate mContentDelegate;
    private final GeckoEventListener mGeckoEventListener = new GeckoEventListener(){

        public void handleMessage(final String string2, final JSONObject jSONObject) {
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        int n;
                        if (string2.equals("Gecko:Ready")) {
                            GeckoView.this.handleReady(jSONObject);
                        } else if (string2.equals("Content:StateChange")) {
                            GeckoView.this.handleStateChange(jSONObject);
                        } else if (string2.equals("Content:LoadError")) {
                            GeckoView.this.handleLoadError(jSONObject);
                        } else if (string2.equals("Content:PageShow")) {
                            GeckoView.this.handlePageShow(jSONObject);
                        } else if (string2.equals("DOMTitleChanged")) {
                            GeckoView.this.handleTitleChanged(jSONObject);
                        } else if (string2.equals("Link:Favicon")) {
                            GeckoView.this.handleLinkFavicon(jSONObject);
                        } else if (string2.equals("Prompt:Show") || string2.equals("Prompt:ShowTop")) {
                            GeckoView.this.handlePrompt(jSONObject);
                        } else if (string2.equals("Accessibility:Event") && ((n = GeckoView.this.getImportantForAccessibility()) == 1 || n == 0)) {
                            GeckoAccessibility.sendAccessibilityEvent(jSONObject);
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)"GeckoView", (String)("handleMessage threw for " + string2), (Throwable)exception);
                    }
                }
            });
        }
    };
    private final NativeEventListener mNativeEventListener = new NativeEventListener(){

        public void handleMessage(String string2, NativeJSObject nativeJSObject, final EventCallback eventCallback) {
            try {
                if ("Accessibility:Ready".equals(string2)) {
                    GeckoAccessibility.updateAccessibilitySettings(GeckoView.this.getContext());
                } else if ("GeckoView:Message".equals(string2)) {
                    NativeJSObject nativeJSObject2 = nativeJSObject.optObject("data", null);
                    if (nativeJSObject2 == null) {
                        return;
                    }
                    final Bundle bundle = nativeJSObject2.toBundle();
                    ThreadUtils.postToUiThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GeckoView.this.handleScriptMessage(bundle, eventCallback);
                        }
                    });
                }
            }
            catch (Exception exception) {
                Log.w((String)"GeckoView", (String)("handleMessage threw for " + string2), (Throwable)exception);
            }
        }
    };

    public GeckoView(Context context) {
        super(context);
        this.init(context, null, true);
    }

    public GeckoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GeckoView);
        String string2 = typedArray.getString(R.styleable.GeckoView_url);
        boolean bl = typedArray.getBoolean(R.styleable.GeckoView_doinit, true);
        typedArray.recycle();
        this.init(context, string2, bl);
    }

    private void init(Context context, String string2, boolean bl) {
        Object object;
        if (!bl) {
            return;
        }
        boolean bl2 = false;
        try {
            bl2 = context instanceof GeckoActivity;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (!bl2) {
            if (context instanceof Activity && GeckoView.getGeckoInterface() == null) {
                GeckoView.setGeckoInterface(new BaseGeckoInterface(context));
            }
            Clipboard.init((Context)context);
            HardwareUtils.init((Context)context);
            GeckoLoader.loadMozGlue((Context)context);
            BrowserDB.setEnableContentProviders(false);
        }
        if (string2 != null) {
            GeckoThread.setUri(string2);
            GeckoThread.setAction("android.intent.action.VIEW");
            GeckoAppShell.sendEventToGecko(GeckoEvent.createURILoadEvent(string2));
        }
        GeckoAppShell.setContextGetter(this);
        if (context instanceof Activity) {
            object = Tabs.getInstance();
            ((Tabs)object).attachToContext(context);
        }
        EventDispatcher.getInstance().registerGeckoThreadListener(this.mGeckoEventListener, "Gecko:Ready", "Accessibility:Event", "Content:StateChange", "Content:LoadError", "Content:PageShow", "DOMTitleChanged", "Link:Favicon", "Prompt:Show", "Prompt:ShowTop");
        EventDispatcher.getInstance().registerGeckoThreadListener(this.mNativeEventListener, "Accessibility:Ready", "GeckoView:Message");
        this.initializeView(EventDispatcher.getInstance());
        if (GeckoThread.checkAndSetLaunchState(GeckoThread.LaunchState.Launching, GeckoThread.LaunchState.Launched)) {
            object = GeckoProfile.get(context).forceCreate();
            BrowserDB.initialize(((GeckoProfile)object).getName());
            GeckoAppShell.setLayerView(this);
            GeckoAppShell.sendEventToGecko(GeckoEvent.createObjectEvent(1, this.getLayerClientObject()));
            GeckoThread.createAndStart();
        } else if (GeckoThread.checkLaunchState(GeckoThread.LaunchState.GeckoRunning)) {
            this.connectToGecko();
        }
    }

    public Browser addBrowser(String string2) {
        Tab tab = Tabs.getInstance().loadUrl(string2, 1);
        if (tab != null) {
            return new Browser(tab.getId());
        }
        return null;
    }

    public void removeBrowser(Browser browser) {
        Tab tab = Tabs.getInstance().getTab(browser.getId());
        if (tab != null) {
            Tabs.getInstance().closeTab(tab);
        }
    }

    public void setCurrentBrowser(Browser browser) {
        Tab tab = Tabs.getInstance().getTab(browser.getId());
        if (tab != null) {
            Tabs.getInstance().selectTab(tab.getId());
        }
    }

    public Browser getCurrentBrowser() {
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            return new Browser(tab.getId());
        }
        return null;
    }

    public List<Browser> getBrowsers() {
        ArrayList<Browser> arrayList = new ArrayList<Browser>();
        Iterable<Tab> iterable = Tabs.getInstance().getTabsInOrder();
        for (Tab tab : iterable) {
            arrayList.add(new Browser(tab.getId()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void importScript(String string2) {
        if (string2.startsWith("resource://android/assets/")) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("GeckoView:ImportScript", string2));
            return;
        }
        throw new IllegalArgumentException("Must import script from 'resources://android/assets/' location.");
    }

    private void connectToGecko() {
        GeckoThread.setLaunchState(GeckoThread.LaunchState.GeckoRunning);
        Tab tab = Tabs.getInstance().getSelectedTab();
        if (tab != null) {
            Tabs.getInstance().notifyListeners(tab, Tabs.TabEvents.SELECTED);
        }
        this.geckoConnected();
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Viewport:Flush", null));
    }

    private void handleReady(JSONObject jSONObject) {
        this.connectToGecko();
        if (this.mChromeDelegate != null) {
            this.mChromeDelegate.onReady(this);
        }
    }

    private void handleStateChange(JSONObject jSONObject) throws JSONException {
        int n = jSONObject.getInt("state");
        if ((n & 0x40000) != 0) {
            if ((n & 1) != 0) {
                if (this.mContentDelegate != null) {
                    int n2 = jSONObject.getInt("tabID");
                    this.mContentDelegate.onPageStart(this, new Browser(n2), jSONObject.getString("uri"));
                }
            } else if ((n & 0x10) != 0 && this.mContentDelegate != null) {
                int n3 = jSONObject.getInt("tabID");
                this.mContentDelegate.onPageStop(this, new Browser(n3), jSONObject.getBoolean("success"));
            }
        }
    }

    private void handleLoadError(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onPageStop(this, new Browser(n), false);
        }
    }

    private void handlePageShow(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onPageShow(this, new Browser(n));
        }
    }

    private void handleTitleChanged(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onReceivedTitle(this, new Browser(n), jSONObject.getString("title"));
        }
    }

    private void handleLinkFavicon(JSONObject jSONObject) throws JSONException {
        if (this.mContentDelegate != null) {
            int n = jSONObject.getInt("tabID");
            this.mContentDelegate.onReceivedFavicon(this, new Browser(n), jSONObject.getString("href"), jSONObject.getInt("size"));
        }
    }

    private void handlePrompt(JSONObject jSONObject) throws JSONException {
        if (this.mChromeDelegate != null) {
            String string2 = jSONObject.optString("hint");
            if ("alert".equals(string2)) {
                String string3 = jSONObject.optString("text");
                this.mChromeDelegate.onAlert(this, null, string3, new PromptResult(jSONObject));
            } else if ("confirm".equals(string2)) {
                String string4 = jSONObject.optString("text");
                this.mChromeDelegate.onConfirm(this, null, string4, new PromptResult(jSONObject));
            } else if ("prompt".equals(string2)) {
                String string5 = jSONObject.optString("text");
                String string6 = jSONObject.optString("textbox0");
                this.mChromeDelegate.onPrompt(this, null, string5, string6, new PromptResult(jSONObject));
            } else if ("remotedebug".equals(string2)) {
                this.mChromeDelegate.onDebugRequest(this, new PromptResult(jSONObject));
            }
        }
    }

    private void handleScriptMessage(Bundle bundle, EventCallback eventCallback) {
        if (this.mChromeDelegate != null) {
            MessageResult messageResult = null;
            if (eventCallback != null) {
                messageResult = new MessageResult(eventCallback);
            }
            this.mChromeDelegate.onScriptMessage(this, bundle, messageResult);
        }
    }

    public void setChromeDelegate(ChromeDelegate chromeDelegate) {
        this.mChromeDelegate = chromeDelegate;
    }

    public void setContentDelegate(ContentDelegate contentDelegate) {
        this.mContentDelegate = contentDelegate;
    }

    public static void setGeckoInterface(BaseGeckoInterface baseGeckoInterface) {
        GeckoAppShell.setGeckoInterface(baseGeckoInterface);
    }

    public static GeckoAppShell.GeckoInterface getGeckoInterface() {
        return GeckoAppShell.getGeckoInterface();
    }

    protected String getSharedPreferencesFile() {
        return "GeckoView";
    }

    @Override
    public SharedPreferences getSharedPreferences() {
        return this.getContext().getSharedPreferences(this.getSharedPreferencesFile(), 0);
    }

    public static interface ContentDelegate {
        public void onPageStart(GeckoView var1, Browser var2, String var3);

        public void onPageStop(GeckoView var1, Browser var2, boolean var3);

        public void onPageShow(GeckoView var1, Browser var2);

        public void onReceivedTitle(GeckoView var1, Browser var2, String var3);

        public void onReceivedFavicon(GeckoView var1, Browser var2, String var3, int var4);
    }

    public static interface ChromeDelegate {
        public void onReady(GeckoView var1);

        public void onAlert(GeckoView var1, Browser var2, String var3, PromptResult var4);

        public void onConfirm(GeckoView var1, Browser var2, String var3, PromptResult var4);

        public void onPrompt(GeckoView var1, Browser var2, String var3, String var4, PromptResult var5);

        public void onDebugRequest(GeckoView var1, PromptResult var2);

        public void onScriptMessage(GeckoView var1, Bundle var2, MessageResult var3);
    }

    public class MessageResult {
        private final EventCallback mCallback;

        public MessageResult(EventCallback eventCallback) {
            if (eventCallback == null) {
                throw new IllegalArgumentException("EventCallback should not be null.");
            }
            this.mCallback = eventCallback;
        }

        private JSONObject bundleToJSON(Bundle bundle) {
            JSONObject jSONObject = new JSONObject();
            if (bundle == null) {
                return jSONObject;
            }
            Set set = bundle.keySet();
            for (String string2 : set) {
                try {
                    jSONObject.put(string2, bundle.get(string2));
                }
                catch (JSONException jSONException) {}
            }
            return jSONObject;
        }

        public void success(Bundle bundle) {
            this.mCallback.sendSuccess((Object)this.bundleToJSON(bundle));
        }

        public void failure(Bundle bundle) {
            this.mCallback.sendError((Object)this.bundleToJSON(bundle));
        }
    }

    public class PromptResult {
        private final int RESULT_OK = 0;
        private final int RESULT_CANCEL = 1;
        private final JSONObject mMessage;

        public PromptResult(JSONObject jSONObject) {
            this.mMessage = jSONObject;
        }

        private JSONObject makeResult(int n) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("button", n);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jSONObject;
        }

        public void confirm() {
            JSONObject jSONObject = this.makeResult(0);
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }

        public void confirmWithValue(String string2) {
            JSONObject jSONObject = this.makeResult(0);
            try {
                jSONObject.put("textbox0", (Object)string2);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }

        public void cancel() {
            JSONObject jSONObject = this.makeResult(1);
            EventDispatcher.sendResponse(this.mMessage, jSONObject);
        }
    }

    public class Browser {
        private final int mId;

        private Browser(int n) {
            this.mId = n;
        }

        private int getId() {
            return this.mId;
        }

        public void loadUrl(String string2) {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("url", (Object)string2);
                jSONObject.put("parentId", -1);
                jSONObject.put("newTab", false);
                jSONObject.put("tabID", this.mId);
            }
            catch (Exception exception) {
                Log.w((String)"GeckoView", (String)"Error building JSON arguments for loadUrl.", (Throwable)exception);
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Tab:Load", jSONObject.toString()));
        }

        public void reload() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                tab.doReload();
            }
        }

        public void stop() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                tab.doStop();
            }
        }

        public boolean canGoBack() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                return tab.canDoBack();
            }
            return false;
        }

        public void goBack() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                tab.doBack();
            }
        }

        public boolean canGoForward() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                return tab.canDoForward();
            }
            return false;
        }

        public void goForward() {
            Tab tab = Tabs.getInstance().getTab(this.mId);
            if (tab != null) {
                tab.doForward();
            }
        }
    }
}

