/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.util.AttributeSet;
import android.widget.TextView;
import org.mozilla.gecko.GeckoApplication;
import org.mozilla.gecko.LightweightTheme;
import org.mozilla.gecko.R;

public class ThemedTextView
extends TextView
implements LightweightTheme.OnChangeListener {
    private LightweightTheme mTheme;
    private static final int[] STATE_PRIVATE_MODE = new int[]{R.attr.state_private};
    private static final int[] STATE_LIGHT = new int[]{R.attr.state_light};
    private static final int[] STATE_DARK = new int[]{R.attr.state_dark};
    protected static final int[] PRIVATE_PRESSED_STATE_SET = new int[]{R.attr.state_private, 16842919};
    protected static final int[] PRIVATE_FOCUSED_STATE_SET = new int[]{R.attr.state_private, 16842908};
    protected static final int[] PRIVATE_STATE_SET = new int[]{R.attr.state_private};
    private boolean mIsPrivate;
    private boolean mIsLight;
    private boolean mIsDark;
    private boolean mAutoUpdateTheme;

    public ThemedTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.initialize(context, attributeSet);
    }

    public ThemedTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initialize(context, attributeSet);
    }

    private void initialize(Context context, AttributeSet attributeSet) {
        this.mTheme = ((GeckoApplication)context.getApplicationContext()).getLightweightTheme();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.LightweightTheme);
        this.mAutoUpdateTheme = this.mTheme != null && typedArray.getBoolean(R.styleable.LightweightTheme_autoUpdateTheme, true);
        typedArray.recycle();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mAutoUpdateTheme) {
            this.mTheme.addListener(this);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAutoUpdateTheme) {
            this.mTheme.removeListener(this);
        }
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mIsPrivate) {
            ThemedTextView.mergeDrawableStates((int[])nArray, (int[])STATE_PRIVATE_MODE);
        } else if (this.mIsLight) {
            ThemedTextView.mergeDrawableStates((int[])nArray, (int[])STATE_LIGHT);
        } else if (this.mIsDark) {
            ThemedTextView.mergeDrawableStates((int[])nArray, (int[])STATE_DARK);
        }
        return nArray;
    }

    @Override
    public void onLightweightThemeChanged() {
        if (this.mAutoUpdateTheme && this.mTheme.isEnabled()) {
            this.setTheme(this.mTheme.isLightTheme());
        }
    }

    @Override
    public void onLightweightThemeReset() {
        if (this.mAutoUpdateTheme) {
            this.resetTheme();
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.onLightweightThemeChanged();
    }

    public boolean isPrivateMode() {
        return this.mIsPrivate;
    }

    public void setPrivateMode(boolean bl) {
        if (this.mIsPrivate != bl) {
            this.mIsPrivate = bl;
            this.refreshDrawableState();
        }
    }

    public void setTheme(boolean bl) {
        if (bl && this.mIsLight != bl || !bl && this.mIsDark == bl) {
            if (bl) {
                this.mIsLight = true;
                this.mIsDark = false;
            } else {
                this.mIsLight = false;
                this.mIsDark = true;
            }
            this.refreshDrawableState();
        }
    }

    public void resetTheme() {
        if (this.mIsLight || this.mIsDark) {
            this.mIsLight = false;
            this.mIsDark = false;
            this.refreshDrawableState();
        }
    }

    public void setAutoUpdateTheme(boolean bl) {
        if (this.mTheme == null) {
            return;
        }
        if (this.mAutoUpdateTheme != bl) {
            this.mAutoUpdateTheme = bl;
            if (this.mAutoUpdateTheme) {
                this.mTheme.addListener(this);
            } else {
                this.mTheme.removeListener(this);
            }
        }
    }

    public ColorDrawable getColorDrawable(int n) {
        return new ColorDrawable(this.getResources().getColor(n));
    }
}

