/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.AlertDialog;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.OperationApplicationException;
import android.database.Cursor;
import android.net.Uri;
import android.os.RemoteException;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;

public class ContactService
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoContactService";
    private static final boolean DEBUG = false;
    private static final int GROUP_ACCOUNT_NAME = 0;
    private static final int GROUP_ACCOUNT_TYPE = 1;
    private static final int GROUP_ID = 2;
    private static final int GROUP_TITLE = 3;
    private static final int GROUP_AUTO_ADD = 4;
    private static final String CARRIER_COLUMN = "data5";
    private static final String CUSTOM_DATA_COLUMN = "data1";
    private static final String PRE_HONEYCOMB_DEFAULT_GROUP = "System Group: My Contacts";
    private static final String MIMETYPE_ADDITIONAL_NAME = "org.mozilla.gecko/additional_name";
    private static final String MIMETYPE_SEX = "org.mozilla.gecko/sex";
    private static final String MIMETYPE_GENDER_IDENTITY = "org.mozilla.gecko/gender_identity";
    private static final String MIMETYPE_KEY = "org.mozilla.gecko/key";
    private static final String MIMETYPE_MOZILLA_CONTACTS_FLAG = "org.mozilla.gecko/contact_flag";
    private final EventDispatcher mEventDispatcher;
    private String mAccountName;
    private String mAccountType;
    private String mGroupTitle;
    private long mGroupId;
    private boolean mGotDeviceAccount;
    private HashMap<String, String> mColumnNameConstantsMap;
    private HashMap<String, String> mMimeTypeConstantsMap;
    private HashMap<String, Integer> mAddressTypesMap;
    private HashMap<String, Integer> mPhoneTypesMap;
    private HashMap<String, Integer> mEmailTypesMap;
    private HashMap<String, Integer> mWebsiteTypesMap;
    private HashMap<String, Integer> mImTypesMap;
    private final ContentResolver mContentResolver;
    private final GeckoApp mActivity;

    ContactService(EventDispatcher eventDispatcher, GeckoApp geckoApp) {
        this.mEventDispatcher = eventDispatcher;
        this.mActivity = geckoApp;
        this.mContentResolver = this.mActivity.getContentResolver();
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "Android:Contacts:Clear", "Android:Contacts:Find", "Android:Contacts:GetAll", "Android:Contacts:GetCount", "Android:Contact:Remove", "Android:Contact:Save");
    }

    public void destroy() {
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "Android:Contacts:Clear", "Android:Contacts:Find", "Android:Contacts:GetAll", "Android:Contacts:GetCount", "Android:Contact:Remove", "Android:Contact:Save");
    }

    public void handleMessage(final String string2, final JSONObject jSONObject) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        JSONObject jSONObject3 = jSONObject.getJSONObject("data");
                        String string22 = jSONObject3.getString("requestID");
                        JSONObject jSONObject2 = jSONObject3.optJSONObject("options");
                        if ("Android:Contacts:Find".equals(string2)) {
                            ContactService.this.findContacts(jSONObject2, string22);
                            break block8;
                        }
                        if ("Android:Contacts:GetAll".equals(string2)) {
                            ContactService.this.getAllContacts(jSONObject3, string22);
                            break block8;
                        }
                        if ("Android:Contacts:Clear".equals(string2)) {
                            ContactService.this.clearAllContacts(jSONObject2, string22);
                            break block8;
                        }
                        if ("Android:Contact:Save".equals(string2)) {
                            ContactService.this.saveContact(jSONObject2, string22);
                            break block8;
                        }
                        if ("Android:Contact:Remove".equals(string2)) {
                            ContactService.this.removeContact(jSONObject2, string22);
                            break block8;
                        }
                        if ("Android:Contacts:GetCount".equals(string2)) {
                            ContactService.this.getContactsCount(string22);
                            break block8;
                        }
                        throw new IllegalArgumentException("Unexpected event: " + string2);
                    }
                    catch (JSONException jSONException) {
                        throw new IllegalArgumentException("Message: " + (Object)((Object)jSONException));
                    }
                }
            }
        };
        if (!this.mGotDeviceAccount) {
            this.getDeviceAccount(runnable);
        } else {
            runnable.run();
        }
    }

    private void findContacts(JSONObject jSONObject, String string2) {
        long[] lArray = this.findContactsRawIds(jSONObject);
        Log.i((String)LOGTAG, (String)("Got " + (lArray != null ? Integer.valueOf(lArray.length) : "null") + " raw contact IDs"));
        String[] stringArray = ContactService.getSortOptionsFromJSON(jSONObject);
        if (lArray == null || stringArray == null) {
            this.sendCallbackToJavascript("Android:Contacts:Find:Return:KO", string2, null, null);
        } else {
            this.sendCallbackToJavascript("Android:Contacts:Find:Return:OK", string2, new String[]{"contacts"}, new Object[]{this.getContactsAsJSONArray(lArray, stringArray[0], stringArray[1])});
        }
    }

    private void getAllContacts(JSONObject jSONObject, String string2) {
        long[] lArray = this.getAllRawContactIds();
        Log.i((String)LOGTAG, (String)("Got " + lArray.length + " raw contact IDs"));
        String[] stringArray = ContactService.getSortOptionsFromJSON(jSONObject);
        if (lArray == null || stringArray == null) {
            return;
        }
        this.sendCallbackToJavascript("Android:Contacts:GetAll:Next", string2, new String[]{"contacts"}, new Object[]{this.getContactsAsJSONArray(lArray, stringArray[0], stringArray[1])});
    }

    private static String[] getSortOptionsFromJSON(JSONObject jSONObject) {
        String string2 = null;
        String string3 = null;
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("findOptions");
            string2 = jSONObject2.optString("sortBy").toLowerCase();
            string3 = jSONObject2.optString("sortOrder").toLowerCase();
            if ("".equals(string2)) {
                string2 = null;
            }
            if ("".equals(string3)) {
                string3 = "ascending";
            }
            if (string2 != null && !"familyname".equals(string2) && !"givenname".equals(string2) || !"ascending".equals(string3) && !"descending".equals(string3)) {
                return null;
            }
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
        return new String[]{string2, string3};
    }

    /*
     * Loose catch block
     */
    private long[] findContactsRawIds(JSONObject jSONObject) {
        ArrayList<Long> arrayList;
        block34: {
            arrayList = new ArrayList<Long>();
            try (Cursor cursor = null;){
                Object object;
                int n;
                Object object2;
                String[] stringArray;
                JSONObject jSONObject2 = jSONObject.getJSONObject("findOptions");
                String string2 = jSONObject2.optString("filterValue");
                JSONArray jSONArray = jSONObject2.optJSONArray("filterBy");
                String string3 = jSONObject2.optString("filterOp");
                int n2 = jSONObject2.getInt("filterLimit");
                int n3 = jSONObject2.getInt("substringMatching");
                if ("".equals(string2) || "".equals(string3)) {
                    long[] lArray = this.getAllRawContactIds();
                    if (n2 > 0 && lArray.length > n2) {
                        long[] lArray2 = new long[n2];
                        System.arraycopy(lArray, 0, lArray2, 0, n2);
                        long[] lArray3 = lArray2;
                        return lArray3;
                    }
                    long[] lArray4 = lArray;
                    return lArray4;
                }
                if ("match".equals(string3)) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        if ("tel".equals(jSONArray.getString(i))) continue;
                        Log.w((String)LOGTAG, (String)"\"match\" filterBy option is only valid for the \"tel\" field");
                        long[] lArray = null;
                        return lArray;
                    }
                }
                String string4 = null;
                String[] stringArray2 = null;
                if (this.mAccountName != null) {
                    string4 = "account_name=? AND account_type=?";
                    stringArray2 = new String[]{this.mAccountName, this.mAccountType};
                }
                if (jSONArray == null || jSONArray.length() == 0) {
                    stringArray = null;
                } else {
                    object2 = new ArrayList<String>();
                    object2.add("raw_contact_id");
                    object2.add("mimetype");
                    for (n = 0; n < jSONArray.length(); ++n) {
                        String string5 = jSONArray.getString(n);
                        if ("id".equals(string5)) {
                            try {
                                object = new long[]{Long.valueOf(string2)};
                                return object;
                            }
                            catch (NumberFormatException numberFormatException) {
                                long[] lArray;
                                block33: {
                                    lArray = null;
                                    if (cursor == null) break block33;
                                    cursor.close();
                                }
                                return lArray;
                            }
                        }
                        object = this.getColumnNameConstant(string5);
                        if (object != null) {
                            object2.add(object);
                            continue;
                        }
                        Log.w((String)LOGTAG, (String)("Unknown filter option: " + string5));
                    }
                    stringArray = object2.toArray(new String[object2.size()]);
                }
                cursor = this.mContentResolver.query(ContactsContract.Data.CONTENT_URI, stringArray, string4, stringArray2, null);
                if (cursor.getCount() <= 0) break block34;
                cursor.moveToPosition(-1);
                while (cursor.moveToNext()) {
                    object2 = cursor.getString(cursor.getColumnIndex("mimetype"));
                    if (jSONArray != null && jSONArray.length() > 0) {
                        for (n = 0; n < jSONArray.length(); ++n) {
                            boolean bl;
                            String string6;
                            block35: {
                                String string7 = jSONArray.getString(n);
                                if (!((String)object2).equals(this.getMimeTypeOfField(string7))) continue;
                                object = this.getColumnNameConstant(string7);
                                int n4 = cursor.getColumnIndex((String)object);
                                string6 = cursor.getString(n4);
                                bl = false;
                                if ("vnd.android.cursor.item/phone_v2".equals(object2)) {
                                    bl = true;
                                } else {
                                    if ("vnd.android.cursor.item/group_membership".equals(object2)) {
                                        try {
                                            string6 = this.getGroupName(Long.valueOf(string6));
                                            break block35;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            Log.e((String)LOGTAG, (String)"Number Format Exception", (Throwable)numberFormatException);
                                            continue;
                                        }
                                    }
                                    if (string6 == null) continue;
                                }
                            }
                            if (!this.isFindMatch(string3, string2, string6, bl, n3)) continue;
                            ContactService.addMatchToList(cursor, arrayList);
                            break;
                        }
                    } else {
                        n = cursor.getColumnCount();
                        for (int i = 0; i < n; ++i) {
                            object = cursor.getString(i);
                            if (object == null || !this.isFindMatch(string3, string2, (String)object, false, n3)) continue;
                            ContactService.addMatchToList(cursor, arrayList);
                            break;
                        }
                    }
                    if (n2 <= 0 || n2 > arrayList.size()) continue;
                    break block34;
                }
                {
                    break block34;
                    catch (JSONException jSONException) {
                        throw new IllegalArgumentException(jSONException);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        return ContactService.convertLongListToArray(arrayList);
    }

    private boolean isFindMatch(String string2, String string3, String string4, boolean bl, int n) {
        Log.i((String)LOGTAG, (String)("matching: filterOp: " + string2));
        Log.i((String)LOGTAG, (String)("matching: isPhone: " + bl));
        Log.i((String)LOGTAG, (String)("matching: substringMatching: " + n));
        if (string4 == null) {
            return false;
        }
        string3 = string3.toLowerCase();
        string4 = string4.toLowerCase();
        switch (string2) {
            case "match": {
                if (n > 0) {
                    string4 = ContactService.substringStartFromEnd(ContactService.cleanPhoneNumber(string4), n);
                    string3 = ContactService.substringStartFromEnd(ContactService.cleanPhoneNumber(string3), n);
                    return string4.startsWith(string3);
                }
                return string4.equals(string3);
            }
            case "equals": {
                if (bl) {
                    return PhoneNumberUtils.compare((String)string3, (String)string4);
                }
                return string4.equals(string3);
            }
            case "contains": {
                if (bl) {
                    string3 = ContactService.cleanPhoneNumber(string3);
                    string4 = ContactService.cleanPhoneNumber(string4);
                }
                return string4.contains(string3);
            }
            case "startsWith": {
                if (bl) {
                    String string5 = ContactService.cleanPhoneNumber(string4);
                    if (n > 0) {
                        string5 = ContactService.substringStartFromEnd(string5, n);
                    }
                    if (string5.startsWith(string3)) {
                        return true;
                    }
                }
                return string4.startsWith(string3);
            }
        }
        return false;
    }

    private static String cleanPhoneNumber(String string2) {
        return string2.replace(" ", "").replace("(", "").replace(")", "").replace("-", "");
    }

    private static String substringStartFromEnd(String string2, int n) {
        int n2 = string2.length();
        if (n2 < n) {
            return string2;
        }
        return string2.substring(n2 - n);
    }

    private static void addMatchToList(Cursor cursor, List<Long> list) {
        long l = cursor.getLong(cursor.getColumnIndex("raw_contact_id"));
        if (!list.contains(l)) {
            list.add(l);
        }
    }

    private JSONArray getContactsAsJSONArray(long[] lArray, String string2, String string3) {
        int n;
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        JSONArray jSONArray = new JSONArray();
        for (n = 0; n < lArray.length; ++n) {
            arrayList.add(this.getContactAsJSONObject(lArray[n]));
        }
        if (string2 != null) {
            Collections.sort(arrayList, new ContactsComparator(string2, string3));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jSONArray.put(arrayList.get(n));
        }
        return jSONArray;
    }

    private JSONObject getContactAsJSONObject(long l) {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = new JSONArray();
        JSONArray jSONArray4 = new JSONArray();
        JSONArray jSONArray5 = new JSONArray();
        JSONArray jSONArray6 = new JSONArray();
        JSONArray jSONArray7 = new JSONArray();
        JSONArray jSONArray8 = new JSONArray();
        JSONArray jSONArray9 = new JSONArray();
        JSONArray jSONArray10 = new JSONArray();
        JSONArray jSONArray11 = new JSONArray();
        JSONArray jSONArray12 = new JSONArray();
        JSONArray jSONArray13 = new JSONArray();
        JSONArray jSONArray14 = new JSONArray();
        JSONArray jSONArray15 = new JSONArray();
        JSONArray jSONArray16 = new JSONArray();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        JSONArray jSONArray17 = new JSONArray();
        String[] stringArray = this.getAllColumns();
        Uri uri = ContentUris.withAppendedId((Uri)ContactsContract.RawContacts.CONTENT_URI, (long)l);
        Uri uri2 = Uri.withAppendedPath((Uri)uri, (String)"entity");
        Cursor cursor = this.mContentResolver.query(uri2, stringArray, null, null, null);
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            String string6 = cursor.getString(cursor.getColumnIndex("mimetype"));
            try {
                String string7;
                String string8;
                if ("vnd.android.cursor.item/name".equals(string6)) {
                    String string9 = cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
                    string8 = cursor.getString(cursor.getColumnIndex("data2"));
                    string7 = cursor.getString(cursor.getColumnIndex("data3"));
                    String string10 = cursor.getString(cursor.getColumnIndex("data4"));
                    String string11 = cursor.getString(cursor.getColumnIndex("data6"));
                    if (string9 != null) {
                        jSONArray.put((Object)string9);
                    }
                    if (string8 != null) {
                        jSONArray2.put((Object)string8);
                    }
                    if (string7 != null) {
                        jSONArray3.put((Object)string7);
                    }
                    if (string10 != null) {
                        jSONArray4.put((Object)string10);
                    }
                    if (string11 == null) continue;
                    jSONArray5.put((Object)string11);
                    continue;
                }
                if (MIMETYPE_ADDITIONAL_NAME.equals(string6)) {
                    jSONArray6.put((Object)cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN)));
                    continue;
                }
                if ("vnd.android.cursor.item/nickname".equals(string6)) {
                    jSONArray7.put((Object)cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN)));
                    continue;
                }
                if ("vnd.android.cursor.item/postal-address_v2".equals(string6)) {
                    this.initAddressTypesMap();
                    this.getAddressDataAsJSONObject(cursor, jSONArray8);
                    continue;
                }
                if ("vnd.android.cursor.item/phone_v2".equals(string6)) {
                    this.initPhoneTypesMap();
                    this.getPhoneDataAsJSONObject(cursor, jSONArray9);
                    continue;
                }
                if ("vnd.android.cursor.item/email_v2".equals(string6)) {
                    this.initEmailTypesMap();
                    this.getGenericDataAsJSONObject(cursor, jSONArray10, CUSTOM_DATA_COLUMN, "data2", "data3", this.mEmailTypesMap);
                    continue;
                }
                if ("vnd.android.cursor.item/organization".equals(string6)) {
                    this.getOrganizationDataAsJSONObject(cursor, jSONArray11, jSONArray12);
                    continue;
                }
                if ("vnd.android.cursor.item/note".equals(string6)) {
                    jSONArray13.put((Object)cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN)));
                    continue;
                }
                if ("vnd.android.cursor.item/website".equals(string6)) {
                    this.initWebsiteTypesMap();
                    this.getGenericDataAsJSONObject(cursor, jSONArray14, CUSTOM_DATA_COLUMN, "data2", "data3", this.mWebsiteTypesMap);
                    continue;
                }
                if ("vnd.android.cursor.item/im".equals(string6)) {
                    this.initImTypesMap();
                    this.getGenericDataAsJSONObject(cursor, jSONArray15, CUSTOM_DATA_COLUMN, "data2", "data3", this.mImTypesMap);
                    continue;
                }
                if ("vnd.android.cursor.item/group_membership".equals(string6)) {
                    long l2 = cursor.getLong(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
                    string7 = this.getGroupName(l2);
                    if (ContactService.doesJSONArrayContainString(jSONArray16, string7)) continue;
                    jSONArray16.put((Object)string7);
                    continue;
                }
                if ("vnd.android.cursor.item/contact_event".equals(string6)) {
                    int n = cursor.getInt(cursor.getColumnIndex("data2"));
                    string8 = cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
                    string8 = string8 + "T00:00:00";
                    switch (n) {
                        case 3: {
                            string2 = string8;
                            break;
                        }
                        case 1: {
                            string3 = string8;
                        }
                    }
                    continue;
                }
                if (MIMETYPE_SEX.equals(string6)) {
                    string4 = cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
                    continue;
                }
                if (MIMETYPE_GENDER_IDENTITY.equals(string6)) {
                    string5 = cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
                    continue;
                }
                if (!MIMETYPE_KEY.equals(string6)) continue;
                jSONArray17.put((Object)cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN)));
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException);
            }
        }
        cursor.close();
        try {
            jSONObject2.put("name", (Object)jSONArray);
            jSONObject2.put("givenName", (Object)jSONArray2);
            jSONObject2.put("familyName", (Object)jSONArray3);
            jSONObject2.put("honorificPrefix", (Object)jSONArray4);
            jSONObject2.put("honorificSuffix", (Object)jSONArray5);
            jSONObject2.put("additionalName", (Object)jSONArray6);
            jSONObject2.put("nickname", (Object)jSONArray7);
            jSONObject2.put("adr", (Object)jSONArray8);
            jSONObject2.put("tel", (Object)jSONArray9);
            jSONObject2.put("email", (Object)jSONArray10);
            jSONObject2.put("org", (Object)jSONArray11);
            jSONObject2.put("jobTitle", (Object)jSONArray12);
            jSONObject2.put("note", (Object)jSONArray13);
            jSONObject2.put("url", (Object)jSONArray14);
            jSONObject2.put("impp", (Object)jSONArray15);
            jSONObject2.put("category", (Object)jSONArray16);
            jSONObject2.put("key", (Object)jSONArray17);
            ContactService.putPossibleNullValueInJSONObject("bday", string2, jSONObject2);
            ContactService.putPossibleNullValueInJSONObject("anniversary", string3, jSONObject2);
            ContactService.putPossibleNullValueInJSONObject("sex", string4, jSONObject2);
            ContactService.putPossibleNullValueInJSONObject("genderIdentity", string5, jSONObject2);
            jSONObject.put("id", (Object)String.valueOf(l));
            jSONObject.put("updated", null);
            jSONObject.put("published", null);
            jSONObject.put("properties", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
        return jSONObject;
    }

    private boolean bool(int n) {
        return n != 0;
    }

    private void getGenericDataAsJSONObject(Cursor cursor, JSONArray jSONArray, String string2, String string3, String string4, HashMap<String, Integer> hashMap) throws JSONException {
        JSONObject jSONObject;
        String string5 = cursor.getString(cursor.getColumnIndex(string2));
        int n = cursor.getInt(cursor.getColumnIndex(string3));
        String string6 = n == 0 ? cursor.getString(cursor.getColumnIndex(string4)) : ContactService.getKeyFromMapValue(hashMap, n);
        boolean bl = false;
        if (string6 != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONObject = jSONArray.getJSONObject(i);
                if (!string5.equals(jSONObject.getString("value"))) continue;
                bl = true;
                JSONArray jSONArray2 = jSONObject.getJSONArray("type");
                if (ContactService.doesJSONArrayContainString(jSONArray2, string6)) continue;
                jSONArray2.put((Object)string6);
                break;
            }
        }
        if (!bl) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject = new JSONArray();
            jSONObject2.put("value", (Object)string5);
            jSONObject.put((Object)string6);
            jSONObject2.put("type", (Object)jSONObject);
            jSONObject2.put("pref", this.bool(cursor.getInt(cursor.getColumnIndex("is_super_primary"))));
            jSONArray.put((Object)jSONObject2);
        }
    }

    private void getPhoneDataAsJSONObject(Cursor cursor, JSONArray jSONArray) throws JSONException {
        JSONObject jSONObject;
        String string2 = cursor.getString(cursor.getColumnIndex(CUSTOM_DATA_COLUMN));
        int n = cursor.getInt(cursor.getColumnIndex("data2"));
        String string3 = n == 0 ? cursor.getString(cursor.getColumnIndex("data3")) : ContactService.getKeyFromMapValue(this.mPhoneTypesMap, n);
        boolean bl = false;
        if (string3 != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONObject = jSONArray.getJSONObject(i);
                if (!string2.equals(jSONObject.getString("value"))) continue;
                bl = true;
                JSONArray jSONArray2 = jSONObject.getJSONArray("type");
                if (ContactService.doesJSONArrayContainString(jSONArray2, string3)) continue;
                jSONArray2.put((Object)string3);
                break;
            }
        }
        if (!bl) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject = new JSONArray();
            jSONObject2.put("value", (Object)string2);
            jSONObject2.put("type", (Object)string3);
            jSONObject.put((Object)string3);
            jSONObject2.put("type", (Object)jSONObject);
            jSONObject2.put("carrier", (Object)cursor.getString(cursor.getColumnIndex(CARRIER_COLUMN)));
            jSONObject2.put("pref", this.bool(cursor.getInt(cursor.getColumnIndex("is_super_primary"))));
            jSONArray.put((Object)jSONObject2);
        }
    }

    private void getAddressDataAsJSONObject(Cursor cursor, JSONArray jSONArray) throws JSONException {
        JSONObject jSONObject;
        String string2 = cursor.getString(cursor.getColumnIndex("data4"));
        String string3 = cursor.getString(cursor.getColumnIndex("data7"));
        String string4 = cursor.getString(cursor.getColumnIndex("data8"));
        String string5 = cursor.getString(cursor.getColumnIndex("data9"));
        String string6 = cursor.getString(cursor.getColumnIndex("data10"));
        int n = cursor.getInt(cursor.getColumnIndex("data2"));
        String string7 = n == 0 ? cursor.getString(cursor.getColumnIndex("data3")) : ContactService.getKeyFromMapValue(this.mAddressTypesMap, n);
        boolean bl = false;
        if (string7 != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                jSONObject = jSONArray.getJSONObject(i);
                if (!string2.equals(jSONObject.getString("streetAddress")) || !string3.equals(jSONObject.getString("locality")) || !string4.equals(jSONObject.getString("region")) || !string6.equals(jSONObject.getString("countryName")) || !string5.equals(jSONObject.getString("postalCode"))) continue;
                bl = true;
                JSONArray jSONArray2 = jSONObject.getJSONArray("type");
                if (ContactService.doesJSONArrayContainString(jSONArray2, string7)) continue;
                jSONArray2.put((Object)string7);
                break;
            }
        }
        if (!bl) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject = new JSONArray();
            jSONObject2.put("streetAddress", (Object)string2);
            jSONObject2.put("locality", (Object)string3);
            jSONObject2.put("region", (Object)string4);
            jSONObject2.put("countryName", (Object)string6);
            jSONObject2.put("postalCode", (Object)string5);
            jSONObject.put((Object)string7);
            jSONObject2.put("type", (Object)jSONObject);
            jSONObject2.put("pref", this.bool(cursor.getInt(cursor.getColumnIndex("is_super_primary"))));
            jSONArray.put((Object)jSONObject2);
        }
    }

    private void getOrganizationDataAsJSONObject(Cursor cursor, JSONArray jSONArray, JSONArray jSONArray2) throws JSONException {
        int n = cursor.getColumnIndex(CUSTOM_DATA_COLUMN);
        int n2 = cursor.getColumnIndex("data4");
        if (!cursor.isNull(n)) {
            jSONArray.put((Object)cursor.getString(n));
        }
        if (!cursor.isNull(n2)) {
            jSONArray2.put((Object)cursor.getString(n2));
        }
    }

    private void clearAllContacts(JSONObject jSONObject, String string2) {
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>();
        ContentProviderOperation.Builder builder = ContentProviderOperation.newDelete((Uri)ContactsContract.RawContacts.CONTENT_URI);
        if (this.mAccountName != null) {
            builder.withSelection("account_name=?", new String[]{this.mAccountName}).withSelection("account_type=?", new String[]{this.mAccountType});
        }
        arrayList.add(builder.build());
        String string3 = "KO";
        if (this.applyBatch(arrayList) != null) {
            string3 = "OK";
        }
        Log.i((String)LOGTAG, (String)("Sending return status: " + string3));
        this.sendCallbackToJavascript("Android:Contacts:Clear:Return:" + string3, string2, new String[]{"contactID"}, new Object[]{"undefined"});
    }

    private boolean deleteContact(String string2) {
        ContentProviderOperation contentProviderOperation = ContentProviderOperation.newDelete((Uri)ContactsContract.RawContacts.CONTENT_URI).withSelection("_id=?", new String[]{string2}).build();
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>();
        arrayList.add(contentProviderOperation);
        return ContactService.checkForPositiveCountInResults(this.applyBatch(arrayList));
    }

    private void removeContact(JSONObject jSONObject, String string2) {
        String string3;
        try {
            string3 = jSONObject.getString("id");
            Log.i((String)LOGTAG, (String)("Removing contact with ID: " + string3));
        }
        catch (JSONException jSONException) {
            this.sendCallbackToJavascript("Android:Contact:Remove:Return:KO", string2, null, null);
            return;
        }
        String string4 = "KO";
        if (this.deleteContact(string3)) {
            string4 = "OK";
        }
        this.sendCallbackToJavascript("Android:Contact:Remove:Return:" + string4, string2, new String[]{"contactID"}, new Object[]{string3});
    }

    private void saveContact(JSONObject jSONObject, String string2) {
        try {
            String string3 = jSONObject.getString("reason");
            JSONObject jSONObject2 = jSONObject.getJSONObject("contact");
            JSONObject jSONObject3 = jSONObject2.getJSONObject("properties");
            if ("update".equals(string3)) {
                this.updateContact(jSONObject3, jSONObject2.getLong("id"), string2);
            } else {
                this.insertContact(jSONObject3, string2);
            }
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
    }

    private void insertContact(JSONObject jSONObject, String string2) throws JSONException {
        Object object2;
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>();
        arrayList.add(ContentProviderOperation.newInsert((Uri)ContactsContract.RawContacts.CONTENT_URI).withValue("account_name", (Object)this.mAccountName).withValue("account_type", (Object)this.mAccountType).build());
        List<ContentValues> list = this.getContactValues(jSONObject);
        for (Object object2 : list) {
            arrayList.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValueBackReference("raw_contact_id", 0).withValues(object2).build());
        }
        Object object3 = "KO";
        object2 = -1L;
        ContentProviderResult[] contentProviderResultArray = this.applyBatch(arrayList);
        if (contentProviderResultArray != null) {
            try {
                object2 = ContactService.getRawContactIdFromContentProviderResults(contentProviderResultArray);
                if (object2 != null) {
                    object3 = "OK";
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)LOGTAG, (String)"NumberFormatException", (Throwable)numberFormatException);
            }
            Log.i((String)LOGTAG, (String)("Newly created contact ID: " + object2));
        }
        Log.i((String)LOGTAG, (String)("Sending return status: " + (String)object3));
        this.sendCallbackToJavascript("Android:Contact:Save:Return:" + (String)object3, string2, new String[]{"contactID", "reason"}, new Object[]{object2, "create"});
    }

    private void updateContact(JSONObject jSONObject, long l, String string2) throws JSONException {
        ContentProviderOperation contentProviderOperation = ContentProviderOperation.newDelete((Uri)ContactsContract.Data.CONTENT_URI).withSelection("raw_contact_id=? AND mimetype != 'org.mozilla.gecko/contact_flag'", new String[]{String.valueOf(l)}).build();
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>();
        arrayList.add(contentProviderOperation);
        ContentProviderResult[] contentProviderResultArray = this.applyBatch(arrayList);
        if (contentProviderResultArray == null || !ContactService.checkForPositiveCountInResults(contentProviderResultArray)) {
            Log.w((String)LOGTAG, (String)"Null or 0 remove results");
            this.sendCallbackToJavascript("Android:Contact:Save:Return:KO", string2, null, null);
            return;
        }
        List<ContentValues> list = this.getContactValues(jSONObject);
        ArrayList<ContentProviderOperation> arrayList2 = new ArrayList<ContentProviderOperation>();
        for (ContentValues contentValues : list) {
            arrayList2.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Data.CONTENT_URI).withValue("raw_contact_id", (Object)l).withValues(contentValues).build());
        }
        String string3 = "KO";
        this.applyBatch(arrayList2);
        this.sendCallbackToJavascript("Android:Contact:Save:Return:OK", string2, new String[]{"contactID", "reason"}, new Object[]{l, "update"});
    }

    private List<ContentValues> getContactValues(JSONObject jSONObject) throws JSONException {
        ArrayList<ContentValues> arrayList = new ArrayList<ContentValues>();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mimetype", "vnd.android.cursor.item/group_membership");
        contentValues.put(CUSTOM_DATA_COLUMN, Long.valueOf(this.mGroupId));
        arrayList.add(contentValues);
        this.getNameValues(jSONObject.optJSONArray("name"), jSONObject.optJSONArray("givenName"), jSONObject.optJSONArray("familyName"), jSONObject.optJSONArray("honorificPrefix"), jSONObject.optJSONArray("honorificSuffix"), arrayList);
        this.getGenericValues(MIMETYPE_ADDITIONAL_NAME, CUSTOM_DATA_COLUMN, jSONObject.optJSONArray("additionalName"), arrayList);
        this.getNicknamesValues(jSONObject.optJSONArray("nickname"), arrayList);
        this.getAddressesValues(jSONObject.optJSONArray("adr"), arrayList);
        this.getPhonesValues(jSONObject.optJSONArray("tel"), arrayList);
        this.getEmailsValues(jSONObject.optJSONArray("email"), arrayList);
        this.getGenericValues("vnd.android.cursor.item/organization", CUSTOM_DATA_COLUMN, jSONObject.optJSONArray("org"), arrayList);
        this.getGenericValues("vnd.android.cursor.item/organization", "data4", jSONObject.optJSONArray("jobTitle"), arrayList);
        this.getNotesValues(jSONObject.optJSONArray("note"), arrayList);
        this.getWebsitesValues(jSONObject.optJSONArray("url"), arrayList);
        this.getImsValues(jSONObject.optJSONArray("impp"), arrayList);
        this.getCategoriesValues(jSONObject.optJSONArray("category"), arrayList);
        this.getEventValues(jSONObject.optString("bday"), 3, arrayList);
        this.getEventValues(jSONObject.optString("anniversary"), 1, arrayList);
        this.getCustomMimetypeValues(jSONObject.optString("sex"), MIMETYPE_SEX, arrayList);
        this.getCustomMimetypeValues(jSONObject.optString("genderIdentity"), MIMETYPE_GENDER_IDENTITY, arrayList);
        this.getGenericValues(MIMETYPE_KEY, CUSTOM_DATA_COLUMN, jSONObject.optJSONArray("key"), arrayList);
        return arrayList;
    }

    private void getGenericValues(String string2, String string3, JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("mimetype", string2);
            contentValues.put(string3, jSONArray.getString(i));
            list.add(contentValues);
        }
    }

    private void getNameValues(JSONArray jSONArray, JSONArray jSONArray2, JSONArray jSONArray3, JSONArray jSONArray4, JSONArray jSONArray5, List<ContentValues> list) throws JSONException {
        int n = ContactService.max(jSONArray != null ? jSONArray.length() : 0, jSONArray2 != null ? jSONArray2.length() : 0, jSONArray3 != null ? jSONArray3.length() : 0, jSONArray4 != null ? jSONArray4.length() : 0, jSONArray5 != null ? jSONArray5.length() : 0);
        for (int i = 0; i < n; ++i) {
            String string2;
            ContentValues contentValues = new ContentValues();
            contentValues.put("mimetype", "vnd.android.cursor.item/name");
            String string3 = jSONArray != null ? jSONArray.optString(i, null) : null;
            String string4 = jSONArray2 != null ? jSONArray2.optString(i, null) : null;
            String string5 = jSONArray3 != null ? jSONArray3.optString(i, null) : null;
            String string6 = jSONArray4 != null ? jSONArray4.optString(i, null) : null;
            String string7 = string2 = jSONArray5 != null ? jSONArray5.optString(i, null) : null;
            if (string3 != null) {
                contentValues.put(CUSTOM_DATA_COLUMN, string3);
            }
            if (string4 != null) {
                contentValues.put("data2", string4);
            }
            if (string5 != null) {
                contentValues.put("data3", string5);
            }
            if (string6 != null) {
                contentValues.put("data4", string6);
            }
            if (string2 != null) {
                contentValues.put("data6", string2);
            }
            list.add(contentValues);
        }
    }

    private void getNicknamesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("mimetype", "vnd.android.cursor.item/nickname");
            contentValues.put(CUSTOM_DATA_COLUMN, jSONArray.getString(i));
            contentValues.put("data2", Integer.valueOf(1));
            list.add(contentValues);
        }
    }

    private void getAddressesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONArray jSONArray2 = jSONObject.optJSONArray("type");
            if (jSONArray2 != null) {
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getString(j);
                    int n = this.getAddressType(string2);
                    list.add(this.createAddressContentValues(jSONObject, n, string2));
                }
                continue;
            }
            list.add(this.createAddressContentValues(jSONObject, -1, null));
        }
    }

    private ContentValues createAddressContentValues(JSONObject jSONObject, int n, String string2) throws JSONException {
        ContentValues contentValues = new ContentValues();
        contentValues.put("mimetype", "vnd.android.cursor.item/postal-address_v2");
        contentValues.put("data4", jSONObject.optString("streetAddress"));
        contentValues.put("data7", jSONObject.optString("locality"));
        contentValues.put("data8", jSONObject.optString("region"));
        contentValues.put("data9", jSONObject.optString("postalCode"));
        contentValues.put("data10", jSONObject.optString("countryName"));
        if (string2 != null) {
            contentValues.put("data2", Integer.valueOf(n));
            if (n == 0) {
                contentValues.put("data3", string2);
            }
        }
        if (jSONObject.has("pref")) {
            contentValues.put("is_super_primary", Integer.valueOf(jSONObject.getBoolean("pref") ? 1 : 0));
        }
        return contentValues;
    }

    private void getPhonesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            ContentValues contentValues;
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONArray jSONArray2 = jSONObject.optJSONArray("type");
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getString(j);
                    int n = this.getPhoneType(string2);
                    contentValues = this.createContentValues("vnd.android.cursor.item/phone_v2", jSONObject.optString("value"), n, string2, jSONObject.optBoolean("pref"));
                    if (jSONObject.has("carrier")) {
                        contentValues.put(CARRIER_COLUMN, jSONObject.optString("carrier"));
                    }
                    list.add(contentValues);
                }
                continue;
            }
            contentValues = this.createContentValues("vnd.android.cursor.item/phone_v2", jSONObject.optString("value"), -1, null, jSONObject.optBoolean("pref"));
            if (jSONObject.has("carrier")) {
                contentValues.put(CARRIER_COLUMN, jSONObject.optString("carrier"));
            }
            list.add(contentValues);
        }
    }

    private void getEmailsValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONArray jSONArray2 = jSONObject.optJSONArray("type");
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getString(j);
                    int n = this.getEmailType(string2);
                    list.add(this.createContentValues("vnd.android.cursor.item/email_v2", jSONObject.optString("value"), n, string2, jSONObject.optBoolean("pref")));
                }
                continue;
            }
            list.add(this.createContentValues("vnd.android.cursor.item/email_v2", jSONObject.optString("value"), -1, null, jSONObject.optBoolean("pref")));
        }
    }

    private void getPhotosValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
    }

    private void getNotesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            ContentValues contentValues = new ContentValues();
            contentValues.put("mimetype", "vnd.android.cursor.item/note");
            contentValues.put(CUSTOM_DATA_COLUMN, jSONArray.getString(i));
            list.add(contentValues);
        }
    }

    private void getWebsitesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONArray jSONArray2 = jSONObject.optJSONArray("type");
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getString(j);
                    int n = this.getWebsiteType(string2);
                    list.add(this.createContentValues("vnd.android.cursor.item/website", jSONObject.optString("value"), n, string2, jSONObject.optBoolean("pref")));
                }
                continue;
            }
            list.add(this.createContentValues("vnd.android.cursor.item/website", jSONObject.optString("value"), -1, null, jSONObject.optBoolean("pref")));
        }
    }

    private void getImsValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            JSONArray jSONArray2 = jSONObject.optJSONArray("type");
            if (jSONArray2 != null && jSONArray2.length() > 0) {
                for (int j = 0; j < jSONArray2.length(); ++j) {
                    String string2 = jSONArray2.getString(j);
                    int n = this.getImType(string2);
                    list.add(this.createContentValues("vnd.android.cursor.item/im", jSONObject.optString("value"), n, string2, jSONObject.optBoolean("pref")));
                }
                continue;
            }
            list.add(this.createContentValues("vnd.android.cursor.item/im", jSONObject.optString("value"), -1, null, jSONObject.optBoolean("pref")));
        }
    }

    private void getCategoriesValues(JSONArray jSONArray, List<ContentValues> list) throws JSONException {
        if (jSONArray == null) {
            return;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            String string2 = jSONArray.getString(i);
            if ("my contacts".equals(string2.toLowerCase()) || PRE_HONEYCOMB_DEFAULT_GROUP.equalsIgnoreCase(string2)) {
                Log.w((String)LOGTAG, (String)"New contacts are implicitly added to the default group.");
                continue;
            }
            long l = this.getGroupId(string2);
            if (l == -1L && (l = this.createGroup(string2)) == -1L) {
                Log.w((String)LOGTAG, (String)"Failed to create new group for given category.");
                continue;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("mimetype", "vnd.android.cursor.item/group_membership");
            contentValues.put(CUSTOM_DATA_COLUMN, Long.valueOf(l));
            list.add(contentValues);
            list.add(contentValues);
        }
    }

    private void getEventValues(String string2, int n, List<ContentValues> list) {
        if (string2 == null || string2.length() < 11) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("mimetype", "vnd.android.cursor.item/contact_event");
        contentValues.put(CUSTOM_DATA_COLUMN, string2.substring(0, 10));
        contentValues.put("data2", Integer.valueOf(n));
        list.add(contentValues);
    }

    private void getCustomMimetypeValues(String string2, String string3, List<ContentValues> list) {
        if (string2 == null || "null".equals(string2)) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("mimetype", string3);
        contentValues.put(CUSTOM_DATA_COLUMN, string2);
        list.add(contentValues);
    }

    private void getMozillaContactFlagValues(List<ContentValues> list) {
        try {
            JSONArray jSONArray = new JSONArray();
            jSONArray.put((Object)"1");
            this.getGenericValues(MIMETYPE_MOZILLA_CONTACTS_FLAG, CUSTOM_DATA_COLUMN, jSONArray, list);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
    }

    private ContentValues createContentValues(String string2, String string3, int n, String string4, boolean bl) {
        ContentValues contentValues = new ContentValues();
        contentValues.put("mimetype", string2);
        contentValues.put(CUSTOM_DATA_COLUMN, string3);
        contentValues.put("is_super_primary", Integer.valueOf(bl ? 1 : 0));
        if (string4 != null) {
            contentValues.put("data2", Integer.valueOf(n));
            if (n == 0) {
                contentValues.put("data3", string4);
            }
        }
        return contentValues;
    }

    private void getContactsCount(String string2) {
        Cursor cursor = this.getAllRawContactIdsCursor();
        Integer n = cursor.getCount();
        cursor.close();
        this.sendCallbackToJavascript("Android:Contacts:Count", string2, new String[]{"count"}, new Object[]{n});
    }

    private void sendCallbackToJavascript(String string2, String string3, String[] stringArray, Object[] objectArray) {
        if (stringArray != null && stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Argument names and argument values lengths do not match. Names length = " + stringArray.length + ", Values length = " + objectArray.length);
        }
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("requestID", (Object)string3);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    jSONObject.put(stringArray[i], objectArray[i]);
                }
            }
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent(string2, jSONObject.toString()));
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException(jSONException);
        }
    }

    private ContentProviderResult[] applyBatch(ArrayList<ContentProviderOperation> arrayList) {
        try {
            return this.mContentResolver.applyBatch("com.android.contacts", arrayList);
        }
        catch (RemoteException remoteException) {
            Log.e((String)LOGTAG, (String)"RemoteException", (Throwable)remoteException);
        }
        catch (OperationApplicationException operationApplicationException) {
            Log.e((String)LOGTAG, (String)"OperationApplicationException", (Throwable)operationApplicationException);
        }
        return null;
    }

    private void getDeviceAccount(Runnable runnable) {
        Account[] accountArray = AccountManager.get((Context)this.mActivity).getAccounts();
        if (accountArray.length == 0) {
            Log.w((String)LOGTAG, (String)"No accounts available");
            this.gotDeviceAccount(runnable);
        } else if (accountArray.length > 1) {
            this.showAccountsDialog(accountArray, runnable);
        } else {
            this.mAccountName = accountArray[0].name;
            this.mAccountType = accountArray[0].type;
            this.gotDeviceAccount(runnable);
        }
        this.mGotDeviceAccount = true;
    }

    private void showAccountsDialog(final Account[] accountArray, final Runnable runnable) {
        CharSequence[] charSequenceArray = new String[accountArray.length];
        for (int i = 0; i < accountArray.length; ++i) {
            charSequenceArray[i] = accountArray[i].name;
        }
        final AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        builder.setTitle((CharSequence)this.mActivity.getResources().getString(R.string.contacts_account_chooser_dialog_title2)).setSingleChoiceItems(charSequenceArray, 0, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                ContactService.this.mAccountName = accountArray[n].name;
                ContactService.this.mAccountType = accountArray[n].type;
                dialogInterface.dismiss();
                ContactService.this.gotDeviceAccount(runnable);
            }
        });
        this.mActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                builder.show();
            }
        });
    }

    private void gotDeviceAccount(final Runnable runnable) {
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                ContactService.this.getDefaultGroupId();
                if (ContactService.this.mAccountName == null) {
                    Log.i((String)ContactService.LOGTAG, (String)"No device account selected. Leaving account as null.");
                } else {
                    Log.i((String)ContactService.LOGTAG, (String)"Got device account to use for contact operations.");
                }
                runnable.run();
            }
        };
        ThreadUtils.postToBackgroundThread((Runnable)runnable2);
    }

    private void getDefaultGroupId() {
        Cursor cursor = this.getAllGroups();
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            String string2;
            String string3 = cursor.getString(0);
            if (!string3.equals(this.mAccountName) || !(string2 = cursor.getString(1)).equals(this.mAccountType)) continue;
            if (ContactService.isAutoAddGroup(cursor)) {
                this.mGroupTitle = cursor.getString(3);
                this.mGroupId = cursor.getLong(2);
                break;
            }
            if (!PRE_HONEYCOMB_DEFAULT_GROUP.equals(cursor.getString(3))) continue;
            this.mGroupId = cursor.getLong(2);
            this.mGroupTitle = PRE_HONEYCOMB_DEFAULT_GROUP;
            break;
        }
        cursor.close();
        if (this.mGroupId == 0L) {
            Log.w((String)LOGTAG, (String)"Default group ID not found. Newly created contacts will not belong to any groups.");
        }
    }

    private static boolean isAutoAddGroup(Cursor cursor) {
        return AppConstants.Versions.feature11Plus && !cursor.isNull(4) && cursor.getInt(4) != 0;
    }

    private long getGroupId(String string2) {
        long l = -1L;
        Cursor cursor = this.getGroups("title = '" + string2 + "'");
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            String string3 = cursor.getString(0);
            String string4 = cursor.getString(1);
            if ((!string3.equals(this.mAccountName) || !string4.equals(this.mAccountType)) && (this.mAccountName != null || !"Phone".equals(string4)) || !string2.equals(cursor.getString(3))) continue;
            l = cursor.getLong(2);
            break;
        }
        cursor.close();
        return l;
    }

    private String getGroupName(long l) {
        Cursor cursor = this.getGroups("_id = " + l);
        if (cursor.getCount() == 0) {
            cursor.close();
            return null;
        }
        cursor.moveToPosition(0);
        String string2 = cursor.getString(cursor.getColumnIndex("title"));
        cursor.close();
        return string2;
    }

    private Cursor getAllGroups() {
        return this.getGroups(null);
    }

    private Cursor getGroups(String string2) {
        String[] stringArray = new String[]{"account_name", "account_type", "_id", "title", AppConstants.Versions.feature11Plus ? "auto_add" : "_id"};
        string2 = string2 != null ? "AND " + string2 : "";
        return this.mContentResolver.query(ContactsContract.Groups.CONTENT_URI, stringArray, "account_type NOT NULL AND account_name NOT NULL " + string2, null, null);
    }

    private long createGroup(String string2) {
        ArrayList<ContentProviderOperation> arrayList = new ArrayList<ContentProviderOperation>();
        arrayList.add(ContentProviderOperation.newInsert((Uri)ContactsContract.Groups.CONTENT_URI).withValue("account_name", (Object)(this.mAccountName == null ? "Phone" : this.mAccountName)).withValue("account_type", (Object)(this.mAccountType == null ? "Phone" : this.mAccountType)).withValue("title", (Object)string2).withValue("group_visible", (Object)true).build());
        this.applyBatch(arrayList);
        return this.getGroupId(string2);
    }

    private long[] getAllRawContactIds() {
        Cursor cursor = this.getAllRawContactIdsCursor();
        long[] lArray = new long[cursor.getCount()];
        int n = 0;
        cursor.moveToPosition(-1);
        while (cursor.moveToNext()) {
            lArray[n] = cursor.getLong(cursor.getColumnIndex("_id"));
            ++n;
        }
        cursor.close();
        return lArray;
    }

    private Cursor getAllRawContactIdsCursor() {
        String string2 = "deleted=0";
        String[] stringArray = null;
        if (this.mAccountName != null) {
            string2 = string2 + " AND account_name=? AND account_type=?";
            stringArray = new String[]{this.mAccountName, this.mAccountType};
        }
        return this.mContentResolver.query(ContactsContract.RawContacts.CONTENT_URI, new String[]{"_id"}, string2, stringArray, null);
    }

    private static Long getRawContactIdFromContentProviderResults(ContentProviderResult[] contentProviderResultArray) throws NumberFormatException {
        for (int i = 0; i < contentProviderResultArray.length; ++i) {
            String string2;
            if (contentProviderResultArray[i].uri == null || !(string2 = contentProviderResultArray[i].uri.toString()).contains("raw_contacts")) continue;
            return Long.parseLong(string2.substring(string2.lastIndexOf("/") + 1));
        }
        return null;
    }

    private static boolean checkForPositiveCountInResults(ContentProviderResult[] contentProviderResultArray) {
        for (int i = 0; i < contentProviderResultArray.length; ++i) {
            Integer n = contentProviderResultArray[i].count;
            if (n == null || n <= 0) continue;
            return true;
        }
        return false;
    }

    private static long[] convertLongListToArray(List<Long> list) {
        long[] lArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            lArray[i] = list.get(i);
        }
        return lArray;
    }

    private static boolean doesJSONArrayContainString(JSONArray jSONArray, String string2) {
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (!string2.equals(jSONArray.optString(i))) continue;
            return true;
        }
        return false;
    }

    private static int max(int ... nArray) {
        int n = nArray[0];
        for (int n2 : nArray) {
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    private static void putPossibleNullValueInJSONObject(String string2, Object object, JSONObject jSONObject) throws JSONException {
        if (object != null) {
            jSONObject.put(string2, object);
        } else {
            jSONObject.put(string2, JSONObject.NULL);
        }
    }

    private static String getKeyFromMapValue(HashMap<String, Integer> hashMap, int n) {
        for (Map.Entry<String, Integer> entry : hashMap.entrySet()) {
            if (n != entry.getValue()) continue;
            return entry.getKey();
        }
        return null;
    }

    private String getColumnNameConstant(String string2) {
        this.initColumnNameConstantsMap();
        return this.mColumnNameConstantsMap.get(string2.toLowerCase());
    }

    private void initColumnNameConstantsMap() {
        if (this.mColumnNameConstantsMap != null) {
            return;
        }
        this.mColumnNameConstantsMap = new HashMap();
        this.mColumnNameConstantsMap.put("name", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("givenname", "data2");
        this.mColumnNameConstantsMap.put("familyname", "data3");
        this.mColumnNameConstantsMap.put("honorificprefix", "data4");
        this.mColumnNameConstantsMap.put("honorificsuffix", "data6");
        this.mColumnNameConstantsMap.put("additionalname", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("nickname", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("adr", "data4");
        this.mColumnNameConstantsMap.put("email", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("url", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("category", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("tel", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("org", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("jobTitle", "data4");
        this.mColumnNameConstantsMap.put("note", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("impp", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("sex", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("genderidentity", CUSTOM_DATA_COLUMN);
        this.mColumnNameConstantsMap.put("key", CUSTOM_DATA_COLUMN);
    }

    private String getMimeTypeOfField(String string2) {
        this.initMimeTypeConstantsMap();
        return this.mMimeTypeConstantsMap.get(string2.toLowerCase());
    }

    private void initMimeTypeConstantsMap() {
        if (this.mMimeTypeConstantsMap != null) {
            return;
        }
        this.mMimeTypeConstantsMap = new HashMap();
        this.mMimeTypeConstantsMap.put("name", "vnd.android.cursor.item/name");
        this.mMimeTypeConstantsMap.put("givenname", "vnd.android.cursor.item/name");
        this.mMimeTypeConstantsMap.put("familyname", "vnd.android.cursor.item/name");
        this.mMimeTypeConstantsMap.put("honorificprefix", "vnd.android.cursor.item/name");
        this.mMimeTypeConstantsMap.put("honorificsuffix", "vnd.android.cursor.item/name");
        this.mMimeTypeConstantsMap.put("additionalname", MIMETYPE_ADDITIONAL_NAME);
        this.mMimeTypeConstantsMap.put("nickname", "vnd.android.cursor.item/nickname");
        this.mMimeTypeConstantsMap.put("email", "vnd.android.cursor.item/email_v2");
        this.mMimeTypeConstantsMap.put("url", "vnd.android.cursor.item/website");
        this.mMimeTypeConstantsMap.put("category", "vnd.android.cursor.item/group_membership");
        this.mMimeTypeConstantsMap.put("tel", "vnd.android.cursor.item/phone_v2");
        this.mMimeTypeConstantsMap.put("org", "vnd.android.cursor.item/organization");
        this.mMimeTypeConstantsMap.put("jobTitle", "vnd.android.cursor.item/organization");
        this.mMimeTypeConstantsMap.put("note", "vnd.android.cursor.item/note");
        this.mMimeTypeConstantsMap.put("impp", "vnd.android.cursor.item/im");
        this.mMimeTypeConstantsMap.put("sex", MIMETYPE_SEX);
        this.mMimeTypeConstantsMap.put("genderidentity", MIMETYPE_GENDER_IDENTITY);
        this.mMimeTypeConstantsMap.put("key", MIMETYPE_KEY);
    }

    private int getAddressType(String string2) {
        this.initAddressTypesMap();
        Integer n = this.mAddressTypesMap.get(string2.toLowerCase());
        return n != null ? n : 0;
    }

    private void initAddressTypesMap() {
        if (this.mAddressTypesMap != null) {
            return;
        }
        this.mAddressTypesMap = new HashMap();
        this.mAddressTypesMap.put("home", 1);
        this.mAddressTypesMap.put("work", 2);
    }

    private int getPhoneType(String string2) {
        this.initPhoneTypesMap();
        Integer n = this.mPhoneTypesMap.get(string2.toLowerCase());
        return n != null ? n : 0;
    }

    private void initPhoneTypesMap() {
        if (this.mPhoneTypesMap != null) {
            return;
        }
        this.mPhoneTypesMap = new HashMap();
        this.mPhoneTypesMap.put("home", 1);
        this.mPhoneTypesMap.put("mobile", 2);
        this.mPhoneTypesMap.put("work", 3);
        this.mPhoneTypesMap.put("fax home", 5);
        this.mPhoneTypesMap.put("fax work", 4);
        this.mPhoneTypesMap.put("pager", 6);
        this.mPhoneTypesMap.put("callback", 8);
        this.mPhoneTypesMap.put("car", 9);
        this.mPhoneTypesMap.put("company main", 10);
        this.mPhoneTypesMap.put("isdn", 11);
        this.mPhoneTypesMap.put("main", 12);
        this.mPhoneTypesMap.put("fax other", 13);
        this.mPhoneTypesMap.put("other fax", 13);
        this.mPhoneTypesMap.put("radio", 14);
        this.mPhoneTypesMap.put("telex", 15);
        this.mPhoneTypesMap.put("tty", 16);
        this.mPhoneTypesMap.put("ttd", 16);
        this.mPhoneTypesMap.put("work mobile", 17);
        this.mPhoneTypesMap.put("work pager", 18);
        this.mPhoneTypesMap.put("assistant", 19);
        this.mPhoneTypesMap.put("mms", 20);
    }

    private int getEmailType(String string2) {
        this.initEmailTypesMap();
        Integer n = this.mEmailTypesMap.get(string2.toLowerCase());
        return n != null ? n : 0;
    }

    private void initEmailTypesMap() {
        if (this.mEmailTypesMap != null) {
            return;
        }
        this.mEmailTypesMap = new HashMap();
        this.mEmailTypesMap.put("home", 1);
        this.mEmailTypesMap.put("mobile", 4);
        this.mEmailTypesMap.put("work", 2);
    }

    private int getWebsiteType(String string2) {
        this.initWebsiteTypesMap();
        Integer n = this.mWebsiteTypesMap.get(string2.toLowerCase());
        return n != null ? n : 0;
    }

    private void initWebsiteTypesMap() {
        if (this.mWebsiteTypesMap != null) {
            return;
        }
        this.mWebsiteTypesMap = new HashMap();
        this.mWebsiteTypesMap.put("homepage", 1);
        this.mWebsiteTypesMap.put("blog", 2);
        this.mWebsiteTypesMap.put("profile", 3);
        this.mWebsiteTypesMap.put("home", 4);
        this.mWebsiteTypesMap.put("work", 5);
        this.mWebsiteTypesMap.put("ftp", 6);
    }

    private int getImType(String string2) {
        this.initImTypesMap();
        Integer n = this.mImTypesMap.get(string2.toLowerCase());
        return n != null ? n : 0;
    }

    private void initImTypesMap() {
        if (this.mImTypesMap != null) {
            return;
        }
        this.mImTypesMap = new HashMap();
        this.mImTypesMap.put("home", 1);
        this.mImTypesMap.put("work", 2);
    }

    private String[] getAllColumns() {
        return new String[]{"data_id", "mimetype", "is_super_primary", CUSTOM_DATA_COLUMN, "data2", "data3", "data4", CARRIER_COLUMN, "data6", "data7", "data8", "data9", "data10", "data11", "data12", "data13", "data14", "data15"};
    }

    private class ContactsComparator
    implements Comparator<JSONObject> {
        final String mSortBy;
        final String mSortOrder;

        public ContactsComparator(String string2, String string3) {
            this.mSortBy = string2.toLowerCase();
            this.mSortOrder = string3.toLowerCase();
        }

        @Override
        public int compare(JSONObject jSONObject, JSONObject jSONObject2) {
            String string2;
            String string3;
            int n;
            JSONObject jSONObject3;
            JSONObject jSONObject4;
            boolean bl = false;
            if ("familyname".equals(this.mSortBy)) {
                bl = true;
            }
            try {
                jSONObject4 = jSONObject.getJSONObject("properties");
                jSONObject3 = jSONObject2.getJSONObject("properties");
            }
            catch (JSONException jSONException) {
                throw new IllegalArgumentException(jSONException);
            }
            JSONArray jSONArray = jSONObject4.optJSONArray("familyName");
            JSONArray jSONArray2 = jSONObject4.optJSONArray("givenName");
            JSONArray jSONArray3 = jSONObject3.optJSONArray("familyName");
            JSONArray jSONArray4 = jSONObject3.optJSONArray("givenName");
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            if (jSONArray2 == null) {
                jSONArray2 = new JSONArray();
            }
            if (jSONArray3 == null) {
                jSONArray3 = new JSONArray();
            }
            if (jSONArray4 == null) {
                jSONArray4 = new JSONArray();
            }
            int n2 = ContactService.max(new int[]{jSONArray.length(), jSONArray2.length(), jSONArray3.length(), jSONArray4.length()});
            int n3 = 0;
            do {
                string3 = "";
                string2 = "";
                if (bl) {
                    string3 = jSONArray.optString(n3, "") + jSONArray2.optString(n3, "");
                    string2 = jSONArray3.optString(n3, "") + jSONArray4.optString(n3, "");
                    continue;
                }
                string3 = jSONArray2.optString(n3, "") + jSONArray.optString(n3, "");
                string2 = jSONArray4.optString(n3, "") + jSONArray3.optString(n3, "");
            } while ((n = string3.compareTo(string2)) == 0 && ++n3 < n2);
            if (n != 0 && "descending".equals(this.mSortOrder)) {
                n = -n;
            }
            return n;
        }
    }
}

