/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.background.healthreport;

import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import java.util.Iterator;
import org.json.JSONObject;
import org.mozilla.gecko.SysInfo;
import org.mozilla.gecko.background.common.log.Logger;
import org.mozilla.gecko.background.healthreport.Environment;
import org.mozilla.gecko.background.healthreport.HealthReportDatabaseStorage;
import org.mozilla.gecko.background.healthreport.HealthReportProvider;
import org.mozilla.gecko.background.healthreport.HealthReportStorage;

public class EnvironmentBuilder {
    private static final String LOG_TAG = "GeckoEnvBuilder";

    public static ContentProviderClient getContentProviderClient(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        return contentResolver.acquireContentProviderClient("org.mozilla.fennec.health");
    }

    public static HealthReportDatabaseStorage getStorage(ContentProviderClient contentProviderClient, String string2) {
        ContentProvider contentProvider = contentProviderClient.getLocalContentProvider();
        if (contentProvider == null) {
            Logger.error(LOG_TAG, "Unable to retrieve local content provider. Running in a different process?");
            return null;
        }
        try {
            return ((HealthReportProvider)contentProvider).getProfileStorage(string2);
        }
        catch (ClassCastException classCastException) {
            Logger.error(LOG_TAG, "ContentProvider not a HealthReportProvider!", classCastException);
            throw classCastException;
        }
    }

    protected static void populateEnvironment(Environment environment, ProfileInformationProvider profileInformationProvider, ConfigurationProvider configurationProvider) {
        environment.cpuCount = SysInfo.getCPUCount();
        environment.memoryMB = SysInfo.getMemSize();
        environment.appName = "fennec";
        environment.appID = "{aa3c5121-dab2-40e2-81ca-7ea25febc110}";
        environment.appVersion = "36.0a1";
        environment.appBuildID = "20141119030200";
        environment.updateChannel = "nightly";
        environment.vendor = "Mozilla";
        environment.platformVersion = "36.0a1";
        environment.platformBuildID = "20141119030200";
        environment.xpcomabi = "x86-gcc3";
        environment.os = "Android";
        environment.architecture = SysInfo.getArchABI();
        environment.sysName = SysInfo.getName();
        environment.sysVersion = SysInfo.getReleaseVersion();
        environment.profileCreation = (int)(profileInformationProvider.getProfileCreationTime() / 86400000L);
        environment.isBlocklistEnabled = profileInformationProvider.isBlocklistEnabled() ? 1 : 0;
        environment.isTelemetryEnabled = profileInformationProvider.isTelemetryEnabled() ? 1 : 0;
        environment.extensionCount = 0;
        environment.pluginCount = 0;
        environment.themeCount = 0;
        JSONObject jSONObject = profileInformationProvider.getAddonsJSON();
        if (jSONObject != null) {
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                try {
                    JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
                    String string3 = jSONObject2.optString("type");
                    Logger.pii(LOG_TAG, "Add-on " + string2 + " is a " + string3);
                    if ("extension".equals(string3)) {
                        ++environment.extensionCount;
                        continue;
                    }
                    if ("plugin".equals(string3)) {
                        ++environment.pluginCount;
                        continue;
                    }
                    if ("theme".equals(string3)) {
                        ++environment.themeCount;
                        continue;
                    }
                    if ("service".equals(string3)) continue;
                    Logger.debug(LOG_TAG, "Unknown add-on type: " + string3);
                }
                catch (Exception exception) {
                    Logger.warn(LOG_TAG, "Failed to process add-on " + string2, exception);
                }
            }
        }
        environment.addons = jSONObject;
        environment.distribution = profileInformationProvider.getDistributionString();
        environment.osLocale = profileInformationProvider.getOSLocale();
        environment.appLocale = profileInformationProvider.getAppLocale();
        environment.acceptLangSet = profileInformationProvider.isAcceptLangUserSet() ? 1 : 0;
        environment.hasHardwareKeyboard = configurationProvider.hasHardwareKeyboard();
        environment.uiType = configurationProvider.getUIType();
        environment.uiMode = configurationProvider.getUIModeType();
        environment.screenLayout = configurationProvider.getScreenLayoutSize();
        environment.screenXInMM = configurationProvider.getScreenXInMM();
        environment.screenYInMM = configurationProvider.getScreenYInMM();
    }

    public static Environment getCurrentEnvironment(ProfileInformationProvider profileInformationProvider, ConfigurationProvider configurationProvider) {
        Environment environment = new Environment(){

            @Override
            public int register() {
                return 0;
            }
        };
        EnvironmentBuilder.populateEnvironment(environment, profileInformationProvider, configurationProvider);
        return environment;
    }

    public static int registerCurrentEnvironment(HealthReportStorage healthReportStorage, ProfileInformationProvider profileInformationProvider, ConfigurationProvider configurationProvider) {
        Environment environment = healthReportStorage.getEnvironment();
        EnvironmentBuilder.populateEnvironment(environment, profileInformationProvider, configurationProvider);
        environment.register();
        Logger.debug(LOG_TAG, "Registering current environment: " + environment.getHash() + " = " + environment.id);
        return environment.id;
    }

    public static interface ConfigurationProvider {
        public boolean hasHardwareKeyboard();

        public Environment.UIType getUIType();

        public int getUIModeType();

        public int getScreenLayoutSize();

        public int getScreenXInMM();

        public int getScreenYInMM();
    }

    public static interface ProfileInformationProvider {
        public boolean isBlocklistEnabled();

        public boolean isTelemetryEnabled();

        public boolean isAcceptLangUserSet();

        public long getProfileCreationTime();

        public String getDistributionString();

        public String getOSLocale();

        public String getAppLocale();

        public JSONObject getAddonsJSON();
    }
}

