/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.home;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.EventDispatcher;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.R;
import org.mozilla.gecko.animation.PropertyAnimator;
import org.mozilla.gecko.animation.ViewHelper;
import org.mozilla.gecko.gfx.BitmapUtils;
import org.mozilla.gecko.util.GeckoEventListener;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.widget.EllipsisTextView;

public class HomeBanner
extends LinearLayout
implements GeckoEventListener {
    private static final String LOGTAG = "GeckoHomeBanner";
    private float mTouchY = -1.0f;
    private boolean mSnapBannerToTop;
    private boolean mActive;
    private boolean mScrollingPages;
    private boolean mUserSwipedDown;
    private final EllipsisTextView mTextView;
    private final ImageView mIconView;
    private final float mHeight;
    private OnDismissListener mOnDismissListener;

    public HomeBanner(Context context) {
        this(context, null);
    }

    public HomeBanner(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        LayoutInflater.from((Context)context).inflate(R.layout.home_banner_content, (ViewGroup)this);
        this.mTextView = (EllipsisTextView)this.findViewById(R.id.text);
        this.mIconView = (ImageView)this.findViewById(R.id.icon);
        this.mHeight = this.getResources().getDimensionPixelSize(R.dimen.home_banner_height);
        this.setEnabled(false);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        ImageButton imageButton = (ImageButton)this.findViewById(R.id.close);
        imageButton.getDrawable().setAlpha(127);
        imageButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeBanner.this.dismiss();
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Dismiss", (String)HomeBanner.this.getTag()));
            }
        });
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HomeBanner.this.dismiss();
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Click", (String)HomeBanner.this.getTag()));
            }
        });
        EventDispatcher.getInstance().registerGeckoThreadListener(this, "HomeBanner:Data");
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventDispatcher.getInstance().unregisterGeckoThreadListener(this, "HomeBanner:Data");
    }

    public void setVisibility(int n) {
        if (AppConstants.Versions.preHC && n == 8) {
            this.clearAnimation();
        }
        super.setVisibility(n);
    }

    public void setScrollingPages(boolean bl) {
        this.mScrollingPages = bl;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private void dismiss() {
        this.setVisibility(8);
        this.setEnabled(false);
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    public void update() {
        GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Get", null));
    }

    public void handleMessage(String string2, JSONObject jSONObject) {
        final String string3 = jSONObject.optString("id");
        final String string4 = jSONObject.optString("text");
        final String string5 = jSONObject.optString("iconURI");
        if (TextUtils.isEmpty((CharSequence)string3) || TextUtils.isEmpty((CharSequence)string4)) {
            return;
        }
        ThreadUtils.postToUiThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HomeBanner.this.setTag(string3);
                HomeBanner.this.mTextView.setOriginalText((CharSequence)Html.fromHtml((String)string4));
                BitmapUtils.getDrawable(HomeBanner.this.getContext(), string5, new BitmapUtils.BitmapLoader(){

                    @Override
                    public void onBitmapFound(Drawable drawable2) {
                        if (drawable2 == null) {
                            HomeBanner.this.mIconView.setVisibility(8);
                        } else {
                            HomeBanner.this.mIconView.setImageDrawable(drawable2);
                            HomeBanner.this.mIconView.setVisibility(0);
                        }
                    }
                });
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("HomeBanner:Shown", string3));
                HomeBanner.this.setEnabled(true);
                if (HomeBanner.this.mActive) {
                    HomeBanner.this.animateUp();
                }
            }
        });
    }

    public void setActive(boolean bl) {
        if (this.mActive == bl) {
            return;
        }
        this.mActive = bl;
        if (!this.isEnabled()) {
            return;
        }
        if (bl) {
            this.animateUp();
        } else {
            this.animateDown();
        }
    }

    private void ensureVisible() {
        if (this.getVisibility() == 8) {
            ViewHelper.setTranslationY((View)this, this.mHeight);
            this.setVisibility(0);
        }
    }

    private void animateUp() {
        if (this.mUserSwipedDown) {
            return;
        }
        this.ensureVisible();
        PropertyAnimator propertyAnimator = new PropertyAnimator(100L);
        propertyAnimator.attach((View)this, PropertyAnimator.Property.TRANSLATION_Y, 0.0f);
        propertyAnimator.start();
    }

    private void animateDown() {
        if (ViewHelper.getTranslationY((View)this) == this.mHeight) {
            this.setVisibility(8);
            return;
        }
        PropertyAnimator propertyAnimator = new PropertyAnimator(100L);
        propertyAnimator.attach((View)this, PropertyAnimator.Property.TRANSLATION_Y, this.mHeight);
        propertyAnimator.addPropertyAnimationListener(new PropertyAnimator.PropertyAnimationListener(){

            @Override
            public void onPropertyAnimationStart() {
            }

            @Override
            public void onPropertyAnimationEnd() {
                HomeBanner.this.setVisibility(8);
            }
        });
        propertyAnimator.start();
    }

    public void handleHomeTouch(MotionEvent motionEvent) {
        if (!this.mActive || !this.isEnabled() || this.mScrollingPages) {
            return;
        }
        this.ensureVisible();
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mTouchY = motionEvent.getRawY();
                break;
            }
            case 2: {
                float f = motionEvent.getRawY();
                float f2 = this.mTouchY - f;
                this.mSnapBannerToTop = f2 <= 0.0f;
                float f3 = ViewHelper.getTranslationY((View)this) + f2;
                if (f3 < 0.0f) {
                    f3 = 0.0f;
                } else if (f3 > this.mHeight) {
                    f3 = this.mHeight;
                }
                if (f2 >= 10.0f || f2 <= -10.0f) {
                    this.mUserSwipedDown = f3 == this.mHeight;
                }
                ViewHelper.setTranslationY((View)this, f3);
                this.mTouchY = f;
                break;
            }
            case 1: 
            case 3: {
                this.mTouchY = -1.0f;
                if (this.mSnapBannerToTop) {
                    this.animateUp();
                    break;
                }
                this.animateDown();
                this.mUserSwipedDown = true;
            }
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

