/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.tabs;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.Checkable;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import org.mozilla.gecko.R;
import org.mozilla.gecko.Tab;
import org.mozilla.gecko.widget.TabThumbnailWrapper;

public class TabsLayoutItemView
extends LinearLayout
implements Checkable {
    private static final String LOGTAG = "Gecko" + TabsLayoutItemView.class.getSimpleName();
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private boolean mChecked;
    private int mTabId;
    private TextView mTitle;
    private ImageView mThumbnail;
    private ImageButton mCloseButton;
    private TabThumbnailWrapper mThumbnailWrapper;

    public TabsLayoutItemView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mChecked) {
            TabsLayoutItemView.mergeDrawableStates((int[])nArray, (int[])STATE_CHECKED);
        }
        return nArray;
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(boolean bl) {
        if (this.mChecked == bl) {
            return;
        }
        this.mChecked = bl;
        this.refreshDrawableState();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (!(view instanceof Checkable)) continue;
            ((Checkable)view).setChecked(bl);
        }
    }

    public void toggle() {
        this.mChecked = !this.mChecked;
    }

    public void setCloseOnClickListener(View.OnClickListener onClickListener) {
        this.mCloseButton.setOnClickListener(onClickListener);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mTitle = (TextView)this.findViewById(R.id.title);
        this.mThumbnail = (ImageView)this.findViewById(R.id.thumbnail);
        this.mCloseButton = (ImageButton)this.findViewById(R.id.close);
        this.mThumbnailWrapper = (TabThumbnailWrapper)this.findViewById(R.id.wrapper);
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                TabsLayoutItemView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                Rect rect = new Rect();
                TabsLayoutItemView.this.mCloseButton.getHitRect(rect);
                int n = (int)TypedValue.applyDimension((int)1, (float)40.0f, (DisplayMetrics)TabsLayoutItemView.this.getResources().getDisplayMetrics());
                View view = (View)TabsLayoutItemView.this.mCloseButton.getParent();
                rect.top = 0;
                rect.right = TabsLayoutItemView.this.getWidth();
                rect.left = TabsLayoutItemView.this.getWidth() - n;
                rect.bottom = view.getHeight();
                TabsLayoutItemView.this.setTouchDelegate(new TouchDelegate(rect, (View)TabsLayoutItemView.this.mCloseButton));
                return true;
            }
        });
    }

    protected void assignValues(Tab tab) {
        if (tab == null) {
            return;
        }
        this.mTabId = tab.getId();
        BitmapDrawable bitmapDrawable = tab.getThumbnail();
        this.mThumbnail.setImageDrawable((Drawable)bitmapDrawable);
        if (this.mThumbnailWrapper != null) {
            this.mThumbnailWrapper.setRecording(tab.isRecording());
        }
        this.mTitle.setText((CharSequence)tab.getDisplayTitle());
        this.mCloseButton.setTag((Object)this);
    }

    public int getTabId() {
        return this.mTabId;
    }

    public void setThumbnail(Drawable drawable2) {
        this.mThumbnail.setImageDrawable(drawable2);
    }

    public void setCloseVisible(boolean bl) {
        this.mCloseButton.setVisibility(bl ? 0 : 4);
    }
}

