/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import org.mozilla.gecko.home.HomeConfig;
import org.mozilla.gecko.mozglue.RobocopTarget;
import org.mozilla.gecko.util.StringUtils;

public class AboutPages {
    public static final String ADDONS = "about:addons";
    public static final String APPS = "about:apps";
    public static final String CONFIG = "about:config";
    public static final String DOWNLOADS = "about:downloads";
    public static final String FIREFOX = "about:firefox";
    public static final String HEALTHREPORT = "about:healthreport";
    public static final String HOME = "about:home";
    public static final String PRIVATEBROWSING = "about:privatebrowsing";
    public static final String READER = "about:reader";
    public static final String UPDATER = "about:";
    public static final String URL_FILTER = "about:%";
    public static final String PANEL_PARAM = "panel";
    private static final String[] DEFAULT_ICON_PAGES = new String[]{"about:addons", "about:config", "about:downloads", "about:firefox", "about:healthreport", "about:"};

    public static final boolean isAboutPage(String string) {
        return string != null && string.startsWith(UPDATER);
    }

    public static final boolean isTitlelessAboutPage(String string) {
        return AboutPages.isAboutHome(string) || PRIVATEBROWSING.equals(string);
    }

    public static final boolean isAboutHome(String string) {
        if (string == null || !string.startsWith(HOME)) {
            return false;
        }
        return HOME.equals(string.split("\\?")[0]);
    }

    public static final String getPanelIdFromAboutHomeUrl(String string) {
        return StringUtils.getQueryParameter((String)string, (String)PANEL_PARAM);
    }

    public static final boolean isAboutReader(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(READER);
    }

    public static String[] getDefaultIconPages() {
        return DEFAULT_ICON_PAGES;
    }

    public static boolean isBuiltinIconPage(String string) {
        if (string == null || !string.startsWith(UPDATER)) {
            return false;
        }
        if (AboutPages.isAboutHome(string)) {
            return true;
        }
        for (int i = 0; i < DEFAULT_ICON_PAGES.length; ++i) {
            if (!DEFAULT_ICON_PAGES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    @RobocopTarget
    public static String getURLForBuiltinPanelType(HomeConfig.PanelType panelType) throws IllegalArgumentException {
        return "about:home?panel=" + HomeConfig.getIdForBuiltinPanelType(panelType);
    }
}

