/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import com.googlecode.eyesfree.braille.selfbraille.SelfBrailleClient;
import com.googlecode.eyesfree.braille.selfbraille.WriteData;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.gecko.AppConstants;
import org.mozilla.gecko.GeckoApp;
import org.mozilla.gecko.GeckoAppShell;
import org.mozilla.gecko.GeckoEvent;
import org.mozilla.gecko.gfx.LayerView;
import org.mozilla.gecko.util.ThreadUtils;
import org.mozilla.gecko.util.UIAsyncTask;

public class GeckoAccessibility {
    private static final String LOGTAG = "GeckoAccessibility";
    private static final int VIRTUAL_CURSOR_PREVIOUS = 1;
    private static final int VIRTUAL_CURSOR_POSITION = 2;
    private static final int VIRTUAL_CURSOR_NEXT = 3;
    private static boolean sEnabled;
    private static JSONObject sEventMessage;
    private static AccessibilityNodeInfo sVirtualCursorNode;
    private static final int BRAILLE_CLICK_BASE_INDEX = -275000000;
    private static SelfBrailleClient sSelfBrailleClient;
    private static final HashSet<String> sServiceWhitelist;

    public static void updateAccessibilitySettings(final Context context) {
        new UIAsyncTask.WithoutParams<Void>(ThreadUtils.getBackgroundHandler()){

            public Void doInBackground() {
                JSONObject jSONObject = new JSONObject();
                sEnabled = false;
                AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
                if (accessibilityManager.isEnabled()) {
                    ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                    List list = activityManager.getRunningServices(Integer.MAX_VALUE);
                    for (ActivityManager.RunningServiceInfo runningServiceInfo : list) {
                        sEnabled = sServiceWhitelist.contains(runningServiceInfo.service.getClassName());
                        if (!sEnabled) continue;
                        break;
                    }
                    if (AppConstants.Versions.feature16Plus && sEnabled && sSelfBrailleClient == null) {
                        sSelfBrailleClient = new SelfBrailleClient(GeckoAppShell.getContext(), false);
                    }
                }
                try {
                    jSONObject.put("enabled", sEnabled);
                }
                catch (Exception exception) {
                    Log.e((String)GeckoAccessibility.LOGTAG, (String)"Error building JSON arguments for Accessibility:Settings:", (Throwable)exception);
                }
                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:Settings", jSONObject.toString()));
                return null;
            }

            public void onPostExecute(Void void_) {
                boolean bl = false;
                try {
                    bl = context instanceof GeckoApp;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    // empty catch block
                }
                if (bl) {
                    ((GeckoApp)context).setAccessibilityEnabled(sEnabled);
                }
            }
        }.execute();
    }

    private static void populateEventFromJSON(AccessibilityEvent accessibilityEvent, JSONObject jSONObject) {
        JSONArray jSONArray = jSONObject.optJSONArray("text");
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                accessibilityEvent.getText().add(jSONArray.optString(i));
            }
        }
        accessibilityEvent.setContentDescription((CharSequence)jSONObject.optString("description"));
        accessibilityEvent.setEnabled(jSONObject.optBoolean("enabled", true));
        accessibilityEvent.setChecked(jSONObject.optBoolean("checked"));
        accessibilityEvent.setPassword(jSONObject.optBoolean("password"));
        accessibilityEvent.setAddedCount(jSONObject.optInt("addedCount", -1));
        accessibilityEvent.setRemovedCount(jSONObject.optInt("removedCount", -1));
        accessibilityEvent.setFromIndex(jSONObject.optInt("fromIndex", -1));
        accessibilityEvent.setItemCount(jSONObject.optInt("itemCount", -1));
        accessibilityEvent.setCurrentItemIndex(jSONObject.optInt("currentItemIndex", -1));
        accessibilityEvent.setBeforeText((CharSequence)jSONObject.optString("beforeText"));
        if (AppConstants.Versions.feature14Plus) {
            accessibilityEvent.setToIndex(jSONObject.optInt("toIndex", -1));
            accessibilityEvent.setScrollable(jSONObject.optBoolean("scrollable"));
            accessibilityEvent.setScrollX(jSONObject.optInt("scrollX", -1));
            accessibilityEvent.setScrollY(jSONObject.optInt("scrollY", -1));
        }
        if (AppConstants.Versions.feature15Plus) {
            accessibilityEvent.setMaxScrollX(jSONObject.optInt("maxScrollX", -1));
            accessibilityEvent.setMaxScrollY(jSONObject.optInt("maxScrollY", -1));
        }
    }

    private static void sendDirectAccessibilityEvent(int n, JSONObject jSONObject) {
        AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n);
        accessibilityEvent.setClassName((CharSequence)GeckoAccessibility.class.getName());
        accessibilityEvent.setPackageName((CharSequence)GeckoAppShell.getContext().getPackageName());
        GeckoAccessibility.populateEventFromJSON(accessibilityEvent, jSONObject);
        AccessibilityManager accessibilityManager = (AccessibilityManager)GeckoAppShell.getContext().getSystemService("accessibility");
        try {
            accessibilityManager.sendAccessibilityEvent(accessibilityEvent);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static void sendAccessibilityEvent(final JSONObject jSONObject) {
        if (!sEnabled) {
            return;
        }
        final int n = jSONObject.optInt("eventType", -1);
        if (n < 0) {
            Log.e((String)LOGTAG, (String)"No accessibility event type provided");
            return;
        }
        if (AppConstants.Versions.preJB) {
            ThreadUtils.postToBackgroundThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeckoAccessibility.sendDirectAccessibilityEvent(n, jSONObject);
                }
            });
        } else {
            JSONObject jSONObject2;
            final LayerView layerView = GeckoAppShell.getLayerView();
            if (layerView == null) {
                return;
            }
            if (sVirtualCursorNode == null) {
                sVirtualCursorNode = AccessibilityNodeInfo.obtain((View)layerView, (int)2);
            }
            sVirtualCursorNode.setEnabled(jSONObject.optBoolean("enabled", true));
            sVirtualCursorNode.setClickable(jSONObject.optBoolean("clickable"));
            sVirtualCursorNode.setCheckable(jSONObject.optBoolean("checkable"));
            sVirtualCursorNode.setChecked(jSONObject.optBoolean("checked"));
            sVirtualCursorNode.setPassword(jSONObject.optBoolean("password"));
            JSONArray jSONArray = jSONObject.optJSONArray("text");
            StringBuilder stringBuilder = new StringBuilder();
            if (jSONArray != null && jSONArray.length() > 0) {
                stringBuilder.append(jSONArray.optString(0));
                for (int i = 1; i < jSONArray.length(); ++i) {
                    stringBuilder.append(" ").append(jSONArray.optString(i));
                }
            }
            sVirtualCursorNode.setText((CharSequence)stringBuilder.toString());
            sVirtualCursorNode.setContentDescription((CharSequence)jSONObject.optString("description"));
            JSONObject jSONObject3 = jSONObject.optJSONObject("bounds");
            if (jSONObject3 != null) {
                jSONObject2 = new Rect(jSONObject3.optInt("left"), jSONObject3.optInt("top"), jSONObject3.optInt("right"), jSONObject3.optInt("bottom"));
                sVirtualCursorNode.setBoundsInParent((Rect)jSONObject2);
                int[] nArray = new int[2];
                layerView.getLocationOnScreen(nArray);
                Rect rect = new Rect((Rect)jSONObject2);
                rect.offset(nArray[0], nArray[1]);
                sVirtualCursorNode.setBoundsInScreen(rect);
            }
            if ((jSONObject2 = jSONObject.optJSONObject("brailleOutput")) != null) {
                GeckoAccessibility.sendBrailleText((View)layerView, jSONObject2.optString("text"), jSONObject2.optInt("selectionStart"), jSONObject2.optInt("selectionEnd"));
            }
            ThreadUtils.postToUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    switch (n) {
                        case 32768: {
                            sEventMessage = jSONObject;
                            layerView.performAccessibilityAction(64, null);
                            break;
                        }
                        case 4096: 
                        case 16384: {
                            sEventMessage = null;
                            AccessibilityEvent accessibilityEvent = AccessibilityEvent.obtain((int)n);
                            layerView.onInitializeAccessibilityEvent(accessibilityEvent);
                            GeckoAccessibility.populateEventFromJSON(accessibilityEvent, jSONObject);
                            layerView.getParent().requestSendAccessibilityEvent((View)layerView, accessibilityEvent);
                            break;
                        }
                        default: {
                            sEventMessage = jSONObject;
                            layerView.sendAccessibilityEvent(n);
                        }
                    }
                }
            });
        }
    }

    private static void sendBrailleText(View view, String string2, int n, int n2) {
        AccessibilityNodeInfo accessibilityNodeInfo = AccessibilityNodeInfo.obtain((View)view, (int)2);
        WriteData writeData = WriteData.forInfo(accessibilityNodeInfo);
        writeData.setText(string2);
        writeData.setSelectionStart(n);
        writeData.setSelectionEnd(n2);
        sSelfBrailleClient.write(writeData);
    }

    public static void setDelegate(LayerView layerView) {
        if (AppConstants.Versions.feature16Plus) {
            layerView.setAccessibilityDelegate(new GeckoAccessibilityDelegate());
            layerView.setImportantForAccessibility(1);
        }
    }

    public static void setAccessibilityStateChangeListener(final Context context) {
        if (AppConstants.Versions.feature14Plus) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)context.getSystemService("accessibility");
            accessibilityManager.addAccessibilityStateChangeListener(new AccessibilityManager.AccessibilityStateChangeListener(){

                public void onAccessibilityStateChanged(boolean bl) {
                    GeckoAccessibility.updateAccessibilitySettings(context);
                }
            });
        }
    }

    public static void onLayerViewFocusChanged(LayerView layerView, boolean bl) {
        if (sEnabled) {
            GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:Focus", bl ? "true" : "false"));
        }
    }

    static {
        sServiceWhitelist = new HashSet<String>(Arrays.asList("com.google.android.marvin.talkback.TalkBackService", "com.mot.readout.ScreenReader", "info.spielproject.spiel.SpielService", "es.codefactory.android.app.ma.MAAccessibilityService"));
    }

    public static class GeckoAccessibilityDelegate
    extends View.AccessibilityDelegate {
        AccessibilityNodeProvider mAccessibilityNodeProvider;

        public void onPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onPopulateAccessibilityEvent(view, accessibilityEvent);
            if (sEventMessage != null) {
                GeckoAccessibility.populateEventFromJSON(accessibilityEvent, sEventMessage);
                accessibilityEvent.setSource(view, 2);
            }
            if (accessibilityEvent.getEventType() != 128) {
                sEventMessage = null;
            }
        }

        public AccessibilityNodeProvider getAccessibilityNodeProvider(final View view) {
            if (this.mAccessibilityNodeProvider == null) {
                this.mAccessibilityNodeProvider = new AccessibilityNodeProvider(){

                    public AccessibilityNodeInfo createAccessibilityNodeInfo(int n) {
                        AccessibilityNodeInfo accessibilityNodeInfo = n == 2 && sVirtualCursorNode != null ? AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)sVirtualCursorNode) : AccessibilityNodeInfo.obtain((View)view, (int)n);
                        switch (n) {
                            case -1: {
                                GeckoAccessibilityDelegate.this.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfo);
                                accessibilityNodeInfo.addChild(view, 1);
                                accessibilityNodeInfo.addChild(view, 2);
                                accessibilityNodeInfo.addChild(view, 3);
                                break;
                            }
                            default: {
                                accessibilityNodeInfo.setParent(view);
                                accessibilityNodeInfo.setSource(view, n);
                                accessibilityNodeInfo.setVisibleToUser(view.isShown());
                                accessibilityNodeInfo.setPackageName((CharSequence)GeckoAppShell.getContext().getPackageName());
                                accessibilityNodeInfo.setClassName((CharSequence)view.getClass().getName());
                                accessibilityNodeInfo.addAction(128);
                                accessibilityNodeInfo.addAction(64);
                                accessibilityNodeInfo.addAction(16);
                                accessibilityNodeInfo.addAction(32);
                                accessibilityNodeInfo.addAction(512);
                                accessibilityNodeInfo.addAction(256);
                                accessibilityNodeInfo.setMovementGranularities(11);
                            }
                        }
                        return accessibilityNodeInfo;
                    }

                    public boolean performAction(int n, int n2, Bundle bundle) {
                        if (n2 == 64) {
                            switch (n) {
                                case 1: {
                                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:PreviousObject", null));
                                    return true;
                                }
                                case 3: {
                                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:NextObject", null));
                                    return true;
                                }
                            }
                        } else {
                            if (n2 == 16 && n == 2) {
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:ActivateObject", null));
                                return true;
                            }
                            if (n2 == 32 && n == 2) {
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:LongPress", null));
                                return true;
                            }
                            if (n2 == 256 && n == 2) {
                                int n3 = bundle.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT");
                                if (n3 < 0) {
                                    int n4 = -275000000 - n3;
                                    JSONObject jSONObject = new JSONObject();
                                    try {
                                        jSONObject.put("keyIndex", n4);
                                    }
                                    catch (JSONException jSONException) {
                                        return true;
                                    }
                                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:ActivateObject", jSONObject.toString()));
                                } else {
                                    JSONObject jSONObject = new JSONObject();
                                    try {
                                        jSONObject.put("direction", (Object)"Next");
                                        jSONObject.put("granularity", n3);
                                    }
                                    catch (JSONException jSONException) {
                                        return true;
                                    }
                                    GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:MoveByGranularity", jSONObject.toString()));
                                }
                                return true;
                            }
                            if (n2 == 512 && n == 2) {
                                JSONObject jSONObject = new JSONObject();
                                try {
                                    jSONObject.put("direction", (Object)"Previous");
                                    jSONObject.put("granularity", bundle.getInt("ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT"));
                                }
                                catch (JSONException jSONException) {
                                    return true;
                                }
                                GeckoAppShell.sendEventToGecko(GeckoEvent.createBroadcastEvent("Accessibility:MoveByGranularity", jSONObject.toString()));
                                return true;
                            }
                        }
                        return view.performAccessibilityAction(n2, bundle);
                    }
                };
            }
            return this.mAccessibilityNodeProvider;
        }
    }
}

