/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.health;

import android.content.SharedPreferences;
import android.os.SystemClock;
import android.util.Log;
import org.json.JSONException;
import org.json.JSONObject;

public class SessionInformation {
    private static final String LOG_TAG = "GeckoSessInfo";
    public static final String PREFS_SESSION_START = "sessionStart";
    public final long wallStartTime;
    public final long realStartTime;
    private final boolean wasOOM;
    private final boolean wasStopped;
    private volatile long timedGeckoStartup = -1L;
    private volatile long timedJavaStartup = -1L;

    public SessionInformation(long l, long l2) {
        this(l, l2, false, false);
    }

    public SessionInformation(long l, long l2, boolean bl, boolean bl2) {
        this.wallStartTime = l;
        this.realStartTime = l2;
        this.wasOOM = bl;
        this.wasStopped = bl2;
    }

    public static SessionInformation fromSharedPrefs(SharedPreferences sharedPreferences) {
        boolean bl = sharedPreferences.getBoolean("OOMException", false);
        boolean bl2 = sharedPreferences.getBoolean("wasStopped", true);
        long l = sharedPreferences.getLong(PREFS_SESSION_START, 0L);
        long l2 = 0L;
        Log.d((String)LOG_TAG, (String)("Building SessionInformation from prefs: " + l + ", " + l2 + ", " + bl2 + ", " + bl));
        return new SessionInformation(l, l2, bl, bl2);
    }

    public static SessionInformation forRuntimeTransition() {
        long l = System.currentTimeMillis();
        long l2 = SystemClock.elapsedRealtime();
        Log.v((String)LOG_TAG, (String)("Recording runtime session transition: " + l + ", " + l2));
        return new SessionInformation(l, l2, false, true);
    }

    public boolean wasKilled() {
        return this.wasOOM || !this.wasStopped;
    }

    public void recordBegin(SharedPreferences.Editor editor) {
        Log.d((String)LOG_TAG, (String)("Recording start of session: " + this.wallStartTime));
        editor.putLong(PREFS_SESSION_START, this.wallStartTime);
    }

    public void recordCompletion(SharedPreferences.Editor editor) {
        Log.d((String)LOG_TAG, (String)("Recording session done: " + this.wallStartTime));
        editor.remove(PREFS_SESSION_START);
    }

    public JSONObject getCompletionJSON(String string2, long l) throws JSONException {
        long l2 = (l - this.realStartTime) / 1000L;
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("r", (Object)string2);
        jSONObject.put("d", l2);
        if (this.timedGeckoStartup > 0L) {
            jSONObject.put("sg", this.timedGeckoStartup);
        }
        if (this.timedJavaStartup > 0L) {
            jSONObject.put("sj", this.timedJavaStartup);
        }
        return jSONObject;
    }

    public JSONObject getCrashedJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("oom", this.wasOOM ? 1 : 0);
        jSONObject.put("stopped", this.wasStopped ? 1 : 0);
        jSONObject.put("r", (Object)"A");
        return jSONObject;
    }

    public void setTimedGeckoStartup(long l) {
        this.timedGeckoStartup = l;
    }

    public void setTimedJavaStartup(long l) {
        this.timedJavaStartup = l;
    }
}

