/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.menu;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import org.mozilla.gecko.R;

public class MenuPopup
extends PopupWindow {
    private final LinearLayout mPanel;
    private final int mYOffset;
    private final int mPopupWidth;
    private final int mPopupMinHeight;

    public MenuPopup(Context context) {
        super(context);
        this.setFocusable(true);
        this.mYOffset = context.getResources().getDimensionPixelSize(R.dimen.menu_popup_offset);
        this.mPopupWidth = context.getResources().getDimensionPixelSize(R.dimen.menu_popup_width);
        this.mPopupMinHeight = context.getResources().getDimensionPixelSize(R.dimen.menu_item_row_height);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.setWindowLayoutMode(-2, -2);
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.mPanel = (LinearLayout)layoutInflater.inflate(R.layout.menu_popup, null);
        this.setContentView((View)this.mPanel);
        this.setAnimationStyle(R.style.PopupAnimation);
    }

    public void setPanelView(View view) {
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(this.mPopupWidth, -2));
        this.mPanel.removeAllViews();
        this.mPanel.addView(view);
    }

    public void showAsDropDown(View view) {
        this.setHeight(this.mPopupMinHeight);
        int n = view.getWidth() / 2 - this.mPopupWidth / 2;
        this.showAsDropDown(view, n, -this.mYOffset);
    }
}

