/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.text.Layout;
import android.util.AttributeSet;
import org.mozilla.gecko.R;
import org.mozilla.gecko.widget.ThemedTextView;

public class FadedTextView
extends ThemedTextView {
    private final int mFadeWidth;
    private FadedTextGradient mTextGradient;

    public FadedTextView(Context context) {
        this(context, null);
    }

    public FadedTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setSingleLine(true);
        this.setEllipsize(null);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.FadedTextView);
        this.mFadeWidth = typedArray.getDimensionPixelSize(R.styleable.FadedTextView_fadeWidth, 0);
        typedArray.recycle();
    }

    private int getAvailableWidth() {
        return this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
    }

    private boolean needsEllipsis() {
        int n = this.getAvailableWidth();
        if (n <= 0) {
            return false;
        }
        Layout layout2 = this.getLayout();
        return layout2 != null && layout2.getLineWidth(0) > (float)n;
    }

    private void updateGradientShader() {
        int n = this.getCurrentTextColor();
        int n2 = this.getAvailableWidth();
        boolean bl = this.mTextGradient == null || this.mTextGradient.getColor() != n || this.mTextGradient.getWidth() != n2;
        boolean bl2 = this.needsEllipsis();
        if (bl2 && bl) {
            this.mTextGradient = new FadedTextGradient(n2, this.mFadeWidth, n);
        }
        this.getPaint().setShader((Shader)(bl2 ? this.mTextGradient : null));
    }

    public void onDraw(Canvas canvas) {
        this.updateGradientShader();
        super.onDraw(canvas);
    }

    private static class FadedTextGradient
    extends LinearGradient {
        private final int mWidth;
        private final int mColor;

        public FadedTextGradient(int n, int n2, int n3) {
            super(0.0f, 0.0f, (float)n, 0.0f, new int[]{n3, n3, 0}, new float[]{0.0f, (float)(n - n2) / (float)n, 1.0f}, Shader.TileMode.CLAMP);
            this.mWidth = n;
            this.mColor = n3;
        }

        public int getWidth() {
            return this.mWidth;
        }

        public int getColor() {
            return this.mColor;
        }
    }
}

