/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.gecko.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.view.ViewConfiguration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class HardwareUtils {
    private static final String LOGTAG = "GeckoHardwareUtils";
    private static final int LOW_MEMORY_THRESHOLD_MB = 384;
    private static final int MEMINFO_BUFFER_SIZE_BYTES = 256;
    private static final boolean IS_AMAZON_DEVICE = Build.MANUFACTURER.equalsIgnoreCase("Amazon");
    public static final boolean IS_KINDLE_DEVICE = IS_AMAZON_DEVICE && (Build.MODEL.equals("Kindle Fire") || Build.MODEL.startsWith("KF"));
    private static volatile int sTotalRAM = -1;
    private static volatile boolean sInited;
    private static volatile boolean sIsLargeTablet;
    private static volatile boolean sIsSmallTablet;
    private static volatile boolean sIsTelevision;
    private static volatile boolean sHasMenuButton;

    private HardwareUtils() {
    }

    public static void init(Context context) {
        if (sInited) {
            Log.d((String)LOGTAG, (String)"HardwareUtils already inited.");
            return;
        }
        int n = context.getResources().getConfiguration().screenLayout & 0xF;
        if (Build.VERSION.SDK_INT >= 11) {
            sHasMenuButton = false;
            if (n == 4) {
                sIsLargeTablet = true;
            } else if (n == 3) {
                sIsSmallTablet = true;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                sHasMenuButton = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
                if (Build.VERSION.SDK_INT >= 16 && context.getPackageManager().hasSystemFeature("android.hardware.type.television")) {
                    sIsTelevision = true;
                }
            }
        } else {
            sHasMenuButton = true;
        }
        sInited = true;
    }

    public static boolean isTablet() {
        return sIsLargeTablet || sIsSmallTablet;
    }

    public static boolean isLargeTablet() {
        return sIsLargeTablet;
    }

    public static boolean isSmallTablet() {
        return sIsSmallTablet;
    }

    public static boolean isTelevision() {
        return sIsTelevision;
    }

    public static boolean hasMenuButton() {
        return sHasMenuButton;
    }

    private static boolean matchMemText(byte[] byArray, int n, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        if (n + n3 >= n2) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static int extractMemValue(byte[] byArray, int n, int n2) {
        if (n >= n2) {
            return 0;
        }
        while (n < n2 && byArray[n] != 10) {
            if (byArray[n] >= 48 && byArray[n] <= 57) {
                int n3 = n++;
                while (n < n2 && byArray[n] >= 48 && byArray[n] <= 57) {
                    ++n;
                }
                return Integer.parseInt(new String(byArray, n3, n - n3), 10);
            }
            ++n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getMemSize() {
        if (sTotalRAM >= 0) {
            return sTotalRAM;
        }
        byte[] byArray = new byte[]{77, 101, 109, 84, 111, 116, 97, 108};
        try {
            byte[] byArray2 = new byte[256];
            try (FileInputStream fileInputStream = new FileInputStream("/proc/meminfo");){
                int n = fileInputStream.read(byArray2);
                for (int i = 0; i < n; ++i) {
                    if (!HardwareUtils.matchMemText(byArray2, i, n, byArray)) continue;
                    sTotalRAM = HardwareUtils.extractMemValue(byArray2, i += 8, n) / 1024;
                    Log.d((String)LOGTAG, (String)("System memory: " + sTotalRAM + "MB."));
                    int n2 = sTotalRAM;
                    return n2;
                }
            }
            Log.w((String)LOGTAG, (String)"Did not find MemTotal line in /proc/meminfo.");
            sTotalRAM = 0;
            return 0;
        }
        catch (FileNotFoundException fileNotFoundException) {
            sTotalRAM = 0;
            return 0;
        }
        catch (IOException iOException) {
            sTotalRAM = 0;
            return 0;
        }
    }

    public static boolean isLowMemoryPlatform() {
        int n = HardwareUtils.getMemSize();
        if (n == 0) {
            Log.w((String)LOGTAG, (String)"Could not compute system memory. Falling back to isLowMemoryPlatform = false.");
            return false;
        }
        return n < 384;
    }
}

