var Cc = Components.classes;
var Ci = Components.interfaces;

ChromeUtils.import("resource://gre/modules/NetUtil.jsm");
ChromeUtils.import("resource://gre/modules/Services.jsm");

function inChildProcess() {
  return Cc["@mozilla.org/xre/app-info;1"]
           .getService(Ci.nsIXULRuntime)
           .processType != Ci.nsIXULRuntime.PROCESS_TYPE_DEFAULT;
}

function run_test() {
  // Allow all cookies if the pref service is available in this process.
  if (!inChildProcess())
    Services.prefs.setIntPref("network.cookie.cookieBehavior", 0);

  let cs = Cc["@mozilla.org/cookieService;1"].getService(Ci.nsICookieService);

  let uri = NetUtil.newURI("http://example.org/");

  let set = "foo=b;max-age=3600, c=d;path=/";
  cs.setCookieStringFromHttp(uri, null, null, set, null, null);

  let expected = "foo=b";
  let actual = cs.getCookieStringFromHttp(uri, null, null);
  Assert.equal(actual, expected);
}

