/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/
 */

ChromeUtils.import("resource://testing-common/httpd.js");
var gServer = new HttpServer();
gServer.start(-1);

const PREF_GETADDONS_CACHE_ENABLED       = "extensions.getAddons.cache.enabled";

const PORT          = gServer.identity.primaryPort;
const BASE_URL      = "http://localhost:" + PORT;

var addon = {
  id: "addon@tests.mozilla.org",
  version: "1.0",
  name: "Test",
  targetApplications: [{
    id: "xpcshell@tests.mozilla.org",
    minVersion: "1",
    maxVersion: "1"
  }]
};

const profileDir = gProfD.clone();
profileDir.append("extensions");

function backgroundUpdate(aCallback) {
  Services.obs.addObserver(function observer() {
    Services.obs.removeObserver(observer, "addons-background-update-complete");
    aCallback();
  }, "addons-background-update-complete");

  AddonManagerPrivate.backgroundUpdateCheck();
}

function run_test() {
  do_test_pending();

  mapUrlToFile("/cache.xml", do_get_file("data/test_sourceURI.xml"), gServer);
  Services.prefs.setCharPref(PREF_GETADDONS_BYIDS, BASE_URL + "/cache.xml");
  Services.prefs.setCharPref(PREF_GETADDONS_BYIDS_PERFORMANCE, BASE_URL + "/cache.xml");
  Services.prefs.setBoolPref(PREF_GETADDONS_CACHE_ENABLED, true);

  createAppInfo("xpcshell@tests.mozilla.org", "XPCShell", "1", "1");
  writeInstallRDFForExtension(addon, profileDir);
  startupManager();

  AddonManager.getAddonByID("addon@tests.mozilla.org", function(a) {
    Assert.notEqual(a, null);
    Assert.equal(a.sourceURI, null);

    backgroundUpdate(function() {
      restartManager();

      AddonManager.getAddonByID("addon@tests.mozilla.org", function(a2) {
        Assert.notEqual(a2, null);
        Assert.notEqual(a2.sourceURI, null);
        Assert.equal(a2.sourceURI.spec, "http://www.example.com/testaddon.xpi");

        do_test_finished();
      });
    });
  });
}
