// Copyright (C) 2015 the V8 project authors. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.
/*---
es6id: 9.5.9
description: >
    [[Set]] ( P, V, Receiver)

    3. If handler is null, throw a TypeError exception.
---*/

var p = Proxy.revocable({}, {});

p.revoke();

assert.throws(TypeError, function() {
  p.proxy.attr = 1;
});

assert.throws(TypeError, function() {
  p.proxy['attr'] = 1;
});

reportCompare(0, 0);
