# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

import string

def generate(output, template, dataFile):
    with open(template, "r") as f:
        template = string.Template(f.read())
    with open(dataFile, "r") as f:
        data = eval(f.read())

    longhand_count = 0
    shorthand_count = 0
    alias_count = 0
    property_ids = []
    for name, method, id, flags, pref, prototype in data:
        if prototype != "alias":
            if prototype == "longhand":
                assert shorthand_count == 0
                longhand_count += 1
            else:
                assert alias_count == 0
                shorthand_count += 1
            property_ids.append("eCSSProperty_{}".format(id))
        else:
            alias_count += 1
            property_ids.append("eCSSPropertyAlias_{}".format(id[0]))

    output.write("/* THIS IS AN AUTOGENERATED FILE.  DO NOT EDIT */\n\n")
    output.write(template.substitute({
        "property_ids": "\n".join("  {},".format(p) for p in property_ids),
        "longhand_count": property_ids[longhand_count],
        "shorthand_count": property_ids[longhand_count + shorthand_count],
    }))
