// |reftest| skip -- regexp-unicode-property-escapes is not supported
// Copyright 2017 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script_Extensions=Khmer`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v10.0.0
  Emoji v5.0 (UTR51)
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x001780, 0x0017DD],
    [0x0017E0, 0x0017E9],
    [0x0017F0, 0x0017F9],
    [0x0019E0, 0x0019FF]
  ]
});
testPropertyEscapes(
  /^\p{Script_Extensions=Khmer}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Khmer}"
);
testPropertyEscapes(
  /^\p{Script_Extensions=Khmr}+$/u,
  matchSymbols,
  "\\p{Script_Extensions=Khmr}"
);
testPropertyEscapes(
  /^\p{scx=Khmer}+$/u,
  matchSymbols,
  "\\p{scx=Khmer}"
);
testPropertyEscapes(
  /^\p{scx=Khmr}+$/u,
  matchSymbols,
  "\\p{scx=Khmr}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00177F],
    [0x0017DE, 0x0017DF],
    [0x0017EA, 0x0017EF],
    [0x0017FA, 0x0019DF],
    [0x001A00, 0x00DBFF],
    [0x00E000, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script_Extensions=Khmer}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Khmer}"
);
testPropertyEscapes(
  /^\P{Script_Extensions=Khmr}+$/u,
  nonMatchSymbols,
  "\\P{Script_Extensions=Khmr}"
);
testPropertyEscapes(
  /^\P{scx=Khmer}+$/u,
  nonMatchSymbols,
  "\\P{scx=Khmer}"
);
testPropertyEscapes(
  /^\P{scx=Khmr}+$/u,
  nonMatchSymbols,
  "\\P{scx=Khmr}"
);

reportCompare(0, 0);
