//@line 36 "/cygdrive/c/builds/tinderbox/Fx-Trunk/WINNT_5.0_Depend/mozilla/browser/components/preferences/advanced.js"

var gAdvancedPane = {
  _inited: false,
  init: function ()
  {
    this._inited = true;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    if (preference.value === null)
      return;
    advancedPrefs.selectedIndex = preference.value;
  },
  
  tabSelectionChanged: function ()
  {
    if (!this._inited)
      return;
    var advancedPrefs = document.getElementById("advancedPrefs");
    var preference = document.getElementById("browser.preferences.advanced.selectedTabIndex");
    preference.valueFromPreferences = advancedPrefs.selectedIndex;
  },
  
  updateButtons: function (aButtonID, aPreferenceID)
  {
    var button = document.getElementById(aButtonID);
    var preference = document.getElementById(aPreferenceID);
    // This is actually before the value changes, so the value is not as you expect. 
    button.disabled = preference.value == true;
    return undefined;
  },

  showCertificates: function ()
  {
    document.documentElement.openWindow("mozilla:certmanager",
                                        "chrome://pippki/content/certManager.xul",
                                        "width=600,height=400", null);
  },
  
  showCRLs: function ()
  {
    document.documentElement.openWindow("Mozilla:CRLManager", 
                                        "chrome://pippki/content/crlManager.xul",
                                        "width=600,height=400", null);
  },
  
  showOCSP: function ()
  {
    document.documentElement.openSubDialog("chrome://mozapps/content/preferences/ocsp.xul",
                                           "", null);
  },
  
  showSecurityDevices: function ()
  {
    document.documentElement.openWindow("mozilla:devicemanager",
                                        "chrome://pippki/content/device_manager.xul",
                                        "width=600,height=400", null);
  },
  
  updateAppUpdateUI: function ()
  {
    var preference = document.getElementById("app.update.autoUpdateEnabled");
    var ids = ["enableAutoInstall", "autoInstallMode", "updateAnd"];
    if (!preference.value)
      for (var i = 0; i < ids.length; ++i)
        document.getElementById(ids[i]).disabled = true;
    else {
      document.getElementById("enableAutoInstall").disabled = false;
      this.updateAutoInstallUI();
    }
    return undefined;
  },
  
  updateAutoInstallUI: function ()
  {
    var preference = document.getElementById("app.update.autoInstallEnabled");
    var ids = ["autoInstallMode", "updateAnd"];
    for (var i = 0; i < ids.length; ++i)
      document.getElementById(ids[i]).disabled = !preference.value;
    return undefined;
  },
  
  checkForUpdates: function (aType)
  {
    var updates = Components.classes["@mozilla.org/updates/update-service;1"]
                            .getService(Components.interfaces.nsIUpdateService);
    updates.checkForUpdates([], 0, aType, 
                            Components.interfaces.nsIUpdateService.SOURCE_EVENT_USER,
                            null);  
  },
  
  showLanguages: function ()
  {
    document.documentElement.openSubDialog("chrome://browser/content/preferences/languages.xul",
                                           "", null);  
  }
};

