

var _elementIDs = ["moveSystemCaret", "hideTabBar", "loadInBackground",
                    "loadBookmarksInBackground", "warnOnClose", "useAutoScrolling",
                    "useSmoothScrolling", "enableAutoImageResizing",
                    "useSSL2", "useSSL3", "useTLS1", "useTypeAheadFind",
                    "certSelection", "securityOCSPEnabled", "serviceURL", "signingCA",
                    "tabbedExternalLinks", "tabbedWindowLinks",
                    "enableSoftwareInstall", "enableSmartUpdate", 
                    "enableExtensionUpdate"];

const nsIX509CertDB = Components.interfaces.nsIX509CertDB;
const nsX509CertDB = "@mozilla.org/security/x509certdb;1";
const nsIOCSPResponder = Components.interfaces.nsIOCSPResponder;
const nsISupportsArray = Components.interfaces.nsISupportsArray;

var certdb;
var ocspResponders;

function onOK()
{
  // the .ui pref is only the saved state of the prefs dialog's radio buttons.
  // the other pref is the real one.
  try {
    var prefVal = document.getElementById("tabbedOpenForce").checked ?
                    document.getElementById("tabbedWindowLinks").value : 2;
    parent.hPrefWindow.setPref("int", "browser.link.open_newwindow", prefVal);
  } catch(e) {
    // never loaded |advanced| pane
  }
}

function Startup() {
  var prefVal = parent.hPrefWindow.getPref("int", "browser.link.open_newwindow",
                                           false);
  document.getElementById("tabbedOpenForce").checked = prefVal != 2;
  updateWindowLinksBehavior();
  parent.hPrefWindow.registerOKCallbackFunc(onOK);

  // XXXben - Hide Single Window mode prefs for 1.0 to avoid crashes see 266759
  if (parent.hPrefWindow.getPref("bool", "browser.tabs.showSingleWindowModePrefs", false)) {
    document.getElementById("tabbedOpenForce").hidden = false;
    document.getElementById("tabbedWindowLinks").hidden = false;
  }

  var ocspEntry;
  var i;

  certdb = Components.classes[nsX509CertDB].getService(nsIX509CertDB);
  ocspResponders = certdb.getOCSPResponders();

  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  for (i=0; i<ocspResponders.length; i++) {
    ocspEntry = ocspResponders.queryElementAt(i, nsIOCSPResponder);
    var menuItemNode = document.createElement("menuitem");
    menuItemNode.setAttribute("value", ocspEntry.responseSigner);
    menuItemNode.setAttribute("label", ocspEntry.responseSigner);
    signersMenu.firstChild.appendChild(menuItemNode);
  }

  doSecurityEnabling();
  
  // XXXben menulists suck, see explanation in pref-privacy.js
  // style resolution problem inside scrollable areas. 
  var scb = document.getElementById("signingCABox");
  var sca = document.getElementById("signingCA");
  sca.removeAttribute("hidden");
  sca.parentNode.removeChild(sca);
  scb.appendChild(sca);
}

function doSecurityEnabling()
{
  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  var radiogroup = document.getElementById("securityOCSPEnabled");
  
  switch ( radiogroup.value ) {
  case "0":
  case "1":
    signersMenu.setAttribute("disabled", true);
    signersURL.setAttribute("disabled", true);
    break;
  case "2":
  default:
    if (!parent.hPrefWindow.getPrefIsLocked("security.OCSP.signingCA"))
      signersMenu.removeAttribute("disabled");
    if (!parent.hPrefWindow.getPrefIsLocked("security.OCSP.URL"))
      signersURL.removeAttribute("disabled");
  }
}

function changeURL()
{
  var signersMenu = document.getElementById("signingCA");
  var signersURL = document.getElementById("serviceURL");
  var CA = signersMenu.getAttribute("value");
  var i;
  var ocspEntry;

  for (i=0; i < ocspResponders.length; i++) {
    ocspEntry = ocspResponders.queryElementAt(i, nsIOCSPResponder);
    if (CA == ocspEntry.responseSigner) {
      signersURL.setAttribute("value", ocspEntry.serviceURL);
      break;
    }
  }
}

function openCrlManager()
{
    window.open('chrome://pippki/content/crlManager.xul',  "",
                'chrome,width=500,height=400,resizable=1');
}

function openCertManager()
{
  //check for an existing certManager window and focus it; it's not application modal
  const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
  const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
  const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
  var lastCertManager = kWindowMediator.getMostRecentWindow("mozilla:certmanager");
  if (lastCertManager)
    lastCertManager.focus();
  else {
    window.open('chrome://pippki/content/certManager.xul',  "",
                'chrome,centerscreen,resizable=yes,dialog=no');
  }
}

function openDeviceManager()
{
  //check for an existing deviceManger window and focus it; it's not application modal
  const kWindowMediatorContractID = "@mozilla.org/appshell/window-mediator;1";
  const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
  const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
  var lastCertManager = kWindowMediator.getMostRecentWindow("mozilla:devicemanager");
  if (lastCertManager)
    lastCertManager.focus();
  else {
    window.open('chrome://pippki/content/device_manager.xul',  "devmgr",
                'chrome,centerscreen,resizable=yes,dialog=no');
  }
}

function updateWindowLinksBehavior() {
  var radioNodes = document.getElementById("tabbedWindowLinks").childNodes;
  var ctr;
  if (document.getElementById("tabbedOpenForce").checked)
    for (ctr = 0; ctr < radioNodes.length; ++ctr)
      radioNodes.item(ctr).removeAttribute("disabled");
  else
    for (ctr = 0; ctr < radioNodes.length; ++ctr)
      radioNodes.item(ctr).setAttribute("disabled", "true");
}

function checkForUpdates()
{
  var updates = Components.classes["@mozilla.org/updates/update-service;1"]
                          .getService(Components.interfaces.nsIUpdateService);
  updates.checkForUpdates([], 0, Components.interfaces.nsIUpdateItem.TYPE_ANY, 
                          Components.interfaces.nsIUpdateService.SOURCE_EVENT_USER,
                          window);
}

