/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Graphics;
import java.awt.Rectangle;
import netscape.application.Event;
import netscape.application.Rect;

class ApplicationEvent
extends Event {
    static final int GOT_FOCUS = -21;
    static final int LOST_FOCUS = -22;
    static final int UPDATE = -23;
    static final int RESIZE = -24;
    static final int STOP = -25;
    static final int APPLET_STOPPED = -26;
    static final int APPLET_STARTED = -27;
    static final int PRINT = -28;
    Object data;

    static ApplicationEvent newResizeEvent(int width, int height) {
        ApplicationEvent event = new ApplicationEvent();
        event.type = -24;
        event.data = new Rect(0, 0, width, height);
        return event;
    }

    static ApplicationEvent newUpdateEvent(Graphics g) {
        ApplicationEvent event = new ApplicationEvent();
        Rectangle r = g.getClipRect();
        event.type = -23;
        event.data = r == null ? new Rect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE) : new Rect(r.x, r.y, r.width, r.height);
        return event;
    }

    static ApplicationEvent newFocusEvent(boolean gotFocus) {
        ApplicationEvent event = new ApplicationEvent();
        event.type = gotFocus ? -21 : -22;
        return event;
    }

    static ApplicationEvent newPrintEvent(Graphics g) {
        ApplicationEvent event = new ApplicationEvent();
        event.type = -28;
        event.data = g;
        return event;
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case -21: {
                typeString = "GotFocus";
                break;
            }
            case -22: {
                typeString = "LostFocus";
                break;
            }
            case -23: {
                typeString = "Update";
                break;
            }
            case -24: {
                typeString = "Resize";
                break;
            }
            case -25: {
                typeString = "Stop";
                break;
            }
            case -26: {
                typeString = "AppletStopped";
                break;
            }
            case -27: {
                typeString = "AppletStarted";
                break;
            }
            case -28: {
                typeString = "Print";
                break;
            }
            default: {
                typeString = "Unknown Type";
            }
        }
        return "ApplicationEvent: " + typeString;
    }

    Rect rect() {
        return (Rect)this.data;
    }

    Graphics graphics() {
        return (Graphics)this.data;
    }

    ApplicationEvent() {
    }
}

