/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Deserializer;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;

public class HTMLParsingRules
implements Codable {
    private Hashtable rules = (Hashtable)Deserializer.deserializeObject("{  LI = { BeginTermination = ( LI ); EndTermination = (OL,UL,DIR,MENU); };     IMG= { IsContainer=false; };                                       DD = { BeginTermination = (DT,DD); EndTermination = (DL,A); };       DT = { BeginTermination = (DT,DD); EndTermination = (DL,A); };        P = { IsContainer=true; BeginTermination=(P,OL,UL,DIR,MENU,PRE,H1,H2,H3,H4,H5,H6);  };   BR = { IsContainer=false; };                                       HR = { IsContainer=false; };                                       PRE= { ShouldRetainFormatting=true; };                                  A= { IsContainer=true; BeginTermination = (A); };              }");
    private String defaultContainerClassName;
    private String defaultMarkerClassName;
    static final String RULES_KEY = "rules";
    static final String DEFAULT_CONTAINER_CLASS_NAME_KEY = "defaultContainerClass";
    static final String DEFAULT_MARKER_CLASS_NAME_KEY = "defaultMarkerClass";
    private static final String HTMLDefaultRules = "{  LI = { BeginTermination = ( LI ); EndTermination = (OL,UL,DIR,MENU); };     IMG= { IsContainer=false; };                                       DD = { BeginTermination = (DT,DD); EndTermination = (DL,A); };       DT = { BeginTermination = (DT,DD); EndTermination = (DL,A); };        P = { IsContainer=true; BeginTermination=(P,OL,UL,DIR,MENU,PRE,H1,H2,H3,H4,H5,H6);  };   BR = { IsContainer=false; };                                       HR = { IsContainer=false; };                                       PRE= { ShouldRetainFormatting=true; };                                  A= { IsContainer=true; BeginTermination = (A); };              }";
    public static final String STRING_MARKER_KEY = "IFCSTRING";
    public static final String COMMENT_MARKER_KEY = "IFCCOMMENT";
    public static final String REPRESENTATION_KEY = "Representation";
    public static final String BEGIN_TERMINATION_MARKERS_KEY = "BeginTermination";
    public static final String END_TERMINATION_MARKERS_KEY = "EndTermination";
    public static final String IS_CONTAINER_KEY = "IsContainer";
    public static final String SHOULD_RETAIN_FORMATTING_KEY = "ShouldRetainFormatting";
    public static final String SHOULD_IGNORE_END_KEY = "ShouldIgnoreEnd";

    public HTMLParsingRules() {
        if (this.rules == null) {
            throw new InconsistencyException("HTMLParsingRules: Cannot deserialize default rules");
        }
    }

    public void setRulesForMarker(Hashtable markerRules, String marker) {
        this.rules.put(marker, markerRules);
    }

    public Hashtable rulesForMarker(String aMarker) {
        return (Hashtable)this.rules.get(aMarker);
    }

    public void setRuleForMarker(String rule, Object value, String marker) {
        Hashtable h = this.rulesForMarker(marker);
        if (h == null) {
            h = new Hashtable();
        }
        h.put(rule, value);
        this.setRulesForMarker(h, marker);
    }

    public void setClassNameForMarker(String className, String aMarker) {
        Hashtable r = this.rulesForMarker(aMarker);
        if (r == null) {
            r = new Hashtable();
        }
        r.put(REPRESENTATION_KEY, className);
        this.setRulesForMarker(r, aMarker);
    }

    public String classNameForMarker(String aMarker) {
        Hashtable r = this.rulesForMarker(aMarker);
        if (r != null) {
            String result = (String)r.get(REPRESENTATION_KEY);
            if (result == null) {
                result = this.isContainer(r) ? this.defaultContainerClassName : this.defaultMarkerClassName;
            }
            return result;
        }
        Hashtable markerRules = this.rulesForMarker(aMarker);
        boolean isContainer = markerRules != null ? this.isContainer(markerRules) : true;
        if (isContainer && this.defaultContainerClassName != null) {
            return this.defaultContainerClassName;
        }
        if (!isContainer && this.defaultMarkerClassName != null) {
            return this.defaultMarkerClassName;
        }
        return null;
    }

    public void setDefaultContainerClassName(String aClassName) {
        this.defaultContainerClassName = aClassName;
    }

    public String defaultContainerClassName() {
        return this.defaultContainerClassName;
    }

    public void setDefaultMarkerClassName(String aClassName) {
        this.defaultMarkerClassName = aClassName;
    }

    public String defaultMarkerClassName() {
        return this.defaultMarkerClassName;
    }

    public void setStringClassName(String className) {
        this.setClassNameForMarker(className, STRING_MARKER_KEY);
    }

    public String classNameForString() {
        return this.classNameForMarker(STRING_MARKER_KEY);
    }

    public void setClassNameForComment(String className) {
        this.setClassNameForMarker(className, COMMENT_MARKER_KEY);
    }

    public String classNameForComment() {
        return this.classNameForMarker(COMMENT_MARKER_KEY);
    }

    boolean shouldIgnoreEnd(Hashtable markerRules) {
        if (markerRules == null) {
            return false;
        }
        return markerRules.get(SHOULD_IGNORE_END_KEY) != null && ((String)markerRules.get(SHOULD_IGNORE_END_KEY)).toUpperCase().equals("TRUE");
    }

    boolean isContainer(Hashtable markerRules) {
        if (markerRules == null) {
            return true;
        }
        return markerRules.get(IS_CONTAINER_KEY) == null || !((String)markerRules.get(IS_CONTAINER_KEY)).toUpperCase().equals("FALSE");
    }

    boolean shouldFilterStringsForChildren(Hashtable markerRules) {
        if (markerRules == null) {
            return true;
        }
        return markerRules.get(SHOULD_RETAIN_FORMATTING_KEY) == null || !((String)markerRules.get(SHOULD_RETAIN_FORMATTING_KEY)).toUpperCase().equals("TRUE");
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.HTMLParsingRules", 1);
        info.addField(RULES_KEY, (byte)18);
        info.addField(DEFAULT_CONTAINER_CLASS_NAME_KEY, (byte)18);
        info.addField(DEFAULT_MARKER_CLASS_NAME_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(RULES_KEY, this.rules);
        encoder.encodeObject(DEFAULT_CONTAINER_CLASS_NAME_KEY, this.defaultContainerClassName);
        encoder.encodeObject(DEFAULT_MARKER_CLASS_NAME_KEY, this.defaultMarkerClassName);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.rules = (Hashtable)decoder.decodeObject(RULES_KEY);
        this.defaultContainerClassName = (String)decoder.decodeObject(DEFAULT_CONTAINER_CLASS_NAME_KEY);
        this.defaultMarkerClassName = (String)decoder.decodeObject(DEFAULT_MARKER_CLASS_NAME_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

