/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Graphics;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public abstract class Image
implements Codable {
    public static final int CENTERED = 0;
    public static final int SCALED = 1;
    public static final int TILED = 2;
    public static final String IMAGE_TYPE = "netscape.application.Image";

    public static Image imageNamed(String name) {
        Image theImage;
        Class<?> theClass;
        String className = "";
        int slash = name.indexOf(47);
        if (slash == -1) {
            slash = name.indexOf(92);
        }
        if (slash == -1) {
            return null;
        }
        String typeName = name.substring(0, slash);
        try {
            className = "netscape.application." + typeName;
            theClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            theClass = null;
        }
        if (theClass == null) {
            try {
                className = typeName;
                theClass = Class.forName(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                theClass = null;
            }
        }
        if (theClass == null) {
            return null;
        }
        try {
            theImage = (Image)theClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new InconsistencyException("Unable to instantiate class \"" + className + "\" -- " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InconsistencyException("Illegal access to class \"" + className + "\" -- " + e.getMessage());
        }
        return theImage.imageWithName(name.substring(slash + 1));
    }

    public abstract int width();

    public abstract int height();

    public abstract void drawAt(Graphics var1, int var2, int var3);

    public void drawScaled(Graphics g, int x, int y, int width, int height) {
        this.drawCentered(g, x, y, width, height);
    }

    public String name() {
        return null;
    }

    public void drawCentered(Graphics g, int x, int y, int width, int height) {
        this.drawAt(g, x + (width - this.width()) / 2, y + (height - this.height()) / 2);
    }

    public void drawCentered(Graphics g, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawCentered(g, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawScaled(Graphics g, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawScaled(g, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawTiled(Graphics g, int x, int y, int width, int height) {
        Rect clipRect = g.clipRect();
        int imageWidth = this.width();
        int imageHeight = this.height();
        if (imageWidth <= 0 || imageHeight <= 0) {
            return;
        }
        g.pushState();
        g.setClipRect(new Rect(x, y, width, height));
        int minX = x > clipRect.x ? x : x + imageWidth * ((clipRect.x - x) / imageWidth);
        int maxX = x + width < clipRect.maxX() ? x + width : clipRect.maxX();
        int minY = y > clipRect.y ? y : y + imageHeight * ((clipRect.y - y) / imageHeight);
        int maxY = y + height < clipRect.maxY() ? y + height : clipRect.maxY();
        x = minX;
        while (x < maxX) {
            y = minY;
            while (y < maxY) {
                this.drawAt(g, x, y);
                y += imageHeight;
            }
            x += imageWidth;
        }
        g.popState();
    }

    public void drawTiled(Graphics g, Rect rect) {
        if (rect == null) {
            return;
        }
        this.drawTiled(g, rect.x, rect.y, rect.width, rect.height);
    }

    public void drawWithStyle(Graphics g, int x, int y, int width, int height, int style) {
        switch (style) {
            case 0: {
                this.drawCentered(g, x, y, width, height);
                return;
            }
            case 1: {
                this.drawScaled(g, x, y, width, height);
                return;
            }
            case 2: {
                this.drawTiled(g, x, y, width, height);
                return;
            }
        }
        throw new InconsistencyException("Unknown style: " + style);
    }

    public void drawWithStyle(Graphics g, Rect rect, int style) {
        this.drawWithStyle(g, rect.x, rect.y, rect.width, rect.height, style);
    }

    public Image imageWithName(String name) {
        return null;
    }

    public boolean isTransparent() {
        return true;
    }

    public void describeClassInfo(ClassInfo info) {
    }

    public void encode(Encoder encoder) throws CodingException {
    }

    public void decode(Decoder decoder) throws CodingException {
    }

    public void finishDecoding() throws CodingException {
    }
}

