/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.TextAttachment;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class ImageAttachment
extends TextAttachment
implements Codable {
    private Image image;
    boolean incrementalBitmap;
    int width;
    int height;
    static final String IMAGE_KEY = "image";

    public ImageAttachment() {
        this.image = null;
        this.incrementalBitmap = false;
    }

    public ImageAttachment(Image anImage) {
        this.image = anImage;
        this.incrementalBitmap = false;
    }

    ImageAttachment(Bitmap aBitmap, int width, int height) {
        this.image = aBitmap;
        this.width = width;
        this.height = height;
        this.incrementalBitmap = true;
    }

    public void setImage(Image anImage) {
        this.image = anImage;
    }

    public Image image() {
        return this.image;
    }

    public int width() {
        if (this.incrementalBitmap) {
            return this.width;
        }
        if (this.image != null) {
            return this.image.width();
        }
        return 0;
    }

    public int height() {
        if (this.incrementalBitmap) {
            return this.height;
        }
        if (this.image != null) {
            return this.image.height();
        }
        return 0;
    }

    public void drawInRect(Graphics g, Rect boundsRect) {
        if (g == null || boundsRect == null) {
            return;
        }
        Rect clipRect = g.clipRect();
        if (this.image != null) {
            this.image.drawAt(g, boundsRect.x, boundsRect.y);
        }
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ImageAttachment", 1);
        info.addField(IMAGE_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(IMAGE_KEY, this.image);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        this.incrementalBitmap = false;
    }
}

