/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Event;
import netscape.application.RootView;

public class MouseEvent
extends Event {
    public int x;
    public int y;
    int clickCount;
    int modifiers;
    public static final int MOUSE_DOWN = -1;
    public static final int MOUSE_DRAGGED = -2;
    public static final int MOUSE_UP = -3;
    public static final int MOUSE_ENTERED = -4;
    public static final int MOUSE_MOVED = -5;
    public static final int MOUSE_EXITED = -6;

    public MouseEvent() {
    }

    public MouseEvent(long timeStamp, int type, int x, int y, int modifiers) {
        this();
        this.timeStamp = timeStamp;
        if (type < -6 || type > -1) {
            throw new IllegalArgumentException("Invalid MouseEvent type: " + type);
        }
        this.type = type;
        this.x = x;
        this.y = y;
        this.modifiers = modifiers;
    }

    public void setClickCount(int count) {
        this.clickCount = count;
    }

    public int clickCount() {
        return this.clickCount;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int modifiers() {
        return this.modifiers;
    }

    public boolean isShiftKeyDown() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isControlKeyDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaKeyDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isAltKeyDown() {
        return (this.modifiers & 8) != 0;
    }

    public void setRootView(RootView rootView) {
        this.processor = rootView;
    }

    public RootView rootView() {
        return (RootView)this.processor;
    }

    public String toString() {
        String typeString;
        switch (this.type) {
            case -1: {
                typeString = "Down";
                break;
            }
            case -2: {
                typeString = "Dragged";
                break;
            }
            case -3: {
                typeString = "Up";
                break;
            }
            case -4: {
                typeString = "Entered";
                break;
            }
            case -5: {
                typeString = "Moved";
                break;
            }
            case -6: {
                typeString = "Exited";
                break;
            }
            default: {
                typeString = "Unknown Type";
            }
        }
        return "MouseEvent: " + typeString + " at: (" + this.x + "," + this.y + ")" + " modifiers: " + this.modifiers + " clicks: " + this.clickCount;
    }
}

