/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

class ObjectPool {
    Object[] freePool = new Object[1];
    int freePoolMaxLength = 1;
    int freePoolNextSlot = 0;
    Class objectClass;
    int allocSaved;
    int allocDone;
    int maxCapacity;

    public ObjectPool(String className) {
        this(className, 32);
    }

    public ObjectPool(String className, int aMaxCapacity) {
        try {
            this.objectClass = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ObjectPool cannot find class " + className);
        }
        this.allocSaved = 0;
        this.allocDone = 0;
        this.maxCapacity = aMaxCapacity;
    }

    public Object allocateObject() {
        Object result = null;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.freePoolNextSlot > 0) {
                --this.freePoolNextSlot;
                result = this.freePool[this.freePoolNextSlot];
            }
        }
        if (result == null) {
            ++this.allocDone;
            try {
                result = this.objectClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Cannot instantiate instance of class " + this.objectClass);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Cannot instantiate instance of class. Illegal." + this.objectClass);
            }
        } else {
            ++this.allocSaved;
        }
        return result;
    }

    public void recycleObject(Object anObject) {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.freePoolMaxLength < this.maxCapacity) {
                if (this.freePoolNextSlot == this.freePoolMaxLength) {
                    Object[] newFreePool = new Object[this.freePoolMaxLength * 2];
                    System.arraycopy(this.freePool, 0, newFreePool, 0, this.freePoolMaxLength);
                    this.freePool = newFreePool;
                    this.freePoolMaxLength *= 2;
                }
                this.freePool[this.freePoolNextSlot++] = anObject;
            }
            return;
        }
    }

    protected void finalize() {
        int i = 0;
        while (i < this.freePoolNextSlot) {
            this.freePool[i] = null;
            ++i;
        }
        this.freePool = null;
    }

    public String toString() {
        return "Object pool for class " + this.objectClass + " has " + this.freePoolNextSlot + " instances." + " " + this.allocSaved + " allocations avoided allocation performed:" + this.allocDone;
    }
}

