/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Container;
import netscape.application.AWTCompatibility;
import netscape.application.AWTComponentView;
import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Autoscroller;
import netscape.application.Color;
import netscape.application.ColorChooser;
import netscape.application.DragView;
import netscape.application.Event;
import netscape.application.EventProcessor;
import netscape.application.ExtendedTarget;
import netscape.application.ExternalWindow;
import netscape.application.Font;
import netscape.application.FontChooser;
import netscape.application.FoundationDialog;
import netscape.application.FoundationFrame;
import netscape.application.FoundationPanel;
import netscape.application.FoundationWindow;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.KeyStroke;
import netscape.application.KeyboardArrow;
import netscape.application.MenuItem;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.MouseFilter;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.ResizeFilter;
import netscape.application.Timer;
import netscape.application.UpdateFilter;
import netscape.application.VectorCache;
import netscape.application.View;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class RootView
extends View
implements EventProcessor,
ExtendedTarget {
    Color _backgroundColor;
    Image _image;
    FoundationPanel panel;
    Application application;
    Timer _autoscrollTimer;
    ColorChooser colorChooser;
    FontChooser fontChooser;
    InternalWindow _mainWindow;
    View _mouseView;
    View _moveView;
    View _focusedView;
    View _windowClipView;
    View _mouseClickView;
    View _rootViewFocusedView;
    View _selectedView;
    View _defaultSelectedView;
    Vector windows = new Vector();
    long _lastClickTime;
    int _clickCount;
    int _mouseX;
    int _mouseY;
    int _currentCursor;
    int _viewCursor;
    int _overrideCursor = -1;
    int mouseDownCount;
    int _imageDisplayStyle;
    Vector dirtyViews = new Vector();
    boolean _redrawTransWindows = true;
    boolean recomputeCursor;
    boolean recomputeMoveView;
    boolean isVisible;
    boolean redrawAll = true;
    Vector componentViews;
    MouseFilter mouseFilter = new MouseFilter();
    static Vector _commands = new Vector();
    static final String VALIDATE_SELECTED_VIEW = "validateSelectedView";

    public RootView() {
        this(0, 0, 0, 0);
    }

    public RootView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public RootView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this._backgroundColor = Color.gray;
        this.application = Application.application();
        this._defaultSelectedView = this;
    }

    void addWindowRelativeTo(InternalWindow aWindow, int position, InternalWindow otherWindow) {
        if (aWindow == null) {
            return;
        }
        if (this._windowClipView != null && aWindow.layer() < 500) {
            this._windowClipView.addSubview(aWindow);
        } else {
            this.addSubview(aWindow);
        }
        this.makeWindowVisible(aWindow, position, otherWindow);
    }

    void removeWindow(InternalWindow aWindow) {
        if (aWindow == null) {
            return;
        }
        Rect windowBounds = this.absoluteWindowBounds(aWindow);
        aWindow.removeFromSuperview();
        int index = this.windows.indexOf(aWindow) - 1;
        if (index < 0) {
            index = this.windows.indexOf(aWindow);
        }
        this.windows.removeElement(aWindow);
        if (aWindow == this._mainWindow) {
            InternalWindow theWindow = null;
            index = this.windows.count() - 1;
            while (index >= 0) {
                if (((InternalWindow)this.windows.elementAt(index)).canBecomeMain()) {
                    theWindow = (InternalWindow)this.windows.elementAt(index);
                    break;
                }
                --index;
            }
            this._setMainWindow(theWindow);
        }
        this.redraw(windowBounds);
        this.redrawTransparentWindows(windowBounds, null);
        if (!(aWindow instanceof KeyboardArrow)) {
            this.validateSelectedView();
        }
        this.createMouseEnterLater();
    }

    public Vector internalWindows() {
        return this.windows;
    }

    public InternalWindow mainWindow() {
        return this._mainWindow;
    }

    void _setMainWindow(InternalWindow newMain) {
        if (this._mainWindow == newMain || newMain != null && !newMain.canBecomeMain()) {
            return;
        }
        InternalWindow oldMain = this._mainWindow;
        this._mainWindow = newMain;
        if (oldMain != null) {
            oldMain.didResignMain();
        } else if (this._focusedView != null && !this.isInWindow(this._focusedView)) {
            this._rootViewFocusedView = this._focusedView;
            this.setFocusedView(null, false);
        }
        if (this._mainWindow != null) {
            this._mainWindow.didBecomeMain();
        } else if (this.rootViewFocusedView() != null) {
            this.setFocusedView(this.rootViewFocusedView(), false);
            this._rootViewFocusedView = null;
        }
        this.validateSelectedView();
        this.createMouseEnterLater();
    }

    InternalWindow frontWindowWithLayer(int aLayer) {
        int i = this.windows.count() - 1;
        while (i >= 0) {
            InternalWindow win = (InternalWindow)this.windows.elementAt(i);
            if (win.layer() == aLayer) {
                return win;
            }
            --i;
        }
        return null;
    }

    InternalWindow backWindowWithLayer(int aLayer) {
        int c = this.windows.count();
        int i = 0;
        while (i < c) {
            InternalWindow win = (InternalWindow)this.windows.elementAt(i);
            if (win.layer() == aLayer) {
                return win;
            }
            ++i;
        }
        return null;
    }

    void makeWindowVisible(InternalWindow aWindow, int position, InternalWindow otherWindow) {
        boolean inserted;
        InternalWindow nextWindow = null;
        if (aWindow == null) {
            return;
        }
        if (!aWindow.descendsFrom(this)) {
            return;
        }
        int originalIndex = this.windows.indexOf(aWindow);
        int windowLayer = aWindow.layer();
        if (otherWindow != null) {
            if (otherWindow.layer() > windowLayer) {
                otherWindow = null;
                position = 0;
            } else if (otherWindow.layer() < windowLayer) {
                otherWindow = null;
                position = 1;
            }
        }
        this.windows.removeElement(aWindow);
        if (otherWindow != null) {
            boolean found = position == 0 ? this.windows.insertElementAfter(aWindow, otherWindow) : this.windows.insertElementBefore(aWindow, otherWindow);
            if (found) {
                this._setMainWindow(aWindow);
                if (originalIndex != this.windows.indexOf(aWindow)) {
                    aWindow.draw();
                    this.updateTransWindows(aWindow);
                    if (position == 1) {
                        this.updateWindowsAbove(aWindow);
                    }
                }
                return;
            }
            otherWindow = null;
        }
        int i = this.windows.count();
        while (i-- > 0) {
            nextWindow = (InternalWindow)this.windows.elementAt(i);
            if (nextWindow.layer() <= windowLayer && nextWindow.layer() <= windowLayer) break;
        }
        if (nextWindow == null) {
            this.windows.insertElementAt(aWindow, 0);
            inserted = true;
        } else {
            inserted = nextWindow.layer() > windowLayer ? this.windows.insertElementBefore(aWindow, nextWindow) : this.windows.insertElementAfter(aWindow, nextWindow);
        }
        if (!inserted) {
            this.windows.insertElementAt(aWindow, 0);
        }
        this._setMainWindow(aWindow);
        if (originalIndex != this.windows.indexOf(aWindow)) {
            aWindow.draw();
            this.updateTransWindows(aWindow);
        }
    }

    void updateWindowsAbove(InternalWindow aWindow) {
        Rect windowBounds = this.absoluteWindowBounds(aWindow);
        int index = this.windows.indexOf(aWindow);
        Rect inter = new Rect();
        int i = index + 1;
        int c = this.windows.count();
        while (i < c) {
            InternalWindow win = (InternalWindow)this.windows.elementAt(i);
            Rect winBounds = this.absoluteWindowBounds(win);
            if (windowBounds.intersects(winBounds)) {
                inter.setBounds(windowBounds);
                inter.intersectWith(winBounds);
                this.convertRectToView(win, inter, inter);
                win.addDirtyRect(inter);
            }
            ++i;
        }
    }

    void updateTransWindows(InternalWindow belowWindow) {
        if (belowWindow == null) {
            return;
        }
        int count = this.windows.indexOf(belowWindow);
        Rect belowRect = belowWindow.superview().convertRectToView(this, belowWindow.bounds);
        int i = 0;
        while (i < count) {
            Rect windowBounds;
            InternalWindow nextWindow = (InternalWindow)this.windows.elementAt(i);
            if (nextWindow.isTransparent() && ((windowBounds = this.absoluteWindowBounds(nextWindow)).intersects(belowRect) || belowRect.intersects(windowBounds))) {
                nextWindow.updateDrawingBuffer();
            }
            ++i;
        }
    }

    void disableWindowsAbove(InternalWindow aWindow, boolean flag) {
        if (aWindow == null) {
            return;
        }
        int i = this.windows.indexOf(aWindow);
        if (i == -1) {
            return;
        }
        int count = this.windows.count();
        while (i < count) {
            InternalWindow nextWindow = (InternalWindow)this.windows.elementAt(i);
            if (flag) {
                nextWindow.disableDrawing();
            } else {
                nextWindow.reenableDrawing();
            }
            ++i;
        }
    }

    Vector windowRects(Rect aRect, InternalWindow viewWindow) {
        Vector rectVector = null;
        int count = this.windows.count();
        int i = viewWindow != null ? this.windows.indexOf(viewWindow) + 1 : 0;
        while (i < count) {
            InternalWindow nextWindow = (InternalWindow)this.windows.elementAt(i);
            Rect windowBounds = this.absoluteWindowBounds(nextWindow);
            if (windowBounds.intersects(aRect) || aRect.intersects(windowBounds)) {
                if (rectVector == null) {
                    rectVector = VectorCache.newVector();
                }
                rectVector.addElement(new Rect(windowBounds));
            }
            ++i;
        }
        return rectVector;
    }

    void setRedrawTransparentWindows(boolean flag) {
        this._redrawTransWindows = flag;
    }

    public void redrawTransparentWindows(Rect clipRect, InternalWindow aboveWindow) {
        this.redrawTransparentWindows(null, clipRect, aboveWindow);
    }

    public void redrawTransparentWindows(Graphics g, Rect clipRect, InternalWindow aboveWindow) {
        Rect windowRect = null;
        if (!this._redrawTransWindows) {
            return;
        }
        int count = this.windows.count();
        int i = aboveWindow != null ? this.windows.indexOf(aboveWindow) + 1 : 0;
        while (i < count) {
            Rect windowBounds;
            InternalWindow nextWindow = (InternalWindow)this.windows.elementAt(i);
            if (nextWindow.isTransparent() && (windowBounds = this.absoluteWindowBounds(nextWindow)).intersects(clipRect)) {
                if (windowRect == null) {
                    windowRect = Rect.newRect();
                }
                this.convertRectToView(nextWindow, clipRect, windowRect);
                nextWindow.draw(g, windowRect);
            }
            ++i;
        }
        if (windowRect != null) {
            Rect.returnRect(windowRect);
        }
    }

    void paint(ApplicationEvent updateEvent) {
        UpdateFilter updateFilter = new UpdateFilter(updateEvent.rect());
        updateFilter.rootView = this;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {}
        this.application.eventLoop().filterEvents(updateFilter);
        if (this.redrawAll) {
            Rect clipRect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
            this.redraw(clipRect);
            this.redrawTransparentWindows(clipRect, null);
            Rect.returnRect(clipRect);
        } else {
            this.redraw(updateFilter._rect);
            this.redrawTransparentWindows(updateFilter._rect, null);
        }
        AWTCompatibility.awtToolkit().sync();
    }

    void print(ApplicationEvent printEvent) {
        Rect rect = new Rect(0, 0, this.width(), this.height());
        Graphics ifcGraphics = new Graphics(rect, printEvent.graphics());
        this.redraw(ifcGraphics, rect);
        this.redrawTransparentWindows(ifcGraphics, rect, null);
    }

    void resize(ApplicationEvent resizeEvent) {
        ResizeFilter resizeFilter = new ResizeFilter();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {}
        resizeFilter.lastEvent = resizeEvent;
        this.application.eventLoop().filterEvents(resizeFilter);
        this.sizeTo(resizeFilter.lastEvent.rect().width, resizeFilter.lastEvent.rect().height);
    }

    public void setMouseView(View aView) {
        this._mouseView = aView;
    }

    public View mouseView() {
        return this._mouseView;
    }

    public View viewForMouse(int x, int y) {
        View theView = null;
        int i = this.windows.count();
        while (i-- > 0 && theView == null) {
            InternalWindow nextWindow = (InternalWindow)this.windows.elementAt(i);
            Rect windowBounds = this.absoluteWindowBounds(nextWindow);
            theView = nextWindow.viewForMouse(x - windowBounds.x, y - windowBounds.y);
        }
        if (theView != null) {
            return theView;
        }
        return super.viewForMouse(x, y);
    }

    void _mouseDown(MouseEvent event) {
        ++this.mouseDownCount;
        if (this.mouseDownCount > 1) {
            return;
        }
        View newMouseView = this.viewForMouse(event.x, event.y);
        if (newMouseView == null) {
            this._mouseView = null;
            return;
        }
        long currentTime = event.timeStamp;
        this._clickCount = this._mouseClickView == newMouseView && currentTime - this._lastClickTime < 250L ? ++this._clickCount : 1;
        this._lastClickTime = currentTime;
        event.setClickCount(this._clickCount);
        this._mouseView = this._mouseClickView = newMouseView;
        if (this.viewExcludedFromModalSession(newMouseView)) {
            return;
        }
        if (!(this._mouseView instanceof InternalWindow)) {
            InternalWindow mouseWindow = this._mouseView.window();
            if (!(this._mouseView instanceof MenuView) || mouseWindow != null) {
                this._setMainWindow(mouseWindow);
            }
        }
        event.x -= this._mouseView.absoluteX();
        event.y -= this._mouseView.absoluteY();
        View origMouseView = this._mouseView;
        if (!this._mouseView.mouseDown(event) && origMouseView == this._mouseView) {
            this._mouseView = null;
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    void setVisible(boolean flag) {
        if (this.isVisible != flag) {
            this.isVisible = flag;
            if (this.isVisible) {
                this.ancestorWasAddedToViewHierarchy(this);
                if (this._focusedView != null) {
                    this._focusedView._startFocus();
                    Application.application().focusChanged(this._focusedView);
                    return;
                }
            } else {
                this.ancestorWillRemoveFromViewHierarchy(this);
                if (this._focusedView != null) {
                    this._focusedView._pauseFocus();
                }
            }
        }
    }

    void _mouseDrag(MouseEvent event) {
        if (this.viewExcludedFromModalSession(this._mouseView)) {
            return;
        }
        if (this._mouseView != null) {
            boolean pointIsVisible = this._mouseView.containsPointInVisibleRect(event.x, event.y);
            if (this._mouseView.wantsAutoscrollEvents() && !pointIsVisible) {
                if (this._autoscrollTimer == null) {
                    Autoscroller autoscroller = new Autoscroller();
                    this._autoscrollTimer = new Timer(autoscroller, "autoscroll", 100);
                    this._autoscrollTimer.start();
                    this._autoscrollTimer.setData(this._mouseView);
                    autoscroller.setEvent(this._mouseView.convertEventToView(null, event));
                    return;
                }
                Autoscroller autoscroller = (Autoscroller)this._autoscrollTimer.target();
                autoscroller.setEvent(this._mouseView.convertEventToView(null, event));
                return;
            }
            if (this._autoscrollTimer != null) {
                this._autoscrollTimer.stop();
                this._autoscrollTimer = null;
            }
            event.setClickCount(this._clickCount);
            this._mouseView.mouseDragged(event);
            return;
        }
        if (this._autoscrollTimer != null) {
            this._autoscrollTimer.stop();
            this._autoscrollTimer = null;
        }
    }

    void _mouseUp(MouseEvent event) {
        View newMoveView;
        --this.mouseDownCount;
        if (this.mouseDownCount > 0) {
            return;
        }
        if (this.viewExcludedFromModalSession(this._mouseView)) {
            return;
        }
        if (this._mouseView != null) {
            event.setClickCount(this._clickCount);
            this._mouseView.mouseUp(event);
            if (this._autoscrollTimer != null) {
                this._autoscrollTimer.stop();
                this._autoscrollTimer = null;
            }
        }
        if ((newMoveView = this.viewForMouse(this._mouseX, this._mouseY)) != this._moveView) {
            this.createMouseEnter();
        }
        this._mouseClickView = this._mouseView;
        this._mouseView = null;
    }

    void createMouseEnter() {
        MouseEvent fakeMouseEvent = new MouseEvent(System.currentTimeMillis(), -4, this._mouseX, this._mouseY, 0);
        this._mouseEnter(fakeMouseEvent);
    }

    void createMouseEnterLater() {
        if (this._mouseView == null) {
            this.recomputeMoveView = true;
        }
    }

    void _mouseEnter(MouseEvent event) {
        this._mouseMove(event);
    }

    void _mouseMove(MouseEvent event) {
        View newMoveView = this.viewForMouse(event.x, event.y);
        if (this.viewExcludedFromModalSession(newMoveView)) {
            return;
        }
        if (newMoveView == this._moveView) {
            if (this._moveView == null) {
                return;
            }
            MouseEvent cEvent = this.convertEventToView(this._moveView, event);
            this._moveView.mouseMoved(cEvent);
        } else {
            MouseEvent e;
            View oldMoveView = this._moveView;
            this._moveView = newMoveView;
            if (oldMoveView != null) {
                e = this.convertEventToView(oldMoveView, event);
                e.setType(-6);
                oldMoveView.mouseExited(e);
            }
            if (this._moveView != null) {
                e = this.convertEventToView(this._moveView, event);
                e.setType(-4);
                this._moveView.mouseEntered(e);
            }
        }
        this.updateCursorLater();
    }

    void _mouseExit(MouseEvent event) {
        if (this._moveView != null) {
            this._moveView.mouseExited(this.convertEventToView(this._moveView, event));
            this._moveView = null;
            this.updateCursorLater();
        }
    }

    void flushCursor() {
        int cursorToSet = this._overrideCursor != -1 ? this._overrideCursor : this._viewCursor;
        if (cursorToSet != this._currentCursor) {
            this.panel.setCursor(cursorToSet);
            this._currentCursor = cursorToSet;
        }
    }

    void computeCursor() {
        View underView = this.viewForMouse(this._mouseX, this._mouseY);
        if (underView != null) {
            Point mousePoint = Point.newPoint();
            this.convertToView(underView, this._mouseX, this._mouseY, mousePoint);
            this._viewCursor = underView.cursorForPoint(mousePoint.x, mousePoint.y);
            Point.returnPoint(mousePoint);
        } else {
            this._viewCursor = 0;
        }
        this.flushCursor();
    }

    public int cursor() {
        return this._currentCursor;
    }

    public void setOverrideCursor(int cursorIdent) {
        if (cursorIdent < -1 || cursorIdent > 13) {
            throw new InconsistencyException("Unknown cursor type: " + cursorIdent);
        }
        if (this._overrideCursor != cursorIdent) {
            this._overrideCursor = cursorIdent;
            this.flushCursor();
        }
    }

    public void removeOverrideCursor() {
        this.setOverrideCursor(-1);
    }

    public void updateCursor() {
        this.computeCursor();
    }

    public void updateCursorLater() {
        this.recomputeCursor = true;
    }

    void _updateCursorAndMoveView() {
        if (this.recomputeMoveView) {
            this.createMouseEnter();
            this.recomputeMoveView = false;
            this.recomputeCursor = false;
            return;
        }
        if (this.recomputeCursor) {
            this.computeCursor();
            this.recomputeCursor = false;
        }
    }

    void _keyDown(KeyEvent event) {
        boolean eventHandled = false;
        MenuItem item = null;
        View keyView = this._focusedView;
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null && externalWindow.menu() != null) {
            if (JDK11AirLock.menuShortcutExists()) {
                item = externalWindow.menu().itemForKeyEvent(event);
                if (item != null) {
                    eventHandled = true;
                }
            } else {
                eventHandled = externalWindow.menu().handleCommandKeyEvent(event);
            }
        }
        if (!eventHandled) {
            if (this.processKeyboardEvent(event, true)) {
                return;
            }
            if (keyView != null && !this.viewExcludedFromModalSession(keyView)) {
                keyView.keyDown(event);
                return;
            }
            this.application().keyDown(event);
        }
    }

    void _keyUp(KeyEvent event) {
        View keyView = this._focusedView;
        if (keyView != null && !this.viewExcludedFromModalSession(keyView)) {
            keyView.keyUp(event);
            return;
        }
        this.application().keyUp(event);
    }

    public void showColorChooser() {
        this.colorChooser().show();
    }

    public ColorChooser colorChooser() {
        if (this.colorChooser == null) {
            InternalWindow window = new InternalWindow(0, 0, 10, 10);
            window.setRootView(this);
            this.colorChooser = new ColorChooser();
            this.colorChooser.setWindow(window);
            window.center();
        }
        return this.colorChooser;
    }

    public void showFontChooser() {
        this.fontChooser().show();
    }

    public FontChooser fontChooser() {
        if (this.fontChooser == null) {
            InternalWindow fontWindow = new InternalWindow(0, 0, 1, 1);
            fontWindow.setRootView(this);
            this.fontChooser = new FontChooser();
            this.fontChooser.setWindow(fontWindow);
            fontWindow.center();
        }
        return this.fontChooser;
    }

    public ExternalWindow externalWindow() {
        Container component = this.panel;
        while (component != null) {
            if (component instanceof FoundationFrame) {
                return ((FoundationFrame)component).externalWindow;
            }
            if (component instanceof FoundationDialog) {
                return ((FoundationDialog)component).externalWindow;
            }
            if (component instanceof FoundationWindow) {
                return ((FoundationWindow)component).externalWindow;
            }
            component = component.getParent();
        }
        return null;
    }

    MouseEvent removeMouseEvents(MouseEvent mouseEvent) {
        MouseEvent newEvent = (MouseEvent)this.application.eventLoop().filterEvents(this.mouseFilter);
        if (newEvent != null) {
            return newEvent;
        }
        return mouseEvent;
    }

    void _convertMouseEventToMouseView(MouseEvent mouseEvent) {
        if (this._mouseView == null || mouseEvent == null) {
            return;
        }
        Point mousePoint = Point.newPoint();
        this.convertToView(this._mouseView, mouseEvent.x, mouseEvent.y, mousePoint);
        mouseEvent.x = mousePoint.x;
        mouseEvent.y = mousePoint.y;
        Point.returnPoint(mousePoint);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processEvent(Event event) {
        if (this.application == null) {
            return;
        }
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            int type = mouseEvent.type;
            if (type == -5 && this.mouseDownCount > 0 && this._mouseView != null) {
                MouseEvent e = this.convertEventToView(this._mouseView, mouseEvent);
                e.setType(-3);
                this._mouseUp(e);
            }
            if (type == -2 && this._mouseView != null && this._mouseView.wantsMouseEventCoalescing()) {
                mouseEvent = this.removeMouseEvents(mouseEvent);
                type = mouseEvent.type();
            } else if (type == -5 && this._moveView != null && this._moveView.wantsMouseEventCoalescing()) {
                mouseEvent = this.removeMouseEvents(mouseEvent);
                type = mouseEvent.type();
            }
            this._mouseX = mouseEvent.x;
            this._mouseY = mouseEvent.y;
            switch (type) {
                case -1: {
                    if (this.application.firstRootView() != this) {
                        this.application.makeFirstRootView(this);
                    }
                    this._mouseDown(mouseEvent);
                    return;
                }
                case -2: {
                    this._convertMouseEventToMouseView(mouseEvent);
                    this._mouseDrag(mouseEvent);
                    return;
                }
                case -3: {
                    this._convertMouseEventToMouseView(mouseEvent);
                    this._mouseUp(mouseEvent);
                    return;
                }
                case -4: {
                    if (this._mouseView != null) return;
                    this._mouseEnter(mouseEvent);
                    return;
                }
                case -5: {
                    this._mouseMove(mouseEvent);
                    return;
                }
                case -6: {
                    if (this._mouseView != null) return;
                    this._mouseExit(mouseEvent);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (event instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (this.application.firstRootView() != this) {
                this.application.makeFirstRootView(this);
            }
            if (keyEvent.type == -11) {
                this._keyDown(keyEvent);
                return;
            }
            this._keyUp(keyEvent);
            return;
        }
        if (!(event instanceof ApplicationEvent)) return;
        ExternalWindow externalWindow = null;
        switch (event.type) {
            case -21: {
                this.application.makeFirstRootView(this);
                if (externalWindow != null) {
                    externalWindow.didBecomeMain();
                }
                if (this._focusedView != null) {
                    this._focusedView.resumeFocus();
                    return;
                }
                break;
            }
            case -22: {
                externalWindow = this.externalWindow();
                if (externalWindow != null) {
                    externalWindow.didResignMain();
                }
                if (this._mainWindow != null) {
                    this._setMainWindow(null);
                }
                if (this._focusedView != null) {
                    this._focusedView._pauseFocus();
                    return;
                }
                break;
            }
            case -23: {
                if (this.isVisible) {
                    this.paint((ApplicationEvent)event);
                    return;
                }
                break;
            }
            case -24: {
                if (!this.bounds().equals(((ApplicationEvent)event).rect()) && this.bounds().contains(((ApplicationEvent)event).rect())) {
                    ApplicationEvent updateEvent = new ApplicationEvent();
                    updateEvent.data = ((ApplicationEvent)event).rect();
                    updateEvent.type = -23;
                    updateEvent.setProcessor(this);
                    if (this.application() != null && this.application().eventLoop() != null) {
                        this.application().eventLoop().addEvent(updateEvent);
                    }
                }
                this.resize((ApplicationEvent)event);
                externalWindow = this.externalWindow();
                if (externalWindow != null) {
                    externalWindow.validateBounds();
                    return;
                }
                break;
            }
            case -28: {
                this.print((ApplicationEvent)event);
                return;
            }
        }
    }

    void setFocusedView(View view, boolean hard) {
        if (view != this._focusedView) {
            if (this._focusedView != null) {
                View wasFocusedView = this._focusedView;
                this._focusedView = null;
                if (hard) {
                    wasFocusedView._stopFocus();
                } else {
                    wasFocusedView._pauseFocus();
                }
            } else {
                this._focusedView = null;
            }
            if (this._focusedView == null) {
                this._focusedView = view;
                if (this._focusedView != null) {
                    this._focusedView._startFocus();
                }
            }
            Application.application().focusChanged(this._focusedView);
            Application.application().performCommandLater(this, VALIDATE_SELECTED_VIEW, null, true);
        }
    }

    public void setFocusedView(View view) {
        this.setFocusedView(view, true);
    }

    public View focusedView() {
        return this._focusedView;
    }

    public void performCommand(String command, Object data) {
        if ("showFontChooser".equals(command)) {
            this.showFontChooser();
            return;
        }
        if ("showColorChooser".equals(command)) {
            this.showColorChooser();
            return;
        }
        if ("newFontSelection".equals(command)) {
            if (this.fontChooser != null) {
                this.fontChooser.setFont((Font)data);
                return;
            }
        } else {
            if (VALIDATE_SELECTED_VIEW.equals(command)) {
                this.validateSelectedView();
                return;
            }
            throw new NoSuchMethodError("unknown command: " + command);
        }
    }

    public boolean canPerformCommand(String command) {
        return _commands.contains(command);
    }

    public void setColor(Color aColor) {
        this._backgroundColor = aColor;
    }

    public Color color() {
        return this._backgroundColor;
    }

    public void setImage(Image anImage) {
        this._image = anImage;
    }

    public Image image() {
        return this._image;
    }

    public void setImageDisplayStyle(int aStyle) {
        if (aStyle != 0 && aStyle != 2 && aStyle != 1) {
            throw new InconsistencyException("Unknown image display style: " + aStyle);
        }
        this._imageDisplayStyle = aStyle;
    }

    public int imageDisplayStyle() {
        return this._imageDisplayStyle;
    }

    public boolean isTransparent() {
        return false;
    }

    public void drawView(Graphics g) {
        if ((this._image == null || this._imageDisplayStyle == 0 && (this._image.width() < this.bounds.width || this._image.height() < this.bounds.height)) && this._backgroundColor != null) {
            g.setColor(this._backgroundColor);
            g.fillRect(g.clipRect());
        }
        if (this._image != null) {
            this._image.drawWithStyle(g, 0, 0, this.bounds.width, this.bounds.height, this._imageDisplayStyle);
        }
    }

    public void draw(Graphics g, Rect aRect) {
        InternalWindow nextWindow;
        Vector enableVector = new Vector();
        int i = this.windows.count();
        while (i-- > 0) {
            nextWindow = (InternalWindow)this.windows.elementAt(i);
            if (!nextWindow.isDrawingEnabled()) continue;
            nextWindow.disableDrawing();
            enableVector.addElement(nextWindow);
        }
        super.draw(g, aRect);
        i = enableVector.count();
        while (i-- > 0) {
            nextWindow = (InternalWindow)enableVector.elementAt(i);
            nextWindow.reenableDrawing();
        }
    }

    View viewWithBuffer(View someView, Rect updateRect) {
        View opaqueView = null;
        int i = someView.subviewCount();
        if (i == 0) {
            return null;
        }
        Vector views = someView.subviews();
        Rect subRect = Rect.newRect(0, 0, updateRect.width, updateRect.height);
        while (i-- > 0) {
            View nextView = (View)views.elementAt(i);
            if (nextView instanceof InternalWindow || !nextView.bounds.contains(updateRect)) continue;
            if (nextView.isBuffered()) {
                Rect.returnRect(subRect);
                return nextView;
            }
            nextView.isTransparent();
            subRect.x = updateRect.x - nextView.bounds.x;
            subRect.y = updateRect.y - nextView.bounds.y;
            View bufferView = this.viewWithBuffer(nextView, subRect);
            if (bufferView != null) {
                Rect.returnRect(subRect);
                return bufferView;
            }
            if (opaqueView == null) continue;
            Rect.returnRect(subRect);
            return opaqueView;
        }
        Rect.returnRect(subRect);
        return null;
    }

    void redraw(Graphics g, Rect aRect) {
        View viewForRect;
        InternalWindow nextWindow;
        Rect subRect = Rect.newRect(0, 0, aRect.width, aRect.height);
        if (aRect == null) {
            aRect = new Rect(0, 0, this.bounds.width, this.bounds.height);
        }
        Vector intersectedWindows = VectorCache.newVector();
        this.setRedrawTransparentWindows(false);
        int count = this.windows.count();
        boolean foundWindow = false;
        int i = count;
        while (i-- > 0 && !foundWindow) {
            nextWindow = (InternalWindow)this.windows.elementAt(i);
            Rect windowBounds = this.absoluteWindowBounds(nextWindow);
            if (!windowBounds.intersects(aRect)) continue;
            intersectedWindows.addElement(nextWindow);
            if (nextWindow.isTransparent() || !windowBounds.contains(aRect)) continue;
            foundWindow = true;
        }
        if (!foundWindow) {
            viewForRect = this._viewForRect(aRect, null);
            if (viewForRect != null) {
                this.convertRectToView(viewForRect, aRect, subRect);
                g.pushState();
                g.translate(aRect.x - subRect.x, aRect.y - subRect.y);
                viewForRect.draw(g, subRect);
                g.popState();
            } else {
                this.draw(g, aRect);
            }
        }
        count = intersectedWindows.count();
        i = 0;
        while (i < count) {
            nextWindow = (InternalWindow)intersectedWindows.elementAt(i);
            View windowSuperview = nextWindow.superview();
            this.convertRectToView(windowSuperview, aRect, subRect);
            viewForRect = nextWindow._viewForRect(subRect, windowSuperview);
            if (viewForRect == null) {
                viewForRect = nextWindow;
            }
            this.convertRectToView(viewForRect, aRect, subRect);
            g.pushState();
            g.translate(aRect.x - subRect.x, aRect.y - subRect.y);
            viewForRect.draw(g, subRect);
            g.popState();
            ++i;
        }
        this.setRedrawTransparentWindows(true);
        Rect.returnRect(subRect);
        VectorCache.returnVector(intersectedWindows);
    }

    public void redraw(Rect aRect) {
        Graphics graphics = this.createGraphics();
        this.redraw(graphics, aRect);
        graphics.dispose();
    }

    void redraw() {
        Graphics graphics = this.createGraphics();
        Rect tmpRect = Rect.newRect(0, 0, this.bounds.width, this.bounds.height);
        this.redraw(graphics, tmpRect);
        Rect.returnRect(tmpRect);
        graphics.dispose();
    }

    synchronized void markDirty(View dirtyView) {
        if (this.dirtyViews != null) {
            this.dirtyViews.addElement(dirtyView);
            return;
        }
        throw new InconsistencyException("Don't dirty a View while the list of dirty views is being drawn!");
    }

    synchronized void markClean(View dirtyView) {
        if (this.dirtyViews != null) {
            this.dirtyViews.removeElement(dirtyView);
        }
    }

    public synchronized void resetDirtyViews() {
        Vector tmpDirtyViews = this.dirtyViews;
        this.dirtyViews = null;
        int count = tmpDirtyViews.count();
        int i = 0;
        while (i < count) {
            View dirtyView = (View)tmpDirtyViews.elementAt(i);
            dirtyView.setDirty(false);
            ++i;
        }
        tmpDirtyViews.removeAllElements();
        this.dirtyViews = tmpDirtyViews;
    }

    public synchronized void drawDirtyViews() {
        int count = this.dirtyViews.count();
        if (count == 0) {
            return;
        }
        Vector tmpDirtyViews = this.dirtyViews;
        try {
            View dirtyView;
            this.dirtyViews = null;
            Vector roots = new Vector(count);
            Rect tmp = new Rect();
            int i = 0;
            while (i < count) {
                dirtyView = (View)tmpDirtyViews.elementAt(i);
                this.collectDirtyViews(dirtyView, roots, tmp);
                ++i;
            }
            count = roots.count();
            i = 0;
            while (i < count) {
                dirtyView = (View)roots.elementAt(i);
                dirtyView.draw(dirtyView.dirtyRect);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.dirtyViews = tmpDirtyViews;
            this.resetDirtyViews();
            throw throwable;
        }
        Object var8_7 = null;
        this.dirtyViews = tmpDirtyViews;
        this.resetDirtyViews();
    }

    void collectDirtyViews(View dirtyView, Vector roots, Rect tmp) {
        View rootDirtyView;
        View view = rootDirtyView = dirtyView;
        int rootDx = 0;
        int dx = 0;
        int rootDy = 0;
        int dy = 0;
        tmp.setBounds(0, 0, view.width(), view.height());
        if (dirtyView.dirtyRect != null) {
            tmp.intersectWith(dirtyView.dirtyRect);
        }
        if (tmp.isEmpty()) {
            return;
        }
        do {
            dx += view.bounds.x;
            dy += view.bounds.y;
            tmp.moveBy(view.bounds.x, view.bounds.y);
            view = view.superview();
            if (view == null) continue;
            tmp.intersectWith(0, 0, view.width(), view.height());
            if (tmp.isEmpty()) {
                return;
            }
            if (!view.isDirty()) continue;
            rootDirtyView = view;
            rootDx = dx;
            rootDy = dy;
        } while (view != null && !(view instanceof InternalWindow));
        if (dirtyView != rootDirtyView) {
            tmp.moveBy(rootDx - dx, rootDy - dy);
            rootDirtyView.addDirtyRect(tmp);
        }
        if (!roots.containsIdentical(rootDirtyView)) {
            roots.addElement(rootDirtyView);
        }
    }

    public boolean mouseDown(MouseEvent event) {
        return false;
    }

    public RootView rootView() {
        if (this.panel == null) {
            return super.rootView();
        }
        return this;
    }

    void setPanel(FoundationPanel p) {
        this.panel = p;
    }

    public FoundationPanel panel() {
        return this.panel;
    }

    Application application() {
        return this.application;
    }

    void setApplication(Application a) {
        this.application = a;
    }

    public void setWindowClipView(View aView) {
        this._windowClipView = aView;
    }

    public View windowClipView() {
        return this._windowClipView;
    }

    void addComponentView(AWTComponentView componentView) {
        if (this.componentViews == null) {
            this.componentViews = new Vector();
        }
        this.componentViews.addElement(componentView);
        componentView.setComponentBounds();
        this.panel.add(componentView.component);
    }

    void removeComponentView(AWTComponentView componentView) {
        if (this.componentViews == null) {
            this.componentViews = new Vector();
        }
        this.componentViews.removeElement(componentView);
        this.panel.remove(componentView.component);
    }

    private final void subviewDidResizeOrMove(View aView) {
        KeyboardArrow arrow;
        View v;
        if (this.componentViews != null) {
            int count = this.componentViews.count();
            int i = 0;
            while (i < count) {
                AWTComponentView view = (AWTComponentView)this.componentViews.elementAt(i);
                if (view.descendsFrom(aView)) {
                    view.setComponentBounds();
                }
                ++i;
            }
        }
        this.createMouseEnterLater();
        if (this.application != null && (v = (arrow = this.application.keyboardArrow()).view()) != null && v.rootView() == this) {
            this.updateArrowLocation(arrow);
        }
    }

    public void subviewDidResize(View aView) {
        this.subviewDidResizeOrMove(aView);
    }

    public void subviewDidMove(View aView) {
        this.subviewDidResizeOrMove(aView);
    }

    public boolean canDraw() {
        if (this.panel.getParent() == null) {
            return false;
        }
        return this.isVisible;
    }

    public Point mousePoint() {
        return new Point(this._mouseX, this._mouseY);
    }

    public boolean viewExcludedFromModalSession(View aView) {
        if (aView == null) {
            return true;
        }
        View modalView = Application.application().modalView();
        if (modalView != null && !aView.descendsFrom(modalView)) {
            return !(aView instanceof DragView) && !(aView instanceof InternalWindow);
        }
        return false;
    }

    public void setRedrawAll(boolean flag) {
        this.redrawAll = flag;
    }

    public boolean redrawAll() {
        return this.redrawAll;
    }

    Rect absoluteWindowBounds(InternalWindow window) {
        if (window.superview() != this) {
            return window.superview().convertRectToView(this, window.bounds);
        }
        return window.bounds;
    }

    void viewHierarchyChanged() {
        if (this._focusedView != null && !this._focusedView.descendsFrom(this)) {
            this.setFocusedView(null);
        }
        Application.application().performCommandLater(this, VALIDATE_SELECTED_VIEW, null, true);
    }

    private boolean isInWindow(View aView) {
        if (aView == null) {
            return false;
        }
        if (aView instanceof InternalWindow) {
            return true;
        }
        View superview = aView.superview();
        do {
            if (superview == this) {
                return false;
            }
            if (!(superview instanceof InternalWindow)) continue;
            return true;
        } while ((superview = superview.superview()) != null);
        return false;
    }

    public boolean mouseStillDown() {
        return this.mouseDownCount > 0;
    }

    View rootViewFocusedView() {
        if (this._rootViewFocusedView != null) {
            if (this._rootViewFocusedView.descendsFrom(this)) {
                return this._rootViewFocusedView;
            }
            this._rootViewFocusedView = null;
        }
        return null;
    }

    public void setDefaultSelectedView(View aView) {
        this._defaultSelectedView = aView;
    }

    public View defaultSelectedView() {
        return this._defaultSelectedView;
    }

    public void selectView(View newSelectedView, boolean abortCurrentEditing) {
        View kbdRoot = this.keyboardRootView();
        if (this.application != null && !this.application.isKeyboardUIEnabled() || this._selectedView == kbdRoot || this._selectedView == null) {
            return;
        }
        if (abortCurrentEditing) {
            this.setFocusedView(null);
        }
        if (this._focusedView == null && newSelectedView.canBecomeSelectedView() && newSelectedView.descendsFrom(kbdRoot)) {
            View superview = newSelectedView.superview();
            if (superview != kbdRoot) {
                do {
                    if (!superview.hidesSubviewsFromKeyboard()) continue;
                    newSelectedView = superview;
                } while ((superview = superview.superview()) != kbdRoot);
            }
            this.makeSelectedView(newSelectedView);
            return;
        }
        if (kbdRoot instanceof RootView) {
            ((RootView)kbdRoot).setDefaultSelectedView(newSelectedView);
            return;
        }
        if (kbdRoot instanceof InternalWindow) {
            ((InternalWindow)kbdRoot).setDefaultSelectedView(newSelectedView);
        }
    }

    public void selectViewAfter(View aView) {
        View nextSelectedView = null;
        nextSelectedView = this.findNextView(aView, this.keyboardRootView(), true);
        this.makeSelectedView(nextSelectedView);
    }

    public void selectViewBefore(View aView) {
        View nextSelectedView = null;
        nextSelectedView = this.findNextView(aView, this.keyboardRootView(), false);
        this.makeSelectedView(nextSelectedView);
    }

    void didBecomeFirstRootView() {
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null) {
            externalWindow.didBecomeMain();
        }
        if (this._focusedView != null) {
            this._focusedView._startFocus();
            Application.application().focusChanged(this._focusedView);
        }
        this.application.performCommandLater(this, VALIDATE_SELECTED_VIEW, null, true);
    }

    void didResignFirstRootView() {
        ExternalWindow externalWindow = this.externalWindow();
        if (externalWindow != null) {
            externalWindow.didResignMain();
        }
        if (this._mainWindow != null) {
            this._setMainWindow(null);
        }
        if (this._focusedView != null) {
            this._focusedView._pauseFocus();
        }
        this.application.performCommandLater(this, VALIDATE_SELECTED_VIEW, null, true);
    }

    void makeSelectedView(View nextSelectedView) {
        if (this.application != null && this.application.isKeyboardUIEnabled()) {
            View keyboardRootView = this.keyboardRootView();
            if (nextSelectedView != this._selectedView) {
                if (this._selectedView != null) {
                    this._selectedView.willBecomeUnselected();
                    this._selectedView = null;
                }
                this._selectedView = nextSelectedView;
                if (this._selectedView != null) {
                    if (keyboardRootView instanceof RootView) {
                        ((RootView)keyboardRootView).setDefaultSelectedView(this._selectedView);
                    } else if (keyboardRootView instanceof InternalWindow) {
                        ((InternalWindow)keyboardRootView).setDefaultSelectedView(this._selectedView);
                    }
                    this._selectedView.scrollRectToVisible(new Rect(0, 0, this._selectedView.width(), this._selectedView.height()));
                    this._selectedView.willBecomeSelected();
                }
                this.validateKeyboardArrow();
            }
        }
    }

    void validateKeyboardArrow() {
        if (this.application != null && this.application.isKeyboardUIEnabled()) {
            View needArrowView = null;
            needArrowView = this._selectedView != null && this._selectedView.wantsKeyboardArrow() ? this._selectedView : (this._focusedView != null && this._focusedView.canBecomeSelectedView() && this._focusedView.wantsKeyboardArrow() ? this._focusedView : null);
            if (needArrowView != null) {
                this.showKeyboardArrowForView(needArrowView);
                return;
            }
            this.hideKeyboardArrow();
        }
    }

    void validateSelectedView() {
        if (this.application != null && !this.application.isKeyboardUIEnabled()) {
            return;
        }
        if (this._focusedView != null || this.application != null && this.application.firstRootView() != this) {
            if (this._selectedView != null) {
                this.makeSelectedView(null);
            }
        } else {
            View defaultView;
            View kbdRoot = this.keyboardRootView();
            if (this._selectedView != null && this._selectedView.descendsFrom(kbdRoot)) {
                boolean opaqueNodeFound = false;
                if (!(this._selectedView instanceof InternalWindow) && !(this._selectedView instanceof RootView) || this._selectedView == kbdRoot) {
                    if (this._selectedView != kbdRoot) {
                        View superview = this._selectedView.superview();
                        while (superview != null && superview != kbdRoot) {
                            if (superview.hidesSubviewsFromKeyboard()) {
                                opaqueNodeFound = true;
                                break;
                            }
                            superview = superview.superview();
                        }
                    }
                    if (!opaqueNodeFound) {
                        return;
                    }
                    this.makeSelectedView(null);
                }
            }
            if ((defaultView = kbdRoot instanceof RootView ? ((RootView)kbdRoot).defaultSelectedView() : (kbdRoot instanceof InternalWindow ? ((InternalWindow)kbdRoot).defaultSelectedView() : null)) != null && defaultView.descendsFrom(kbdRoot)) {
                this.makeSelectedView(defaultView);
            } else {
                this.selectNextSelectableView();
            }
        }
        this.validateKeyboardArrow();
    }

    void selectNextSelectableView() {
        View kbdRoot = this.keyboardRootView();
        View nextSelectedView = null;
        nextSelectedView = this._selectedView != null && this._selectedView.descendsFrom(kbdRoot) ? this.findNextView(this._selectedView, kbdRoot, true) : this.findNextView(null, kbdRoot, true);
        this.makeSelectedView(nextSelectedView);
    }

    void selectPreviousSelectableView() {
        View kbdRoot = this.keyboardRootView();
        View nextSelectedView = null;
        nextSelectedView = this._selectedView != null && this._selectedView.descendsFrom(kbdRoot) ? this.findNextView(this._selectedView, kbdRoot, false) : this.findNextView(null, kbdRoot, false);
        this.makeSelectedView(nextSelectedView);
    }

    boolean processKeyboardEvent(KeyEvent anEvent, boolean commandModifierOnly) {
        View view;
        if (this.application != null && !this.application.isKeyboardUIEnabled() || this.subviews().count() == 0) {
            return false;
        }
        if (commandModifierOnly && !anEvent.isControlKeyDown()) {
            return false;
        }
        if (!commandModifierOnly && anEvent.isControlKeyDown()) {
            return false;
        }
        View kbdRoot = this.keyboardRootView();
        this.validateSelectedView();
        if (!commandModifierOnly && (anEvent.isTabKey() || anEvent.isBackTabKey())) {
            if (anEvent.isBackTabKey()) {
                this.selectPreviousSelectableView();
            } else {
                this.selectNextSelectableView();
            }
            return true;
        }
        KeyStroke ks = new KeyStroke(anEvent);
        if (this._selectedView != null) {
            if (this._selectedView.performCommandForKeyStroke(ks, 0)) {
                return true;
            }
            if (this._selectedView != kbdRoot) {
                view = this._selectedView.superview();
                while (view != kbdRoot) {
                    if (view.performCommandForKeyStroke(ks, 1)) {
                        return true;
                    }
                    view = view.superview();
                }
            }
        }
        view = kbdRoot;
        do {
            if (!(view = this.nextView(view, kbdRoot, true, true, false)).performCommandForKeyStroke(ks, 1)) continue;
            return true;
        } while (view != kbdRoot);
        view = this;
        do {
            if (!(view = this.nextView(view, this, true, true, true)).performCommandForKeyStroke(ks, 2)) continue;
            return true;
        } while (view != this);
        return false;
    }

    private View nextView(View view, View root, boolean canGoDown, boolean moveForward, boolean includingInternalWindows) {
        View nsv = null;
        if (view == root && canGoDown) {
            Vector sub = root.subviews();
            if (sub.count() > 0) {
                if (moveForward) {
                    return root.firstSubview();
                }
                return root.lastSubview();
            }
            return null;
        }
        if (canGoDown && (!view.hidesSubviewsFromKeyboard() || includingInternalWindows && view instanceof InternalWindow) && view.subviews().count() > 0) {
            if (moveForward) {
                return view.firstSubview();
            }
            return view.lastSubview();
        }
        View superView = view.superview();
        if (moveForward ? (nsv = superView.viewAfter(view)) != null : (nsv = superView.viewBefore(view)) != null) {
            return nsv;
        }
        if (superView == root) {
            return root;
        }
        return this.nextView(superView, root, false, moveForward, includingInternalWindows);
    }

    private View findNextView(View selectedView, View root, boolean moveForward) {
        View initialView;
        if (root == null) {
            return null;
        }
        if (selectedView == null) {
            return root;
        }
        View nextView = initialView = selectedView;
        while ((nextView = this.nextView(nextView, root, true, moveForward, false)) != null && nextView != initialView && !nextView.canBecomeSelectedView()) {
        }
        return nextView;
    }

    private View keyboardRootView() {
        View modalView = Application.application().modalView();
        if (modalView != null && modalView.isInViewHierarchy()) {
            return modalView;
        }
        InternalWindow mainWindow = this.mainWindow();
        if (mainWindow != null) {
            return mainWindow;
        }
        if (this.application != null && this.application.firstRootView() != null) {
            return this.application.firstRootView();
        }
        return this;
    }

    void showKeyboardArrowForView(View aView) {
        if (this.application != null) {
            KeyboardArrow arrow = this.application.keyboardArrow();
            if (arrow.view() == aView) {
                return;
            }
            arrow.setRootView(this);
            arrow.setView(aView);
            this.updateArrowLocation(arrow);
            arrow.show();
        }
    }

    void updateArrowLocation(KeyboardArrow arrow) {
        View aView = arrow.view();
        int position = this.application.keyboardArrowPosition(aView);
        Image arrowImage = this.application.keyboardArrowImage(position);
        Point arrowHotSpot = this.application.keyboardArrowHotSpot(position);
        Point arrowLocation = this.application.keyboardArrowLocation(aView, position);
        arrowLocation.x -= arrowHotSpot.x;
        arrowLocation.y -= arrowHotSpot.y;
        if (this.windowClipView() != null) {
            this.convertPointToView(this.windowClipView(), arrowLocation, arrowLocation);
        }
        arrow.setImage(arrowImage);
        arrow.moveTo(arrowLocation.x, arrowLocation.y);
    }

    void hideKeyboardArrow() {
        KeyboardArrow arrow;
        if (this.application != null && (arrow = this.application.keyboardArrow()).rootView() == this) {
            arrow.hide();
            arrow.setRootView(null);
            arrow.setView(null);
        }
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    boolean wantsKeyboardArrow() {
        return false;
    }

    public void adjustForExpectedMouseDownCount() {
        if (!this.application.jdkMouseEventHackEnabled) {
            return;
        }
        if (this.mouseDownCount < 1) {
            MouseEvent me = new MouseEvent(0L, -1, -1, -1, 0);
            while (this.mouseDownCount < 1) {
                this._mouseDown(me);
            }
        }
    }

    static {
        _commands.addElement("showFontChooser");
        _commands.addElement("showColorChooser");
        _commands.addElement("newFontSelection");
        _commands.addElement(VALIDATE_SELECTED_VIEW);
    }
}

