/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextParagraphFormat;
import netscape.application.TextStyleRun;

class TextPositionInfo {
    public TextStyleRun _textRun;
    public int _x;
    public int _y;
    public int _lineNumber;
    public int _lineHeight;
    public int _absPosition;
    public int _positionInRun;
    public int _updateLine;
    public boolean _redrawCurrentLineOnly;
    public boolean _redrawCurrentParagraphOnly;
    public boolean _nextLine;
    public boolean _endOfLine;
    public boolean _endOfParagraph;

    TextPositionInfo() {
    }

    TextPositionInfo(TextStyleRun theRun, int x, int y, int lineNumber, int lineHeight, int runPosition, int absPosition) {
        this();
        this.init(theRun, x, y, lineNumber, lineHeight, runPosition, absPosition);
    }

    TextPositionInfo(TextPositionInfo aPosition) {
        this();
        this.init(aPosition._textRun, aPosition._x, aPosition._y, aPosition._lineNumber, aPosition._lineHeight, aPosition._positionInRun, aPosition._absPosition);
    }

    public String toString() {
        return "run is " + this._textRun + " x is " + this._x + " y is " + this._y + " lineNumber is " + this._lineNumber + "line height is: " + this._lineHeight + "positionInRun is " + this._positionInRun + "position is:" + this._absPosition + "endOfLine is " + this._endOfLine + "_endOfParagraph is " + this._endOfParagraph;
    }

    void init(TextStyleRun theRun, int x, int y, int lineNumber, int lineHeight, int runPosition, int absPosition) {
        this._textRun = theRun;
        this._x = x;
        this._y = y;
        this._lineNumber = lineNumber;
        this._lineHeight = lineHeight;
        this._positionInRun = runPosition;
        this._absPosition = absPosition;
        this._updateLine = this._lineNumber;
    }

    void init(TextPositionInfo aPosition) {
        this.init(aPosition._textRun, aPosition._x, aPosition._y, aPosition._lineNumber, aPosition._lineHeight, aPosition._positionInRun, aPosition._absPosition);
    }

    void representCharacterAfterEndOfLine() {
        if (this._endOfLine) {
            TextParagraphFormat f = this._textRun.paragraph().currentParagraphFormat();
            this._x = f._leftMargin + f._leftIndent;
            if (f.wrapsUnderFirstCharacter()) {
                this._x = f._leftMargin + (this._textRun.paragraph().addWidthOfInitialTabs(f._leftMargin + f._leftIndent) - f._leftIndent);
            }
            this._y += this._lineHeight;
            ++this._lineNumber;
            this._lineHeight = this._textRun.paragraph()._lineHeights[this._lineNumber];
            this._endOfLine = false;
        }
    }

    void representCharacterBeforeEndOfLine() {
        TextPositionInfo info = this._textRun._paragraph._owner.positionInfoForIndex(this._absPosition);
        if (info._endOfLine) {
            this._textRun = info._textRun;
            this._x = info._x;
            this._y = info._y;
            this._absPosition = info._absPosition;
            this._lineNumber = info._lineNumber;
            this._lineHeight = info._lineHeight;
            this._positionInRun = info._positionInRun;
            this._updateLine = info._updateLine;
            this._redrawCurrentLineOnly = info._redrawCurrentLineOnly;
            this._redrawCurrentParagraphOnly = info._redrawCurrentParagraphOnly;
            this._nextLine = info._nextLine;
            this._endOfLine = info._endOfLine;
            this._endOfParagraph = info._endOfParagraph;
        }
    }

    void setUpdateLine(int lineNumber) {
        this._updateLine = lineNumber;
    }

    void setRedrawCurrentLineOnly(boolean flag) {
        this._redrawCurrentLineOnly = flag;
    }

    void setRedrawCurrentParagraphOnly(boolean flag) {
        this._redrawCurrentParagraphOnly = flag;
    }

    void setX(int anInt) {
        this._x = anInt;
    }

    void setAbsPosition(int absPosition) {
        this._absPosition = absPosition;
    }

    void setPositionInRun(int anInt) {
        this._positionInRun = anInt;
    }

    void moveBy(int deltaX, int deltaY) {
        this._x += deltaX;
        this._y += deltaY;
    }

    int maxY() {
        return this._y + this._lineHeight;
    }

    Rect lineBounds() {
        return this._textRun._paragraph.rectForLine(this._lineNumber);
    }

    Range lineRange() {
        return this._textRun._paragraph.rangeForLine(this._lineNumber);
    }

    void setNextLine(boolean flag) {
        this._nextLine = flag;
    }

    void setAtEndOfLine(boolean flag) {
        this._endOfLine = flag;
    }

    void setAtEndOfParagraph(boolean flag) {
        this._endOfParagraph = flag;
    }
}

