/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.FastStringBuffer;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextAttachment;
import netscape.application.TextParagraph;
import netscape.application.TextView;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.Hashtable;
import netscape.util.Vector;

public class TextStyleRun
implements Codable {
    private static final String CONTENTS_KEY = "contents";
    private static final String ATTRIBUTES_KEY = "attributes";
    TextParagraph _paragraph;
    FastStringBuffer _contents;
    Hashtable _attributes;
    FontMetrics _fontMetricsCache;
    int _remainder;

    public TextStyleRun() {
    }

    TextStyleRun(TextParagraph owner) {
        this();
        this.init(owner);
    }

    TextStyleRun(TextParagraph owner, String contents, Hashtable attributes) {
        this();
        this.init(owner, contents, attributes);
    }

    TextStyleRun(TextParagraph owner, String aString, int firstIndex, int lastIndex, Hashtable attributes) {
        this();
        this.init(owner, aString, firstIndex, lastIndex, attributes);
    }

    void init(TextParagraph owner) {
        this._paragraph = owner;
    }

    void init(TextParagraph owner, String contents, Hashtable attributes) {
        this.init(owner);
        this.setText(contents);
        this.setAttributes(attributes);
    }

    void init(TextParagraph owner, String contents, int firstIndex, int lastIndex, Hashtable attributes) {
        this.init(owner);
        this.setText(contents, firstIndex, lastIndex);
        this.setAttributes(attributes);
    }

    TextStyleRun createEmptyRun() {
        return new TextStyleRun(this._paragraph, "", TextView.attributesByRemovingStaticAttributes(this._attributes));
    }

    TextStyleRun createEmptyRun(Hashtable attributes) {
        return new TextStyleRun(this._paragraph, "", attributes);
    }

    void setParagraph(TextParagraph aParagraph) {
        this._paragraph = aParagraph;
    }

    TextParagraph paragraph() {
        return this._paragraph;
    }

    void setText(String text) {
        this._contents = new FastStringBuffer(text);
    }

    void setText(String text, int firstIndex, int lastIndex) {
        this._contents = new FastStringBuffer(text, firstIndex, lastIndex);
    }

    void setText(StringBuffer text) {
        this.setText(text.toString());
    }

    int rangeIndex() {
        int result = this._paragraph._startChar;
        Vector v = this._paragraph.runsBefore(this);
        int i = 0;
        int c = v.count();
        while (i < c) {
            result += ((TextStyleRun)v.elementAt(i)).charCount();
            ++i;
        }
        return result;
    }

    Range range() {
        return TextView.allocateRange(this.rangeIndex(), this.charCount());
    }

    private Font getFont() {
        Font f = null;
        if (this._paragraph.owner().usesSingleFont()) {
            f = (Font)this._paragraph.owner().defaultAttributes().get("FontKey");
            return f;
        }
        if (this._attributes != null) {
            f = (Font)this._attributes.get("FontKey");
        }
        if (f == null) {
            f = (Font)this._paragraph.owner().defaultAttributes().get("FontKey");
        }
        return f;
    }

    private Color getColor() {
        Color c = null;
        c = this._attributes != null ? (this._attributes.get("LinkKey") != null ? (this._attributes.get("_IFCLinkPressedKey") != null ? (Color)this._attributes.get("PressedLinkColorKey") : (Color)this._attributes.get("LinkColorKey")) : (Color)this._attributes.get("TextColorKey")) : (Color)this._paragraph.owner().defaultAttributes().get("TextColorKey");
        return c;
    }

    private void validateFontMetricsCache() {
        if (this._paragraph.owner().usesSingleFont() || this._attributes == null || this._attributes.get("FontKey") == null) {
            this._fontMetricsCache = this._paragraph.owner().defaultFontMetrics();
            return;
        }
        if (this._fontMetricsCache == null) {
            this._fontMetricsCache = this.getFont().fontMetrics();
        }
    }

    private void invalidateFontMetricsCache() {
        this._fontMetricsCache = null;
    }

    boolean containsATextAttachment() {
        return this._attributes != null && this._attributes.get("TextAttachmentKey") != null;
    }

    Rect textAttachmentBoundsForOrigin(int x, int y, int baseline) {
        TextAttachment att;
        Rect result = new Rect();
        if (this._attributes != null && (att = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            result.x = x;
            result.y = y + baseline - att.height() + this.attachmentBaselineOffset();
            result.width = att.width();
            result.height = att.height();
            return result;
        }
        return null;
    }

    char charAt(int index) {
        FastStringBuffer buffer = this._contents;
        if (buffer.length() == 0 || index >= buffer.length()) {
            return '\u0000';
        }
        return buffer.charAt(index);
    }

    void insertCharAt(char aChar, int index) {
        if (this._contents == null) {
            FastStringBuffer buffer;
            this._contents = buffer = new FastStringBuffer(aChar);
            return;
        }
        FastStringBuffer buffer = this._contents;
        buffer.insert(aChar, index);
    }

    void insertStringAt(String aString, int index) {
        if (index < 0 || aString == null) {
            return;
        }
        if (this._contents == null) {
            FastStringBuffer buffer;
            this._contents = buffer = new FastStringBuffer(aString);
            return;
        }
        FastStringBuffer buffer = this._contents;
        buffer.insert(aString, index);
    }

    void removeCharAt(int index) {
        FastStringBuffer buffer = this._contents;
        if (buffer.length() == 0 || index >= buffer.length()) {
            return;
        }
        buffer.removeCharAt(index);
    }

    TextStyleRun breakAt(int index) {
        FastStringBuffer buffer = this._contents;
        if (buffer.length() == 0 || index >= buffer.length()) {
            return this.createEmptyRun(TextView.attributesByRemovingStaticAttributes(this._attributes));
        }
        String theString = buffer.toString();
        TextStyleRun newRun = new TextStyleRun(this._paragraph, theString.substring(index, buffer.length()), TextView.attributesByRemovingStaticAttributes(this._attributes));
        buffer.truncateToLength(index);
        return newRun;
    }

    void cutBefore(int index) {
        FastStringBuffer buffer = this._contents;
        if (buffer.length() == 0 || index >= buffer.length()) {
            return;
        }
        buffer.moveChars(index, 0);
    }

    void cutAfter(int index) {
        FastStringBuffer buffer = this._contents;
        if (buffer.length() == 0 || index >= buffer.length()) {
            return;
        }
        buffer.truncateToLength(index);
    }

    String text() {
        return this._contents.toString();
    }

    public String toString() {
        String res = "";
        res = this._attributes != null ? String.valueOf(res) + this._attributes.toString() : String.valueOf(res) + "{DefAttr}";
        res = String.valueOf(res) + "**(";
        res = String.valueOf(res) + this._contents.toString();
        res = String.valueOf(res) + ")**";
        return res;
    }

    int charCount() {
        return this._contents.length();
    }

    int attachmentBaselineOffset() {
        Integer integer;
        if (this._attributes != null && (integer = (Integer)this._attributes.get("TextAttachmentBaselineOffsetKey")) != null) {
            return integer;
        }
        return 0;
    }

    int height() {
        TextAttachment theItem;
        if (this._attributes != null && (theItem = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int baselineOffset = this.attachmentBaselineOffset();
            if (baselineOffset > 0) {
                return Math.max(theItem.height(), baselineOffset);
            }
            return theItem.height() + Math.abs(baselineOffset);
        }
        this.validateFontMetricsCache();
        return this._fontMetricsCache.ascent() + this._fontMetricsCache.descent();
    }

    int baseline() {
        TextAttachment theItem;
        if (this._attributes != null && (theItem = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int baselineOffset = this.attachmentBaselineOffset();
            return Math.max(theItem.height() - baselineOffset, 0);
        }
        this.validateFontMetricsCache();
        return this._fontMetricsCache.ascent();
    }

    int _widthForTab(int position, int[] tabStops) {
        if (tabStops == null) {
            return 0;
        }
        int i = 0;
        while (i < tabStops.length) {
            if (position < tabStops[i]) {
                return tabStops[i] - position;
            }
            ++i;
        }
        return 0;
    }

    int _breakForSubstring(int startingChar, int count, int availableWidth) {
        int width = this._widthOfSubstring(startingChar, count, 0, null);
        while (width > availableWidth && count > 0) {
            width = this._widthOfSubstring(startingChar, --count, 0, null);
        }
        return count;
    }

    int charsForWidth(int startingChar, int currentX, int availableWidth, int maxAvailableWidth, int[] tabStops) {
        int spaceWidth;
        int wordWidth;
        int width;
        TextAttachment theItem;
        int tabPosition = -1;
        char[] buf = new char[1];
        if (this._contents == null) {
            this._remainder = availableWidth;
            return 0;
        }
        if (this._attributes != null && (theItem = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            if (theItem.width() > maxAvailableWidth) {
                if (width == maxAvailableWidth) {
                    this._remainder = 0;
                    return 1;
                }
                return 0;
            }
            if (theItem.width() <= width) {
                this._remainder = width - theItem.width();
                return 1;
            }
            this._remainder = width;
            return 0;
        }
        this.validateFontMetricsCache();
        int[] charWidths = this._fontMetricsCache.widthsArray();
        int count = this._contents.length();
        int i = startingChar;
        for (width = availableWidth; i < count && width > 0; width -= wordWidth + spaceWidth) {
            spaceWidth = 0;
            wordWidth = 0;
            int start = i;
            int breakPoint = -1;
            while (i < count && this._contents.buffer[i] != ' ' && this._contents.buffer[i] != '\t') {
                if (this._contents.buffer[i] < '\u0100') {
                    wordWidth += charWidths[this._contents.buffer[i]];
                } else {
                    buf[0] = this._contents.buffer[i];
                    wordWidth += this._fontMetricsCache.stringWidth(new String(buf));
                }
                ++i;
                if (wordWidth <= width || breakPoint != -1) continue;
                breakPoint = i;
                break;
            }
            if (i < count && (this._contents.buffer[i] == ' ' || this._contents.buffer[i] == '\t')) {
                while (i < count && (this._contents.buffer[i] == ' ' || this._contents.buffer[i] == '\t')) {
                    if (this._contents.buffer[i] == ' ') {
                        spaceWidth += charWidths[32];
                    } else {
                        spaceWidth += this._widthForTab(currentX + wordWidth + spaceWidth, tabStops);
                        if (tabPosition == -1) {
                            tabPosition = i;
                        }
                    }
                    ++i;
                }
            }
            if (wordWidth + spaceWidth <= width) {
                continue;
            }
            if (width <= maxAvailableWidth && wordWidth <= width) {
                width -= wordWidth;
                break;
            }
            if (wordWidth > width && width >= maxAvailableWidth) {
                count = breakPoint != -1 ? this._breakForSubstring(start, breakPoint - start, width) : this._breakForSubstring(start, i - start, width);
                if (count > 0) {
                    i = startingChar + count;
                    width -= this._widthOfSubstring(startingChar, count, 0, null);
                    break;
                }
                i = start;
                break;
            }
            i = start;
            break;
        }
        this._remainder = width > 0 ? width : 0;
        if (i == startingChar && width == maxAvailableWidth) {
            this._remainder = 0;
            return 1;
        }
        return i - startingChar;
    }

    int _widthOfSubstring(int start, int count, int currentX, int[] tabStops) {
        int width = 0;
        char[] buf = new char[1];
        this.validateFontMetricsCache();
        int[] charWidths = this._fontMetricsCache.widthsArray();
        int endChar = start + count;
        int i = start;
        while (i < endChar) {
            if (this._contents.buffer[i] == '\t' && tabStops != null) {
                width += this._widthForTab(currentX + width, tabStops);
            } else if (this._contents.buffer[i] < '\u0100') {
                width += charWidths[this._contents.buffer[i]];
            } else {
                buf[0] = this._contents.buffer[i];
                width += this._fontMetricsCache.stringWidth(new String(buf));
            }
            ++i;
        }
        return width;
    }

    int widthOfContents(int startingChar, int charCount, int currentX, int[] tabStops) {
        TextAttachment theItem;
        if (this._attributes != null && (theItem = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            return theItem.width();
        }
        this.validateFontMetricsCache();
        if (charCount == 0) {
            return 0;
        }
        if (startingChar < 0) {
            startingChar = 0;
        }
        if (startingChar + charCount > this._contents.length()) {
            charCount = this._contents.length() - startingChar;
        }
        return this._widthOfSubstring(startingChar, charCount, currentX, tabStops);
    }

    int drawCharacters(Graphics g, int startingChar, int charCount, int x, int y, int[] tabStops) {
        TextAttachment theItem;
        if (g == null) {
            return 0;
        }
        if (this._attributes != null && (theItem = (TextAttachment)this._attributes.get("TextAttachmentKey")) != null) {
            int baselineOffset = this.attachmentBaselineOffset();
            Rect tmpRect = Rect.newRect(x, y - theItem.height() + baselineOffset, 0, 0);
            tmpRect.width = theItem.width();
            tmpRect.height = theItem.height();
            theItem.drawInRect(g, tmpRect);
            Rect.returnRect(tmpRect);
            return theItem.width();
        }
        this.validateFontMetricsCache();
        if (this._fontMetricsCache == null || charCount <= 0) {
            return 0;
        }
        g.setFont(this.getFont());
        g.setColor(this.getColor());
        if (startingChar < 0) {
            startingChar = 0;
        }
        if (startingChar + charCount > this._contents.length()) {
            charCount = this._contents.length() - startingChar;
        }
        char[] charArray = this._contents.charArray();
        int[] charWidths = this._fontMetricsCache.widthsArray();
        int endChar = startingChar + charCount;
        int totalWidth = 0;
        while (startingChar < endChar) {
            int nextTab = this._contents.indexOf('\t', startingChar);
            int count = nextTab == -1 ? endChar - startingChar : nextTab - startingChar;
            if (count > 0) {
                g.drawChars(charArray, startingChar, count, x, y);
            }
            if (nextTab != -1) {
                ++count;
            }
            int width = this._widthOfSubstring(startingChar, count, x, tabStops);
            x += width;
            totalWidth += width;
            startingChar += count;
        }
        return totalWidth;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.TextStyleRun", 1);
        info.addField(CONTENTS_KEY, (byte)16);
        info.addField(ATTRIBUTES_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeString(CONTENTS_KEY, this._contents.toString());
        encoder.encodeObject(ATTRIBUTES_KEY, this._attributes);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._contents = new FastStringBuffer(decoder.decodeString(CONTENTS_KEY));
        this._attributes = (Hashtable)decoder.decodeObject(ATTRIBUTES_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    void setAttributes(Hashtable attributes) {
        if (attributes != null) {
            this.invalidateFontMetricsCache();
            this._attributes = (Hashtable)attributes.clone();
        } else {
            this._attributes = null;
        }
        if (this._attributes != null && this._attributes.get("ParagraphFormatKey") != null) {
            this._attributes.remove("ParagraphFormatKey");
        }
    }

    void appendAttributes(Hashtable attributes) {
        if (attributes == null) {
            return;
        }
        if (this._attributes == null) {
            this._attributes = (Hashtable)this._paragraph.owner().defaultAttributes().clone();
        }
        Enumeration keys = attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("FontKey")) {
                this.invalidateFontMetricsCache();
            }
            this._attributes.put(key, attributes.get(key));
        }
    }

    Hashtable attributes() {
        if (this._attributes != null) {
            this._attributes.put("ParagraphFormatKey", this._paragraph.currentParagraphFormat());
            return this._attributes;
        }
        return null;
    }
}

