/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.InconsistencyException;

public class IdHashtable {
    static final int A = -1640531527;
    static final int NOT_FOUND = 0;
    int power;
    int count;
    int maxCount;
    int indexMask;
    Object[] keys;
    int[] values;
    boolean equals;

    IdHashtable(boolean equals) {
        this.equals = equals;
        this.power = 5;
        this.count = 0;
        this.indexMask = (1 << this.power) - 1;
        this.maxCount = 3 * (1 << this.power) / 4;
        this.keys = new Object[1 << this.power];
        this.values = new int[1 << this.power];
    }

    private boolean equalKeys(Object keyA, Object keyB) {
        if (keyA == keyB) {
            return true;
        }
        if (this.equals) {
            return keyA.equals(keyB);
        }
        return false;
    }

    private void rehash() {
        int oldLength = this.keys.length;
        Object[] oldKeys = this.keys;
        int[] oldValues = this.values;
        ++this.power;
        this.count = 0;
        this.indexMask = (1 << this.power) - 1;
        this.maxCount = 3 * (1 << this.power) / 4;
        this.keys = new Object[1 << this.power];
        this.values = new int[1 << this.power];
        int i = 0;
        while (i < oldLength) {
            if (oldKeys[i] != null) {
                this.putKnownAbsent(oldKeys[i], oldValues[i]);
            }
            ++i;
        }
    }

    int get(Object object) {
        int product = object.hashCode() * -1640531527;
        int index = product >>> 32 - this.power;
        Object key = this.keys[index];
        if (key == null) {
            return 0;
        }
        if (this.equalKeys(key, object)) {
            return this.values[index];
        }
        int step = product >>> 32 - 2 * this.power & this.indexMask | 1;
        int probeCount = 1;
        do {
            ++probeCount;
            key = this.keys[index = index + step & this.indexMask];
            if (key == null) {
                return 0;
            }
            if (!this.equalKeys(key, object)) continue;
            return this.values[index];
        } while (probeCount <= this.count);
        throw new InconsistencyException("IdHashtable overflow");
    }

    void putKnownAbsent(Object object, int id) {
        int product;
        int index;
        if (this.count >= this.maxCount) {
            this.rehash();
        }
        if (this.keys[index = (product = object.hashCode() * -1640531527) >>> 32 - this.power] == null) {
            this.keys[index] = object;
            this.values[index] = id;
            ++this.count;
            return;
        }
        int step = product >>> 32 - 2 * this.power & this.indexMask | 1;
        int probeCount = 1;
        do {
            ++probeCount;
            if (this.keys[index = index + step & this.indexMask] != null) continue;
            this.keys[index] = object;
            this.values[index] = id;
            ++this.count;
            return;
        } while (probeCount <= this.count);
        throw new InconsistencyException("IdHashtable overflow");
    }
}

